/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.groups;

import io.smallrye.common.annotation.CheckReturnValue;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.operators.multi.MultiWindowOnDurationOp;
import io.smallrye.mutiny.operators.multi.MultiWindowOp;
import java.time.Duration;

public class MultiGroupIntoMultis<T> {
    private final Multi<T> upstream;

    public MultiGroupIntoMultis(Multi<T> upstream) {
        this.upstream = ParameterValidation.nonNull(upstream, "upstream");
    }

    @CheckReturnValue
    public Multi<Multi<T>> every(Duration duration) {
        return Infrastructure.onMultiCreation(new MultiWindowOnDurationOp<T>(this.upstream, ParameterValidation.validate(duration, "duration"), Infrastructure.getDefaultWorkerPool()));
    }

    @CheckReturnValue
    public Multi<Multi<T>> of(int size) {
        int validated = ParameterValidation.positive(size, "size");
        return Infrastructure.onMultiCreation(new MultiWindowOp<T>(this.upstream, validated, validated));
    }

    @CheckReturnValue
    public Multi<Multi<T>> of(int size, int skip) {
        return Infrastructure.onMultiCreation(new MultiWindowOp<T>(this.upstream, ParameterValidation.positive(size, "size"), ParameterValidation.positive(skip, "skip")));
    }
}

