/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol;

import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.keycloak.Config;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.protocol.LoginProtocolFactory;
import org.keycloak.provider.ProviderEvent;
import org.keycloak.provider.ProviderEventListener;
import org.keycloak.representations.idm.ClientScopeRepresentation;

public abstract class AbstractLoginProtocolFactory
implements LoginProtocolFactory {
    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
        factory.register(new ProviderEventListener(){

            public void onEvent(ProviderEvent event) {
                if (event instanceof ClientModel.ClientProtocolUpdatedEvent) {
                    ClientModel client = ((ClientModel.ClientProtocolUpdatedEvent)event).getClient();
                    AbstractLoginProtocolFactory.this.addDefaultClientScopes(client.getRealm(), client);
                    AbstractLoginProtocolFactory.this.addDefaults(client);
                }
            }
        });
    }

    @Override
    public void createDefaultClientScopes(RealmModel newRealm, boolean addScopesToExistingClients) {
        this.createDefaultClientScopesImpl(newRealm);
        if (addScopesToExistingClients) {
            this.addDefaultClientScopes(newRealm, newRealm.getClientsStream());
        }
    }

    protected abstract void createDefaultClientScopesImpl(RealmModel var1);

    protected void addDefaultClientScopes(RealmModel realm, ClientModel newClient) {
        this.addDefaultClientScopes(realm, Stream.of(newClient));
    }

    protected void addDefaultClientScopes(RealmModel realm, Stream<ClientModel> newClients) {
        Set defaultClientScopes = realm.getDefaultClientScopesStream(true).filter(clientScope -> Objects.equals(this.getId(), clientScope.getProtocol())).collect(Collectors.toSet());
        Set nonDefaultClientScopes = realm.getDefaultClientScopesStream(false).filter(clientScope -> Objects.equals(this.getId(), clientScope.getProtocol())).collect(Collectors.toSet());
        Consumer<ClientModel> addDefault = c -> c.addClientScopes(defaultClientScopes, true);
        Consumer<ClientModel> addNonDefault = c -> c.addClientScopes(nonDefaultClientScopes, false);
        if (!defaultClientScopes.isEmpty() && !nonDefaultClientScopes.isEmpty()) {
            newClients.forEach(addDefault.andThen(addNonDefault));
        } else if (!defaultClientScopes.isEmpty()) {
            newClients.forEach(addDefault);
        } else if (!nonDefaultClientScopes.isEmpty()) {
            newClients.forEach(addNonDefault);
        }
    }

    protected abstract void addDefaults(ClientModel var1);

    @Override
    public void addClientScopeDefaults(ClientScopeRepresentation clientModel) {
    }

    public void close() {
    }
}

