/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.groups;

import io.smallrye.common.annotation.Experimental;
import io.smallrye.mutiny.groups.Gatherer;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;

@Experimental(value="This API is still being designed and may change in the future")
public interface Gatherers {
    public static <I, ACC, O> Gatherer<I, ACC, O> of(Supplier<ACC> initialAccumulatorSupplier, BiFunction<ACC, I, ACC> accumulatorFunction, BiFunction<ACC, Boolean, Optional<Gatherer.Extraction<ACC, O>>> extractor, Function<ACC, Optional<O>> finalizer) {
        return new DefaultGatherer<I, ACC, O>(initialAccumulatorSupplier, accumulatorFunction, extractor, finalizer);
    }

    public static <I> Gatherer<I, I, I> scan(Supplier<I> initialAccumulatorSupplier, BiFunction<I, I, I> accumulatorFunction) {
        return Gatherers.of(initialAccumulatorSupplier, accumulatorFunction, (acc, done) -> done != false ? Optional.empty() : Optional.of(Gatherer.Extraction.of(acc, acc)), Optional::of);
    }

    public static <I> Gatherer<I, I, I> fold(Supplier<I> initialAccumulatorSupplier, BiFunction<I, I, I> accumulatorFunction) {
        return Gatherers.of(initialAccumulatorSupplier, accumulatorFunction, (acc, done) -> Optional.empty(), Optional::of);
    }

    public static <I> Gatherer<I, List<I>, List<I>> window(int size) {
        return Gatherers.of(ArrayList::new, (acc, next) -> {
            acc.add(next);
            return acc;
        }, (acc, completed) -> {
            if (acc.size() == size) {
                return Optional.of(Gatherer.Extraction.of(new ArrayList(), new ArrayList(acc)));
            }
            return Optional.empty();
        }, acc -> acc.isEmpty() ? Optional.empty() : Optional.of(acc));
    }

    public static <I> Gatherer<I, List<I>, List<I>> slidingWindow(int size) {
        return Gatherers.of(ArrayList::new, (acc, item) -> {
            acc.add(item);
            return acc;
        }, (acc, completed) -> {
            if (acc.size() == size) {
                return Optional.of(Gatherer.Extraction.of(acc.stream().skip(1L).collect(Collectors.toList()), new ArrayList(acc)));
            }
            return Optional.empty();
        }, acc -> acc.isEmpty() ? Optional.empty() : Optional.of(acc));
    }

    public static <I> Gatherer.Builder<I> builder() {
        return new Gatherer.Builder();
    }

    public static class DefaultGatherer<I, ACC, O>
    implements Gatherer<I, ACC, O> {
        private final Supplier<ACC> initialAccumulatorSupplier;
        private final BiFunction<ACC, I, ACC> accumulatorFunction;
        private final BiFunction<ACC, Boolean, Optional<Gatherer.Extraction<ACC, O>>> extractor;
        private final Function<ACC, Optional<O>> finalizer;

        public DefaultGatherer(Supplier<ACC> initialAccumulatorSupplier, BiFunction<ACC, I, ACC> accumulatorFunction, BiFunction<ACC, Boolean, Optional<Gatherer.Extraction<ACC, O>>> extractor, Function<ACC, Optional<O>> finalizer) {
            this.initialAccumulatorSupplier = initialAccumulatorSupplier;
            this.accumulatorFunction = accumulatorFunction;
            this.extractor = extractor;
            this.finalizer = finalizer;
        }

        @Override
        public ACC accumulator() {
            return this.initialAccumulatorSupplier.get();
        }

        @Override
        public ACC accumulate(ACC accumulator, I item) {
            return this.accumulatorFunction.apply(accumulator, item);
        }

        @Override
        public Optional<Gatherer.Extraction<ACC, O>> extract(ACC accumulator, boolean upstreamCompleted) {
            return this.extractor.apply(accumulator, upstreamCompleted);
        }

        @Override
        public Optional<O> finalize(ACC accumulator) {
            return this.finalizer.apply(accumulator);
        }
    }
}

