/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.migration.migrators;

import java.util.Collections;
import java.util.HashMap;
import java.util.Objects;
import org.keycloak.migration.ModelVersion;
import org.keycloak.migration.migrators.Migration;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.representations.idm.RealmRepresentation;

public class MigrateTo3_4_1
implements Migration {
    public static final ModelVersion VERSION = new ModelVersion("3.4.1");

    public void migrate(KeycloakSession session) {
        session.realms().getRealmsStream().forEach(this::migrateRealm);
    }

    public void migrateImport(KeycloakSession session, RealmModel realm, RealmRepresentation rep, boolean skipUserDependent) {
        this.migrateRealm(realm);
    }

    protected void migrateRealm(RealmModel r) {
        HashMap securityHeaders = new HashMap(r.getBrowserSecurityHeaders());
        securityHeaders.entrySet().stream().filter(Objects::nonNull).filter(entry -> ((String)entry.getValue()).equals("frame-src 'self'")).forEach(entry -> entry.setValue("frame-src 'self'; frame-ancestors 'self'; object-src 'none';"));
        r.setBrowserSecurityHeaders(Collections.unmodifiableMap(securityHeaders));
    }

    public ModelVersion getVersion() {
        return VERSION;
    }
}

