/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.raft.internals;

import java.util.OptionalLong;
import java.util.function.Supplier;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.raft.NetworkChannel;
import org.apache.kafka.raft.RaftMessage;
import org.apache.kafka.raft.RaftMessageQueue;
import org.apache.kafka.raft.RaftRequest;
import org.apache.kafka.raft.RaftResponse;
import org.apache.kafka.raft.RaftUtil;
import org.apache.kafka.raft.RequestManager;
import org.apache.kafka.raft.internals.RequestSender;
import org.slf4j.Logger;

public final class DefaultRequestSender
implements RequestSender {
    private final RequestManager requestManager;
    private final NetworkChannel channel;
    private final RaftMessageQueue messageQueue;
    private final Logger logger;

    public DefaultRequestSender(RequestManager requestManager, NetworkChannel channel, RaftMessageQueue messageQueue, LogContext logContext) {
        this.requestManager = requestManager;
        this.channel = channel;
        this.messageQueue = messageQueue;
        this.logger = logContext.logger(DefaultRequestSender.class);
    }

    @Override
    public ListenerName listenerName() {
        return this.channel.listenerName();
    }

    @Override
    public OptionalLong send(Node destination, Supplier<ApiMessage> requestSupplier, long currentTimeMs) {
        if (this.requestManager.isBackingOff(destination, currentTimeMs)) {
            long remainingBackoffMs = this.requestManager.remainingBackoffMs(destination, currentTimeMs);
            this.logger.debug("Connection for {} is backing off for {} ms", (Object)destination, (Object)remainingBackoffMs);
            return OptionalLong.empty();
        }
        if (!this.requestManager.isReady(destination, currentTimeMs)) {
            long remainingMs = this.requestManager.remainingRequestTimeMs(destination, currentTimeMs);
            this.logger.debug("Connection for {} has a pending request for {} ms", (Object)destination, (Object)remainingMs);
            return OptionalLong.empty();
        }
        int correlationId = this.channel.newCorrelationId();
        ApiMessage request = requestSupplier.get();
        RaftRequest.Outbound requestMessage = new RaftRequest.Outbound(correlationId, request, destination, currentTimeMs);
        requestMessage.completion.whenComplete((response, exception) -> {
            if (exception != null) {
                ApiKeys api = ApiKeys.forId((int)request.apiKey());
                Errors error = Errors.forException((Throwable)exception);
                ApiMessage errorResponse = RaftUtil.errorResponse(api, error);
                response = new RaftResponse.Inbound(correlationId, errorResponse, destination);
            }
            this.messageQueue.add((RaftMessage)response);
        });
        this.requestManager.onRequestSent(destination, correlationId, currentTimeMs);
        this.channel.send(requestMessage);
        this.logger.trace("Sent outbound request: {}", (Object)requestMessage);
        return OptionalLong.of(this.requestManager.remainingRequestTimeMs(destination, currentTimeMs));
    }
}

