/*
 * Decompiled with CFR 0.152.
 */
package java2d;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.Ellipse2D;
import java.awt.image.BufferedImage;
import java2d.DemoImages;
import java2d.DemoInstVarsAccessor;
import java2d.DemoInstVarsAccessorImplBase;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public final class TextureChooser
extends JPanel {
    private final DemoInstVarsAccessor demoInstVars;
    public Object texture = TextureChooser.getGeomTexture();
    public int num;

    public TextureChooser(int num, DemoInstVarsAccessor demoInstVars) {
        this.num = num;
        this.demoInstVars = demoInstVars;
        this.setLayout(new GridLayout(0, 2, 5, 5));
        this.setBorder(new TitledBorder(new EtchedBorder(), "Texture Chooser"));
        this.add(new Surface(TextureChooser.getGeomTexture(), this, 0));
        this.add(new Surface(this.getImageTexture(), this, 1));
        this.add(new Surface(this.getTextTexture(), this, 2));
        this.add(new Surface(this.getGradientPaint(), this, 3));
    }

    public static TexturePaint getGeomTexture() {
        BufferedImage bi = new BufferedImage(5, 5, 1);
        Graphics2D tG2 = bi.createGraphics();
        tG2.setBackground(Color.WHITE);
        tG2.clearRect(0, 0, 5, 5);
        tG2.setColor(new Color(211, 211, 211, 200));
        tG2.fill(new Ellipse2D.Float(0.0f, 0.0f, 5.0f, 5.0f));
        Rectangle r = new Rectangle(0, 0, 5, 5);
        return new TexturePaint(bi, r);
    }

    public TexturePaint getImageTexture() {
        Image img = DemoImages.getImage("globe.png", this);
        int sw = img.getWidth(this);
        int sh = img.getHeight(this);
        int iw = sw / 5;
        int ih = sh / 5;
        BufferedImage bi = new BufferedImage(iw, ih, 2);
        Graphics2D tG2 = bi.createGraphics();
        tG2.drawImage(img, 0, 0, iw, ih, 0, 0, sw, sh, this);
        Rectangle r = new Rectangle(0, 0, iw, ih);
        return new TexturePaint(bi, r);
    }

    public TexturePaint getTextTexture() {
        Font f = new Font("Serif", 1, 10);
        TextLayout tl = new TextLayout("OpenJDK", f, new FontRenderContext(null, false, false));
        int sw = (int)tl.getBounds().getWidth();
        int sh = (int)(tl.getAscent() + tl.getDescent());
        BufferedImage bi = new BufferedImage(sw, sh, 1);
        Graphics2D tG2 = bi.createGraphics();
        tG2.setBackground(Color.WHITE);
        tG2.clearRect(0, 0, sw, sh);
        tG2.setColor(Color.LIGHT_GRAY);
        tl.draw(tG2, 0.0f, tl.getAscent());
        Rectangle r = new Rectangle(0, 0, sw, sh);
        return new TexturePaint(bi, r);
    }

    public GradientPaint getGradientPaint() {
        return new GradientPaint(0.0f, 0.0f, Color.WHITE, 80.0f, 0.0f, Color.GREEN);
    }

    public static void main(String[] s) {
        Frame f = new Frame("J2D Demo - TextureChooser");
        f.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        f.add("Center", new TextureChooser(0, new DemoInstVarsAccessorImplBase()));
        f.pack();
        f.setSize(new Dimension(400, 400));
        f.setVisible(true);
    }

    public class Surface
    extends JPanel {
        public boolean clickedFrame;
        private int num;
        private TextureChooser tc;
        private boolean enterExitFrame = false;
        private Object t;

        public Surface(final Object t, final TextureChooser tc, int num) {
            this.setBackground(Color.WHITE);
            this.t = t;
            this.tc = tc;
            this.clickedFrame = num == tc.num;
            this.num = num;
            if (num == tc.num) {
                tc.texture = t;
            }
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    tc.texture = t;
                    Surface.this.clickedFrame = true;
                    for (Component comp : tc.getComponents()) {
                        Surface surf;
                        if (!(comp instanceof Surface) || (surf = (Surface)comp).equals(Surface.this) || !surf.clickedFrame) continue;
                        surf.clickedFrame = false;
                        surf.repaint();
                    }
                    if (TextureChooser.this.demoInstVars.getControls().textureCB.isSelected()) {
                        TextureChooser.this.demoInstVars.getControls().textureCB.doClick();
                        TextureChooser.this.demoInstVars.getControls().textureCB.doClick();
                    }
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    Surface.this.enterExitFrame = true;
                    Surface.this.repaint();
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    Surface.this.enterExitFrame = false;
                    Surface.this.repaint();
                }
            });
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics2D g2 = (Graphics2D)g;
            int w = this.getSize().width;
            int h = this.getSize().height;
            if (this.t instanceof TexturePaint) {
                g2.setPaint((TexturePaint)this.t);
            } else {
                g2.setPaint((GradientPaint)this.t);
            }
            g2.fill(new Rectangle(0, 0, w, h));
            if (this.clickedFrame || this.enterExitFrame) {
                g2.setColor(Color.GRAY);
                BasicStroke bs = new BasicStroke(3.0f, 0, 0);
                g2.setStroke(bs);
                g2.drawRect(0, 0, w - 1, h - 1);
                this.tc.num = this.num;
            }
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        @Override
        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(30, 30);
        }
    }
}

