/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.ru;

import ai.grazie.rules.common.CommonPatterns;
import ai.grazie.rules.common.FeatureUtil;
import ai.grazie.rules.ru.Case;
import ai.grazie.rules.ru.RussianTreePatterns;
import ai.grazie.rules.ru.RussianTreeSupport;
import ai.grazie.rules.tree.Node;
import ai.grazie.rules.tree.NodeCorrector;
import ai.grazie.rules.tree.NodePattern;
import ai.grazie.rules.tree.Tree;
import ai.grazie.rules.tree.TreeSupport;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import one.util.streamex.StreamEx;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class InflectedForm {
    private static final NodePattern count = NodePattern.N.lemma("\u0440\u044f\u0434|\u0431\u043e\u043b\u044c\u0448\u0438\u043d\u0441\u0442\u0432\u043e|\u043c\u0435\u043d\u044c\u0448\u0438\u043d\u0441\u0442\u0432\u043e|\u0447\u0430\u0441\u0442\u044c|\u043c\u043d\u043e\u0436\u0435\u0441\u0442\u0432\u043e|\u043f\u043e\u043b\u043e\u0432\u0438\u043d\u0430|\u0442\u0440\u0435\u0442\u044c|\u0447\u0435\u0442\u0432\u0435\u0440\u0442\u044c|\u0434\u0435\u0441\u044f\u0442\u043e\u043a|\u0442\u044b\u0441\u044f\u0447\u0430|\u043c\u0438\u043b\u043b\u0438\u043e\u043d|\u043c\u0438\u043b\u043b\u0438\u0430\u0440\u0434");
    private static final NodePattern possiblyFeminine = NodePattern.N.lemma(".*\u0442\u0435\u043b\u044c|.*\u043e\u043b\u043e\u0433|\u0434\u0438\u0440\u0435\u043a\u0442\u043e\u0440|\u0434\u0435\u043f\u0443\u0442\u0430\u0442|\u0441\u0435\u043d\u0430\u0442\u043e\u0440|\u0433\u0443\u0431\u0435\u0440\u043d\u0430\u0442\u043e\u0440|\u043a\u0430\u043d\u0446\u043b\u0435\u0440|\u0441\u0435\u043a\u0440\u0435\u0442\u0430\u0440\u044c|\u043f\u0440\u0435\u0441\u0441-\u0441\u0435\u043a\u0440\u0435\u0442\u0430\u0440\u044c|\u043a\u043e\u0440\u0440\u0435\u0441\u043f\u043e\u043d\u0434\u0435\u043d\u0442|\u043f\u043e\u043b\u0438\u0442\u0438\u043a|\u043f\u043e\u043c\u043e\u0449\u043d\u0438\u043a|\u0430\u0432\u0442\u043e\u0440|\u043c\u0438\u043d\u0438\u0441\u0442\u0440|\u0442\u0440\u0435\u043d\u0435\u0440|\u043d\u0430\u0447\u0430\u043b\u044c\u043d\u0438\u043a|\u0430\u0434\u0432\u043e\u043a\u0430\u0442|\u0432\u0440\u0430\u0447|\u0437\u0430\u043c\u0434\u0438\u0440\u0435\u043a\u0442\u043e\u0440\u0430|\u0440\u0438\u0435\u043b\u0442\u043e\u0440|\u0445\u0438\u0440\u0443\u0440\u0433|\u043f\u0435\u0434\u0438\u0430\u0442\u0440|\u043c\u043e\u043b\u043e\u0434\u0435\u0446");
    private static final NodePattern possiblyMasculine = NodePattern.N.lemma("\u0437\u0432\u0435\u0437\u0434\u0430|\u0440\u0430\u043a\u0435\u0442\u043a\u0430");
    private static final NodePattern vmesteS = NodePattern.N.inFormSequence(0, "\u0432\u043c\u0435\u0441\u0442\u0435|\u043d\u0430\u0440\u044f\u0434\u0443", "\u0441");
    private static final NodePattern xWithY = NodePattern.or(NodePattern.N.withDependent("nmod", NodePattern.N.withDependent("case", NodePattern.N.lemma("\u0441"))), NodePattern.N.withDependent("advmod", vmesteS), NodePattern.N.withNextSibling(vmesteS));
    private static final NodePattern possibleFamilyName = CommonPatterns.capitalized.andOr(NodePattern.N.pos("NN:Name:.*").noLemma("\u043c\u0430\u0448\u0430"), NodePattern.N.formCaseSensitive("[\u0410-\u042f\u0401].*(\u0438\u043d|\u043e\u0432)"));
    static final EnumSet<Gender> P12Genders = EnumSet.of(Gender.Masc, Gender.Fem);
    private static final NodePattern withConjAdj = NodePattern.N.markAs("Noun").withDependent("amod", NodePattern.N.before("Noun").withDependent("conj"));
    private static final Pattern sam = Pattern.compile("\u0441\u0430\u043c(|\u043e\u0433\u043e|\u043e\u043c\u0443|\u0438\u043c|\u043e\u043c|\u0430|\u043e\u0439|\u0443|\u043e|\u0438|\u0438\u0445|\u0438\u043c\u0438)");
    private static final Pattern samyj = Pattern.compile("\u0441\u0430\u043c(\u044b\u0439|\u043e\u0433\u043e|\u043e\u043c\u0443|\u044b\u043c|\u043e\u043c|\u0430\u044f|\u043e\u0439|\u0443\u044e|\u043e\u0435|\u044b\u0435|\u044b\u0445|\u044b\u043c\u0438?)");
    private static final NodePattern definitelySamyj = NodePattern.N.form(samyj.pattern()).withHead("amod", NodePattern.N.lemma("\u0442\u043e\u0442"));
    private static final NodePattern masc = NodePattern.N.lemma("\u043a\u0442\u043e-\u0442\u043e|\u043a\u0442\u043e-\u043b\u0438\u0431\u043e|\u043a\u0442\u043e-\u043d\u0438\u0431\u0443\u0434\u044c|\u043d\u0438\u043a\u0442\u043e");
    private static final NodePattern neut = NodePattern.N.lemma("\u043c\u043d\u043e\u0433\u043e|\u043d\u0435\u043c\u0430\u043b\u043e|\u043d\u0435\u043c\u043d\u043e\u0433\u043e|\u043c\u0430\u043b\u043e|\u0447\u0442\u043e|\u0447\u0442\u043e-\u0442\u043e|\u0447\u0442\u043e-\u043b\u0438\u0431\u043e|\u0447\u0442\u043e-\u043d\u0438\u0431\u0443\u0434\u044c|\u043d\u0438\u0447\u0442\u043e|\u044d\u0442\u043e").noDependents("fixed");
    private static final NodePattern who = NodePattern.N.lemma("\u043a\u0442\u043e").noForm("\u043a\u043e\u043c");
    private static final Pattern genderedNounWithoutNumber = Pattern.compile("NN:[^:]*:(Masc|Fem|Neut)");
    private static final Pattern supportedPosTags = Pattern.compile("VB:(Past|Real|Fut):.*|ADJ:.*|PT.*|Ord.*");
    private static final NodePattern isUpperCaseNoun = NodePattern.N.pos("NN:.*").formCaseSensitive("\\p{Lu}+");
    private static final NodePattern all = NodePattern.N.lemma("\u0432\u0441\u0435");
    final Gender gender;
    final Number number;
    final Person person;
    final Animacy animacy;
    final Case caze;
    static final NodePattern isPossiblySingular = NodePattern.N.beforeHead().withHeadRelation("nsubj.*").withDependent("conj", NodePattern.N.pos(".*Sin.*")).noDependents("conj", NodePattern.N.withDependent("cc", NodePattern.N.form("\u0438|\u0434\u0430")));
    static final NodePattern isPossiblyPlural = NodePattern.or(NodePattern.N.withDependent("conj"), NodePattern.N.withDependent("nmod", NodePattern.N.withDependent("conj").withDependent(".*", Case.Nom.posPattern)), withConjAdj, xWithY, count, NodePattern.N.withDependent("nmod", count), NodePattern.N.form("\u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e").withDependent("nmod", NodePattern.N.pos("NN:.*PL.*")), NodePattern.N.lemma("\u043f\u0430\u0440\u0430"), NodePattern.N.form("\u043f\u043e\u043b.+").and(n -> n.tree().treeSupport().tagToken(n.form().substring(3)).hasPos("NN.*")));

    InflectedForm(@Nullable Gender gender, @Nullable Number number, @Nullable Person person, @Nullable Case caze, @Nullable Animacy animacy) {
        assert (gender != null || number != null || person != null || caze != null || animacy != null);
        this.gender = gender;
        this.number = number != null ? number : (gender != null ? Number.Sin : null);
        this.person = person;
        this.caze = caze;
        this.animacy = animacy;
    }

    InflectedForm withGender(@NotNull Gender gender) {
        return new InflectedForm(gender, this.number, this.person, this.caze, this.animacy);
    }

    InflectedForm withNumber(@NotNull Number number) {
        return new InflectedForm(this.gender, number, this.person, this.caze, this.animacy);
    }

    InflectedForm withCase(@NotNull Case caze) {
        return new InflectedForm(this.gender, this.number, this.person, caze, this.animacy);
    }

    @Nullable
    InflectedForm removeCasePerson() {
        if (this.gender == null && this.number == null && this.animacy == null) {
            return null;
        }
        return new InflectedForm(this.gender, this.number, null, null, this.animacy);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InflectedForm)) {
            return false;
        }
        InflectedForm that = (InflectedForm)o;
        return this.gender == that.gender && this.number == that.number && this.person == that.person && this.caze == that.caze && this.animacy == that.animacy;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.gender, this.number, this.person, this.caze, this.animacy});
    }

    boolean matchesCase(Set<Case> possibleCases) {
        return this.caze == null || possibleCases.contains((Object)this.caze);
    }

    private static InflectedForm fromPos(String pos) {
        Set<String> sections = Set.of(StringUtils.split((String)pos, (char)':'));
        Gender gender = FeatureUtil.findEnumConstant(sections, Gender.values());
        Number number = FeatureUtil.findEnumConstant(sections, Number.values());
        Person person = FeatureUtil.findEnumConstant(sections, Person.values());
        Case caze = FeatureUtil.findEnumConstant(sections, Case.values());
        Animacy animacy = FeatureUtil.findEnumConstant(sections, Animacy.values());
        return gender == null && number == null && person == null && caze == null && animacy == null ? null : new InflectedForm(gender, number, person, caze, animacy);
    }

    public String toString() {
        return ((StreamEx)StreamEx.of((Object)((Object)this.gender)).append((Object)this.number).append((Object)this.person).append((Object)this.caze).append((Object)this.animacy).filter(Objects::nonNull)).joining((CharSequence)"+");
    }

    private EnumSet<Gender> possibleGenders() {
        if (this.gender != null) {
            return EnumSet.of(this.gender);
        }
        if (this.person == Person.P1 || this.person == Person.P2) {
            return P12Genders;
        }
        return EnumSet.allOf(Gender.class);
    }

    @Nullable
    InflectedForm unify(InflectedForm another) {
        Sets.SetView genders = Sets.intersection(this.possibleGenders(), another.possibleGenders());
        if (genders.isEmpty()) {
            return null;
        }
        if (!FeatureUtil.areCompatible(this.number, another.number)) {
            return null;
        }
        if (!FeatureUtil.areCompatible(this.person, another.person)) {
            return null;
        }
        if (!FeatureUtil.areCompatible(this.caze, another.caze)) {
            return null;
        }
        if (!FeatureUtil.areCompatible(this.animacy, another.animacy)) {
            return null;
        }
        return new InflectedForm(FeatureUtil.unifyValues(this.gender, another.gender), FeatureUtil.unifyValues(this.number, another.number), FeatureUtil.unifyValues(this.person, another.person), FeatureUtil.unifyValues(this.caze, another.caze), FeatureUtil.unifyValues(this.animacy, another.animacy));
    }

    @Nullable
    NodeCorrector inflect(Node toInflect, Node main, Set<Case> possibleCases) {
        if (toInflect.hasForm("\u044d\u0442\u043e") && (main.hasPos("VB") || main == toInflect)) {
            return null;
        }
        if (toInflect.hasPos("VB:Past:.*")) {
            return this.inflectPastVerb(main, toInflect);
        }
        if (toInflect.hasPos("VB:(Real|Fut):.*")) {
            return this.inflectNonPastVerb(toInflect);
        }
        if (!(!toInflect.hasPos("ADJ:.*") || this.gender == null && this.number == null || toInflect.hasPos("PT.*") && RussianTreePatterns.clause.matches(toInflect))) {
            return this.inflectAdj(toInflect, possibleCases);
        }
        if (toInflect.hasPos("PT.*") && (this.gender != null || this.number != null)) {
            return this.inflectParticiple(toInflect, possibleCases);
        }
        if (toInflect.hasPos("NN:.*")) {
            return this.inflectNoun(toInflect, possibleCases);
        }
        if (toInflect.hasPos("PNN:.*") && !toInflect.hasForm("\u0447\u0442\u043e")) {
            return this.inflectPronoun(toInflect, possibleCases);
        }
        if (toInflect.hasPos("Num.*")) {
            return this.inflectNum(toInflect, possibleCases);
        }
        return null;
    }

    private NodeCorrector inflectNum(Node toInflect, Set<Case> possibleCases) {
        if (toInflect.hasPos("NumC:.*")) {
            return NodeCorrector.inflect(toInflect, "NumC:.*", "NumC:" + InflectedForm.enumRegexp(possibleCases));
        }
        if (this.gender == null && this.number == null) {
            return null;
        }
        return NodeCorrector.inflect(toInflect, "Num:.*", "Num:" + this.genderNumberRegexp() + ":" + InflectedForm.enumRegexp(possibleCases));
    }

    private NodeCorrector inflectParticiple(Node toInflect, Set<Case> possibleCases) {
        NodeCorrector full = NodeCorrector.inflect(toInflect, "PT:(Real|Past):.*:.*:(STR|DST):.*:.*", "PT:$1:.*:.*:$2:" + this.genderNumberRegexp() + ":" + InflectedForm.enumRegexp(possibleCases));
        NodeCorrector inflectShort = NodeCorrector.inflect(toInflect, "PT_Short:(Real|Past):.*:.*:(STR|DST):.*", "PT_Short:$1:.*:.*:$2:" + this.genderNumberRegexp());
        return full.or(inflectShort);
    }

    private NodeCorrector inflectAdj(Node adj, Set<Case> possibleCases) {
        if (adj.hasPos("ADJ:Short:.*")) {
            return NodeCorrector.inflect(adj, "ADJ:Short:.*", "ADJ:Short:" + this.genderNumberRegexp());
        }
        if (adj.hasPos("ADJ:(MPR|Posit):.*")) {
            return NodeCorrector.replaceNodes(adj, adj, () -> this.inflectLongAdj(adj, possibleCases));
        }
        return null;
    }

    private List<String> inflectLongAdj(Node adj, Set<Case> possibleCases) {
        String caseRegexp = this.caseRegexp(possibleCases);
        boolean needAcc = caseRegexp.contains("V");
        boolean removeSam = definitelySamyj.matches(adj);
        TreeSupport support = adj.tree().treeSupport();
        List<String> suggestions = support.inflectNode(adj, "ADJ:(MPR|Posit):.*", "ADJ:$1:" + this.genderNumberRegexp() + ":" + caseRegexp);
        return ((StreamEx)StreamEx.of(suggestions).filter(s -> {
            if (needAcc && this.animacy != null && !FeatureUtil.areCompatible(this.animacy, InflectedForm.guessAccAdjAnimacy(support, s))) {
                return false;
            }
            return !removeSam || !sam.matcher((CharSequence)s).matches() || samyj.matcher((CharSequence)s).matches();
        })).toList();
    }

    private String genderNumberRegexp() {
        return ((Enum)Objects.requireNonNull(this.number == Number.PL ? this.number : (this.gender != null ? this.gender : this.number))).toString();
    }

    private String caseRegexp(Set<Case> possibleCases) {
        if (this.caze != null) {
            return this.caze.toString();
        }
        return InflectedForm.enumRegexp(possibleCases);
    }

    private NodeCorrector inflectNonPastVerb(Node verb) {
        Person person = this.person != null ? this.person : Person.P3;
        return NodeCorrector.inflect(verb, "VB:(Real|Fut):.*", "VB:$1:.*:.*:" + String.valueOf((Object)this.number) + ":" + String.valueOf((Object)person));
    }

    private NodeCorrector inflectPastVerb(Node subject, Node verb) {
        if (this.number == Number.Sin && subject.hasDependent("conj|cc")) {
            return null;
        }
        if (this.number == Number.PL && !xWithY.matches(subject)) {
            return NodeCorrector.inflect(verb, "VB:Past:.*", "VB:Past:.*:.*:PL");
        }
        if (this.gender != null) {
            EnumSet<Gender> genders = EnumSet.of(this.gender);
            Gender additional = InflectedForm.additionalGender(subject);
            if (additional != null) {
                genders.add(additional);
            }
            return NodeCorrector.inflect(verb, "VB:Past:.*", "VB:Past:.*:.*:" + InflectedForm.enumRegexp(genders));
        }
        if ((this.person == Person.P1 || this.person == Person.P2) && this.number != Number.PL) {
            return NodeCorrector.inflect(verb, "VB:Past:.*", "VB:Past:.*:.*:(Masc|Fem)");
        }
        return null;
    }

    private NodeCorrector inflectNoun(Node noun, Set<Case> possibleCases) {
        String genders;
        if (noun.hasPos("NN:Name:.*") && this.number == Number.PL) {
            return null;
        }
        if (this.person != Person.P3) {
            return null;
        }
        String string = genders = this.gender != null ? this.gender.toString() : ".*";
        if (!CommonPatterns.capitalized.matches(noun) && noun.tagIndependently().hasPos("NN:Fam:.*")) {
            return NodeCorrector.inflect(noun, "NN:(Anim|Inanim).*", "NN:.*:" + genders + ":" + String.valueOf((Object)this.number) + ":" + this.caseRegexp(possibleCases));
        }
        return NodeCorrector.inflect(noun, "NN:.*", "NN:.*:" + genders + ":" + String.valueOf((Object)this.number) + ":" + this.caseRegexp(possibleCases));
    }

    private NodeCorrector inflectPronoun(Node pronoun, Set<Case> possibleCases) {
        if (pronoun.hasPos("PNN:.*:Nom.*") && !pronoun.hasHeadRelation("root") && Objects.requireNonNull(pronoun.head()).hasPos("VB:INF:.*") && !pronoun.hasDependent("case")) {
            return NodeCorrector.inflect(pronoun, "PNN:.*", "PNN:" + String.valueOf((Object)this.number) + ":D.*");
        }
        if (pronoun.hasPos("PNN:.*:Nom.*") && !pronoun.hasDependent("det")) {
            List<String> suggestions = pronoun.tree().treeSupport().synthesize("", this.synthesizeNomPronoun(), "PNN:(.*)", "PNN:" + String.valueOf((Object)this.number) + ":" + this.caseRegexp(possibleCases) + ".*");
            return NodeCorrector.replace(pronoun, RussianTreeSupport.chooseImNim(pronoun, suggestions));
        }
        return NodeCorrector.inflect(pronoun, "PNN:.*", "PNN:" + String.valueOf((Object)this.number) + ":" + this.caseRegexp(possibleCases) + ".*");
    }

    private String synthesizeNomPronoun() {
        if (this.person == Person.P1) {
            return this.number == Number.Sin ? "\u044f" : "\u043c\u044b";
        }
        if (this.person == Person.P2) {
            return this.number == Number.Sin ? "\u0442\u044b" : "\u0432\u044b";
        }
        return this.number == Number.PL ? "\u043e\u043d\u0438" : (this.gender == Gender.Masc ? "\u043e\u043d" : (this.gender == Gender.Fem ? "\u043e\u043d\u0430" : "\u043e\u043d\u043e"));
    }

    private static <T extends Enum<T>> String enumRegexp(Set<T> set) {
        return "(" + StreamEx.of(set).joining((CharSequence)"|") + ")";
    }

    static List<InflectedForm> fromPosTags(@NotNull Node node) {
        LinkedHashSet<InflectedForm> result = new LinkedHashSet<InflectedForm>();
        for (String pos : node.posReadings()) {
            InflectedForm features;
            if (!supportedPosTags.matcher(pos).matches() || (features = InflectedForm.fromPos(pos)) == null) continue;
            if (pos.matches("ADJ:.*:V.*")) {
                Animacy animacy = InflectedForm.guessAccAdjAnimacy(node.tree().treeSupport(), node.form());
                if (animacy != null) {
                    features = new InflectedForm(features.gender, features.number, null, features.caze, animacy);
                }
            } else if (pos.startsWith("PT_Short") && features.gender != null) {
                features = features.withNumber(Number.Sin);
            }
            result.add(features);
            if ((pos.startsWith("ADJ:") || pos.startsWith("PT")) && node.hasDependent("conj") && !node.hasDependent("[cn]subj.*")) {
                result.add(features.withNumber(Number.PL));
            }
            if (features.caze == Case.R) {
                result.add(features.withCase(Case.R2));
            }
            if (features.caze != Case.P) continue;
            result.add(features.withCase(Case.P2));
        }
        return new ArrayList<InflectedForm>(result);
    }

    private static Animacy guessAccAdjAnimacy(TreeSupport support, String form) {
        Tree.Token tagged = support.tagToken(form);
        if (tagged.hasPos("ADJ:(Posit|MPR):(Masc|PL):Nom")) {
            return Animacy.Inanim;
        }
        if (tagged.hasPos("ADJ:(Posit|MPR):(Masc|PL):R")) {
            return Animacy.Anim;
        }
        return null;
    }

    static List<InflectedForm> fromNPHead(Node noun) {
        if (possibleFamilyName.matches(noun)) {
            return Collections.emptyList();
        }
        if (isUpperCaseNoun.matches(noun)) {
            return Collections.emptyList();
        }
        if (neut.matches(noun)) {
            return List.of(new InflectedForm(Gender.Neut, Number.Sin, Person.P3, null, Animacy.Inanim));
        }
        if (who.matches(noun)) {
            return List.of(new InflectedForm(Gender.Masc, Number.Sin, Person.P3, null, Animacy.Anim), new InflectedForm(null, Number.PL, Person.P3, null, Animacy.Anim));
        }
        if (masc.matches(noun)) {
            return List.of(new InflectedForm(Gender.Masc, Number.Sin, Person.P3, null, Animacy.Anim));
        }
        LinkedHashSet<InflectedForm> result = new LinkedHashSet<InflectedForm>();
        for (String pos : noun.posReadings()) {
            InflectedForm form;
            if (!pos.startsWith("ADJ:") && !pos.startsWith("PNN:") && !pos.startsWith("NN:") && !pos.startsWith("Ord:") || (form = InflectedForm.fromPos(pos)) == null || InflectedForm.isGenericallyTaggedPronoun(pos, form)) continue;
            result.add(form);
            if (!genderedNounWithoutNumber.matcher(pos).matches()) continue;
            result.add(form.withNumber(Number.PL));
        }
        if (result.isEmpty()) {
            return Collections.emptyList();
        }
        if (all.matches(noun)) {
            result.addAll(StreamEx.of(result).map(r -> r.withGender(Gender.Neut)).toList());
        }
        if (isPossiblyPlural.matches(noun)) {
            result.addAll(StreamEx.of(result).map(f -> f.withNumber(Number.PL)).toList());
        }
        return new ArrayList<InflectedForm>(result);
    }

    private static boolean isGenericallyTaggedPronoun(String pos, InflectedForm form) {
        return pos.startsWith("PNN:") && form.number == Number.Sin && form.gender == null && form.person == Person.P3 && form.caze == Case.Nom;
    }

    static Gender additionalGender(Node noun) {
        if (possiblyFeminine.matches(noun)) {
            return Gender.Fem;
        }
        if (possiblyMasculine.matches(noun)) {
            return Gender.Masc;
        }
        return null;
    }

    static StreamEx<InflectedForm> addNumber(Collection<InflectedForm> forms, @NotNull Number number) {
        return StreamEx.of(forms).flatMap(f -> StreamEx.of((Object[])new InflectedForm[]{f, f.withNumber(number)}));
    }

    static enum Gender {
        Masc,
        Neut,
        Fem;

    }

    static enum Number {
        Sin,
        PL;

    }

    static enum Person {
        P1,
        P2,
        P3;

    }

    static enum Animacy {
        Anim,
        Inanim;

    }
}

