/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.morph;

import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.lucene.analysis.morph.BinaryDictionary;
import org.apache.lucene.analysis.morph.ConnectionCosts;
import org.apache.lucene.analysis.morph.Dictionary;
import org.apache.lucene.analysis.morph.MorphData;
import org.apache.lucene.analysis.morph.Token;
import org.apache.lucene.analysis.morph.TokenInfoFST;
import org.apache.lucene.analysis.morph.TokenType;
import org.apache.lucene.analysis.util.RollingCharBuffer;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.IntsRef;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.fst.FST;

public abstract class Viterbi<T extends Token, U extends Position> {
    protected static final boolean VERBOSE = false;
    protected static final int MAX_UNKNOWN_WORD_LENGTH = 1024;
    private static final int MAX_BACKTRACE_GAP = 1024;
    private final TokenInfoFST fst;
    private final BinaryDictionary<? extends MorphData> dictionary;
    private final Dictionary<? extends MorphData> userDictionary;
    protected final ConnectionCosts costs;
    private final FST.Arc<Long> arc = new FST.Arc();
    private final FST.BytesReader fstReader;
    protected final IntsRef wordIdRef = new IntsRef();
    private final FST.BytesReader userFSTReader;
    private final TokenInfoFST userFST;
    protected final RollingCharBuffer buffer = new RollingCharBuffer();
    protected final WrappedPositionArray<U> positions;
    protected boolean end;
    protected int lastBackTracePos;
    protected int pos;
    protected final List<T> pending = new ArrayList<T>();
    protected boolean outputNBest = false;
    protected boolean enableSpacePenaltyFactor = false;
    protected boolean outputLongestUserEntryOnly = false;

    protected Viterbi(TokenInfoFST fst, FST.BytesReader fstReader, BinaryDictionary<? extends MorphData> dictionary, TokenInfoFST userFST, FST.BytesReader userFSTReader, Dictionary<? extends MorphData> userDictionary, ConnectionCosts costs, Class<U> positionImpl) {
        this.fst = fst;
        this.fstReader = fstReader;
        this.dictionary = dictionary;
        this.userFST = userFST;
        this.userFSTReader = userFSTReader;
        this.userDictionary = userDictionary;
        this.costs = costs;
        this.positions = new WrappedPositionArray<U>(positionImpl);
    }

    public final void forward() throws IOException {
        int leastIDX;
        int unknownWordEndIndex = -1;
        int userWordMaxPosAhead = -1;
        while (this.buffer.get(this.pos) != -1) {
            int output;
            boolean isFrontier;
            U posData = this.positions.get(this.pos);
            boolean bl = isFrontier = this.positions.getNextPos() == this.pos + 1;
            if (((Position)posData).count == 0) {
                ++this.pos;
                continue;
            }
            if (this.pos > this.lastBackTracePos && ((Position)posData).count == 1 && isFrontier) {
                if (this.outputNBest) {
                    this.backtraceNBest((Position)posData, false);
                }
                this.backtrace((Position)posData, 0);
                if (this.outputNBest) {
                    this.fixupPendingList();
                }
                ((Position)posData).costs[0] = 0;
                if (this.pending.size() > 0) {
                    return;
                }
            }
            if (this.pos - this.lastBackTracePos >= 1024) {
                U posData2;
                int pos2;
                leastIDX = -1;
                int leastCost = Integer.MAX_VALUE;
                Position leastPosData = null;
                for (pos2 = this.pos; pos2 < this.positions.getNextPos(); ++pos2) {
                    posData2 = this.positions.get(pos2);
                    for (int idx = 0; idx < ((Position)posData2).count; ++idx) {
                        int cost = ((Position)posData2).costs[idx];
                        if (cost >= leastCost) continue;
                        leastCost = cost;
                        leastIDX = idx;
                        leastPosData = (Position)posData2;
                    }
                }
                assert (leastIDX != -1);
                if (this.outputNBest) {
                    this.backtraceNBest(leastPosData, false);
                }
                for (pos2 = this.pos; pos2 < this.positions.getNextPos(); ++pos2) {
                    posData2 = this.positions.get(pos2);
                    if (posData2 != leastPosData) {
                        ((Position)posData2).reset();
                        continue;
                    }
                    if (leastIDX != 0) {
                        ((Position)posData2).costs[0] = ((Position)posData2).costs[leastIDX];
                        ((Position)posData2).lastRightID[0] = ((Position)posData2).lastRightID[leastIDX];
                        ((Position)posData2).backPos[0] = ((Position)posData2).backPos[leastIDX];
                        ((Position)posData2).backWordPos[0] = ((Position)posData2).backWordPos[leastIDX];
                        ((Position)posData2).backIndex[0] = ((Position)posData2).backIndex[leastIDX];
                        ((Position)posData2).backID[0] = ((Position)posData2).backID[leastIDX];
                        ((Position)posData2).backType[0] = ((Position)posData2).backType[leastIDX];
                    }
                    ((Position)posData2).count = 1;
                }
                this.backtrace(leastPosData, 0);
                if (this.outputNBest) {
                    this.fixupPendingList();
                }
                Arrays.fill(leastPosData.costs, 0, leastPosData.count, 0);
                if (this.pos != leastPosData.pos) {
                    assert (this.pos < leastPosData.pos);
                    this.pos = leastPosData.pos;
                }
                if (this.pending.size() <= 0) continue;
                return;
            }
            if (this.enableSpacePenaltyFactor && Character.getType(this.buffer.get(this.pos)) == 12 && this.buffer.get(++this.pos) == -1) {
                this.pos = ((Position)posData).pos;
            }
            boolean anyMatches = false;
            if (this.userFST != null) {
                int ch;
                this.userFST.getFirstArc(this.arc);
                output = 0;
                int maxPosAhead = 0;
                int outputMaxPosAhead = 0;
                int arcFinalOutMaxPosAhead = 0;
                int posAhead = this.pos;
                while ((ch = this.buffer.get(posAhead)) != -1 && this.userFST.findTargetArc(ch, this.arc, this.arc, posAhead == this.pos, this.userFSTReader) != null) {
                    output += this.arc.output().intValue();
                    if (this.arc.isFinal()) {
                        maxPosAhead = posAhead;
                        outputMaxPosAhead = output;
                        arcFinalOutMaxPosAhead = this.arc.nextFinalOutput().intValue();
                        anyMatches = true;
                        if (!this.outputLongestUserEntryOnly) {
                            this.add(this.userDictionary.getMorphAttributes(), (Position)posData, this.pos, posAhead + 1, output + this.arc.nextFinalOutput().intValue(), TokenType.USER, false);
                        }
                    }
                    ++posAhead;
                }
                if (anyMatches && maxPosAhead > userWordMaxPosAhead) {
                    if (this.outputLongestUserEntryOnly) {
                        this.add(this.userDictionary.getMorphAttributes(), (Position)posData, this.pos, maxPosAhead + 1, outputMaxPosAhead + arcFinalOutMaxPosAhead, TokenType.USER, false);
                    }
                    userWordMaxPosAhead = Math.max(userWordMaxPosAhead, maxPosAhead);
                }
            }
            if (!anyMatches) {
                int ch;
                this.fst.getFirstArc(this.arc);
                output = 0;
                int posAhead = this.pos;
                while ((ch = this.buffer.get(posAhead)) != -1 && this.fst.findTargetArc(ch, this.arc, this.arc, posAhead == this.pos, this.fstReader) != null) {
                    output += this.arc.output().intValue();
                    if (this.arc.isFinal()) {
                        this.dictionary.lookupWordIds(output + this.arc.nextFinalOutput().intValue(), this.wordIdRef);
                        for (int ofs = 0; ofs < this.wordIdRef.length; ++ofs) {
                            this.add((MorphData)this.dictionary.getMorphAttributes(), (Position)posData, this.pos, posAhead + 1, this.wordIdRef.ints[this.wordIdRef.offset + ofs], TokenType.KNOWN, false);
                            anyMatches = true;
                        }
                    }
                    ++posAhead;
                }
            }
            if (!this.shouldSkipProcessUnknownWord(unknownWordEndIndex, (Position)posData)) {
                int unknownWordLength = this.processUnknownWord(anyMatches, (Position)posData);
                unknownWordEndIndex = ((Position)posData).pos + unknownWordLength;
            }
            ++this.pos;
        }
        this.end = true;
        if (this.pos > 0) {
            U endPosData = this.positions.get(this.pos);
            int leastCost = Integer.MAX_VALUE;
            leastIDX = -1;
            for (int idx = 0; idx < ((Position)endPosData).count; ++idx) {
                int cost = ((Position)endPosData).costs[idx] + this.costs.get(((Position)endPosData).lastRightID[idx], 0);
                if (cost >= leastCost) continue;
                leastCost = cost;
                leastIDX = idx;
            }
            if (this.outputNBest) {
                this.backtraceNBest((Position)endPosData, true);
            }
            this.backtrace((Position)endPosData, leastIDX);
            if (this.outputNBest) {
                this.fixupPendingList();
            }
        }
    }

    protected boolean shouldSkipProcessUnknownWord(int unknownWordEndIndex, Position posData) {
        return unknownWordEndIndex > posData.pos;
    }

    protected abstract int processUnknownWord(boolean var1, Position var2) throws IOException;

    protected abstract void backtrace(Position var1, int var2) throws IOException;

    protected void backtraceNBest(Position endPosData, boolean useEOS) throws IOException {
        throw new UnsupportedOperationException();
    }

    protected void fixupPendingList() {
        throw new UnsupportedOperationException();
    }

    protected final void add(MorphData morphData, Position fromPosData, int wordPos, int endPos, int wordID, TokenType type, boolean addPenalty) throws IOException {
        int wordCost = morphData.getWordCost(wordID);
        int leftID = morphData.getLeftId(wordID);
        int leastCost = Integer.MAX_VALUE;
        int leastIDX = -1;
        assert (fromPosData.count > 0);
        for (int idx = 0; idx < fromPosData.count; ++idx) {
            int numSpaces = wordPos - fromPosData.pos;
            int cost = fromPosData.costs[idx] + this.costs.get(fromPosData.lastRightID[idx], leftID) + this.computeSpacePenalty(morphData, wordID, numSpaces);
            if (cost >= leastCost) continue;
            leastCost = cost;
            leastIDX = idx;
        }
        leastCost += wordCost;
        if (addPenalty && type != TokenType.USER) {
            int penalty = this.computePenalty(fromPosData.pos, endPos - fromPosData.pos);
            leastCost += penalty;
        }
        ((Position)this.positions.get(endPos)).add(leastCost, morphData.getRightId(wordID), fromPosData.pos, wordPos, leastIDX, wordID, type);
    }

    protected int computeSpacePenalty(MorphData morphData, int wordID, int numSpaces) {
        return 0;
    }

    protected int computePenalty(int pos, int length) throws IOException {
        return 0;
    }

    public int getPos() {
        return this.pos;
    }

    public boolean isEnd() {
        return this.end;
    }

    public List<T> getPending() {
        return this.pending;
    }

    public boolean isOutputNBest() {
        return this.outputNBest;
    }

    public void resetBuffer(Reader reader) {
        this.buffer.reset(reader);
    }

    public void resetState() {
        this.positions.reset();
        this.pos = 0;
        this.end = false;
        this.lastBackTracePos = 0;
        this.pending.clear();
        ((Position)this.positions.get(0)).add(0, 0, -1, -1, -1, -1, TokenType.KNOWN);
    }

    public static final class WrappedPositionArray<U extends Position> {
        private U[] positions;
        private final Class<U> clazz;
        private int nextWrite;
        private int nextPos;
        private int count;

        WrappedPositionArray(Class<U> clazz) {
            this.clazz = clazz;
            this.positions = (Position[])Array.newInstance(clazz, 8);
            for (int i = 0; i < this.positions.length; ++i) {
                try {
                    this.positions[i] = (Position)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                    continue;
                }
                catch (ReflectiveOperationException e) {
                    throw new IllegalStateException(e);
                }
            }
        }

        void reset() {
            --this.nextWrite;
            while (this.count > 0) {
                if (this.nextWrite == -1) {
                    this.nextWrite = this.positions.length - 1;
                }
                ((Position)this.positions[this.nextWrite--]).reset();
                --this.count;
            }
            this.nextWrite = 0;
            this.nextPos = 0;
            this.count = 0;
        }

        public U get(int pos) {
            while (pos >= this.nextPos) {
                if (this.count == this.positions.length) {
                    Position[] newPositions = (Position[])Array.newInstance(this.clazz, ArrayUtil.oversize(1 + this.count, RamUsageEstimator.NUM_BYTES_OBJECT_REF));
                    System.arraycopy(this.positions, this.nextWrite, newPositions, 0, this.positions.length - this.nextWrite);
                    System.arraycopy(this.positions, 0, newPositions, this.positions.length - this.nextWrite, this.nextWrite);
                    for (int i = this.positions.length; i < newPositions.length; ++i) {
                        try {
                            newPositions[i] = (Position)this.clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                            continue;
                        }
                        catch (ReflectiveOperationException e) {
                            throw new IllegalStateException(e);
                        }
                    }
                    this.nextWrite = this.positions.length;
                    this.positions = newPositions;
                }
                if (this.nextWrite == this.positions.length) {
                    this.nextWrite = 0;
                }
                assert (((Position)this.positions[this.nextWrite]).count == 0);
                ++this.nextWrite;
                ++this.nextPos;
                ((Position)this.positions[this.nextWrite]).pos = ((Position)this.positions[this.nextWrite]).pos;
                ++this.count;
            }
            assert (this.inBounds(pos));
            int index = this.getIndex(pos);
            assert (((Position)this.positions[index]).pos == pos);
            return this.positions[index];
        }

        int getNextPos() {
            return this.nextPos;
        }

        private boolean inBounds(int pos) {
            return pos < this.nextPos && pos >= this.nextPos - this.count;
        }

        private int getIndex(int pos) {
            int index = this.nextWrite - (this.nextPos - pos);
            if (index < 0) {
                index += this.positions.length;
            }
            return index;
        }

        public void freeBefore(int pos) {
            int toFree = this.count - (this.nextPos - pos);
            assert (toFree >= 0);
            assert (toFree <= this.count);
            int index = this.nextWrite - this.count;
            if (index < 0) {
                index += this.positions.length;
            }
            for (int i = 0; i < toFree; ++i) {
                if (index == this.positions.length) {
                    index = 0;
                }
                ((Position)this.positions[index]).reset();
                ++index;
            }
            this.count -= toFree;
        }
    }

    public static class Position {
        int pos;
        int count;
        int[] costs = new int[8];
        int[] lastRightID = new int[8];
        int[] backPos = new int[8];
        int[] backWordPos = new int[8];
        int[] backIndex = new int[8];
        int[] backID = new int[8];
        TokenType[] backType = new TokenType[8];

        private void grow() {
            this.costs = ArrayUtil.grow(this.costs, 1 + this.count);
            this.lastRightID = ArrayUtil.grow(this.lastRightID, 1 + this.count);
            this.backPos = ArrayUtil.grow(this.backPos, 1 + this.count);
            this.backWordPos = ArrayUtil.grow(this.backWordPos, 1 + this.count);
            this.backIndex = ArrayUtil.grow(this.backIndex, 1 + this.count);
            this.backID = ArrayUtil.grow(this.backID, 1 + this.count);
            TokenType[] newBackType = new TokenType[this.backID.length];
            System.arraycopy(this.backType, 0, newBackType, 0, this.backType.length);
            this.backType = newBackType;
        }

        public void add(int cost, int lastRightID, int backPos, int backRPos, int backIndex, int backID, TokenType backType) {
            if (this.count == this.costs.length) {
                this.grow();
            }
            this.costs[this.count] = cost;
            this.lastRightID[this.count] = lastRightID;
            this.backPos[this.count] = backPos;
            this.backWordPos[this.count] = backRPos;
            this.backIndex[this.count] = backIndex;
            this.backID[this.count] = backID;
            this.backType[this.count] = backType;
            ++this.count;
        }

        public void reset() {
            this.count = 0;
        }

        public int getPos() {
            return this.pos;
        }

        public int getCount() {
            return this.count;
        }

        public void setCount(int count) {
            this.count = count;
        }

        public int getCost(int index) {
            return this.costs[index];
        }

        public int getBackPos(int index) {
            return this.backPos[index];
        }

        public int getBackWordPos(int index) {
            return this.backWordPos[index];
        }

        public int getBackID(int index) {
            return this.backID[index];
        }

        public int getBackIndex(int index) {
            return this.backIndex[index];
        }

        public TokenType getBackType(int index) {
            return this.backType[index];
        }

        public int getLastRightID(int index) {
            return this.lastRightID[index];
        }
    }
}

