/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit;

import com.intellij.execution.junit.JUnitExternalLibraryDescriptor;
import com.intellij.execution.junit.JUnitTestFramework;
import com.intellij.execution.junit.JUnitUtil;
import com.intellij.ide.fileTemplates.FileTemplateDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ExternalLibraryDescriptor;
import com.intellij.psi.JVMElementFactory;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JUnit3Framework
extends JUnitTestFramework {
    public boolean isDumbAware() {
        return ((Object)((Object)this)).getClass().isAssignableFrom(JUnit3Framework.class);
    }

    @NotNull
    public String getName() {
        return "JUnit3";
    }

    public FileTemplateDescriptor getTestClassFileTemplateDescriptor() {
        return new FileTemplateDescriptor("JUnit3 Test Class.java");
    }

    public boolean isSingleConfig() {
        return true;
    }

    public boolean isSuiteClass(PsiClass psiClass) {
        if (psiClass == null) {
            return false;
        }
        return (Boolean)JUnit3Framework.callWithAlternateResolver((Project)psiClass.getProject(), () -> JUnitUtil.findSuiteMethod((PsiClass)psiClass) != null, (Object)false);
    }

    protected String getMarkerClassFQName() {
        return "junit.framework.TestCase";
    }

    @Nullable
    public ExternalLibraryDescriptor getFrameworkLibraryDescriptor() {
        return JUnitExternalLibraryDescriptor.JUNIT3;
    }

    @Nullable
    public String getDefaultSuperClass() {
        return "junit.framework.TestCase";
    }

    public boolean isTestClass(PsiClass clazz, boolean canBePotential) {
        if (clazz == null) {
            return false;
        }
        return (Boolean)JUnit3Framework.callWithAlternateResolver((Project)clazz.getProject(), () -> {
            if (JUnitUtil.isJUnit3TestClass((PsiClass)clazz)) {
                return true;
            }
            return JUnitUtil.findSuiteMethod((PsiClass)clazz) != null;
        }, (Object)false);
    }

    @Nullable
    protected PsiMethod findSetUpMethod(@NotNull PsiClass clazz) {
        if (clazz == null) {
            JUnit3Framework.$$$reportNull$$$0(0);
        }
        return (PsiMethod)JUnit3Framework.callWithAlternateResolver((Project)clazz.getProject(), () -> {
            if (!JUnitUtil.isJUnit3TestClass((PsiClass)clazz)) {
                return null;
            }
            for (PsiMethod each : clazz.getMethods()) {
                if (!each.getName().equals("setUp")) continue;
                return each;
            }
            return null;
        }, null);
    }

    @Nullable
    protected PsiMethod findTearDownMethod(@NotNull PsiClass clazz) {
        if (clazz == null) {
            JUnit3Framework.$$$reportNull$$$0(1);
        }
        return (PsiMethod)JUnit3Framework.callWithAlternateResolver((Project)clazz.getProject(), () -> {
            if (!JUnitUtil.isJUnit3TestClass((PsiClass)clazz)) {
                return null;
            }
            for (PsiMethod each : clazz.getMethods()) {
                if (!each.getName().equals("tearDown")) continue;
                return each;
            }
            return null;
        }, null);
    }

    @Nullable
    protected PsiMethod findOrCreateSetUpMethod(PsiClass clazz) throws IncorrectOperationException {
        PsiMethod inClass;
        PsiMethod baseMethod;
        PsiManager manager = clazz.getManager();
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory();
        PsiMethod patternMethod = this.createSetUpPatternMethod((JVMElementFactory)factory);
        PsiClass baseClass = clazz.getSuperClass();
        if (baseClass != null && (baseMethod = baseClass.findMethodBySignature(patternMethod, false)) != null && baseMethod.hasModifierProperty("public")) {
            PsiUtil.setModifierProperty((PsiModifierListOwner)patternMethod, (String)"protected", (boolean)false);
            PsiUtil.setModifierProperty((PsiModifierListOwner)patternMethod, (String)"public", (boolean)true);
        }
        if ((inClass = clazz.findMethodBySignature(patternMethod, false)) == null) {
            PsiMethod testMethod = JUnitUtil.findFirstTestMethod((PsiClass)clazz);
            if (testMethod != null) {
                return (PsiMethod)clazz.addBefore((PsiElement)patternMethod, (PsiElement)testMethod);
            }
            return (PsiMethod)clazz.add((PsiElement)patternMethod);
        }
        if (inClass.getBody() == null) {
            return (PsiMethod)inClass.replace((PsiElement)patternMethod);
        }
        return inClass;
    }

    public FileTemplateDescriptor getSetUpMethodFileTemplateDescriptor() {
        return new FileTemplateDescriptor("JUnit3 SetUp Method.java");
    }

    public FileTemplateDescriptor getTearDownMethodFileTemplateDescriptor() {
        return new FileTemplateDescriptor("JUnit3 TearDown Method.java");
    }

    @NotNull
    public FileTemplateDescriptor getTestMethodFileTemplateDescriptor() {
        return new FileTemplateDescriptor("JUnit3 Test Method.java");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "clazz";
        objectArray2[1] = "com/intellij/execution/junit/JUnit3Framework";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "findSetUpMethod";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "findTearDownMethod";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

