/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.datastruct;

import ghidra.util.datastruct.DataStructureErrorHandlerFactory;
import ghidra.util.datastruct.ListenerErrorHandler;
import ghidra.util.datastruct.ThreadSafeListenerStorage;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Objects;

public class ListenerSet<T> {
    private final T proxy;
    private final ThreadSafeListenerStorage<T> listeners;
    private ListenerErrorHandler errorHandler = DataStructureErrorHandlerFactory.createListenerErrorHandler();

    public ListenerSet(Class<T> iface, boolean isWeak) {
        Objects.requireNonNull(iface);
        this.proxy = iface.cast(Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{iface}, (InvocationHandler)new ListenerHandler()));
        this.listeners = new ThreadSafeListenerStorage(isWeak);
    }

    public T invoke() {
        return this.proxy;
    }

    public T getProxy() {
        return this.proxy;
    }

    public String toString() {
        return this.listeners.toString();
    }

    public boolean add(T e) {
        return this.listeners.add(e);
    }

    public boolean remove(T e) {
        return this.listeners.remove(e);
    }

    public void clear() {
        this.listeners.clear();
    }

    public int size() {
        return this.listeners.size();
    }

    public void setErrorHandler(ListenerErrorHandler errorHandler) {
        this.errorHandler = Objects.requireNonNull(errorHandler);
    }

    private class ListenerHandler
    implements InvocationHandler {
        private ListenerHandler() {
        }

        @Override
        public Object invoke(Object proxyObject, Method method, Object[] args) throws Throwable {
            ListenerSet.this.listeners.forEach(listener -> {
                try {
                    method.invoke(listener, args);
                }
                catch (InvocationTargetException e) {
                    Throwable cause = e.getCause();
                    ListenerSet.this.errorHandler.handleError(listener, cause);
                }
                catch (Throwable e) {
                    ListenerSet.this.errorHandler.handleError(listener, e);
                }
            });
            return null;
        }
    }
}

