/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu.jit.op;

import ghidra.pcode.emu.jit.JitPassage;
import ghidra.pcode.emu.jit.analysis.JitTypeBehavior;
import ghidra.pcode.emu.jit.op.JitBoolAndOp;
import ghidra.pcode.emu.jit.op.JitBoolNegateOp;
import ghidra.pcode.emu.jit.op.JitBoolOrOp;
import ghidra.pcode.emu.jit.op.JitBoolXorOp;
import ghidra.pcode.emu.jit.op.JitCopyOp;
import ghidra.pcode.emu.jit.op.JitDefOp;
import ghidra.pcode.emu.jit.op.JitFloatAbsOp;
import ghidra.pcode.emu.jit.op.JitFloatAddOp;
import ghidra.pcode.emu.jit.op.JitFloatCeilOp;
import ghidra.pcode.emu.jit.op.JitFloatDivOp;
import ghidra.pcode.emu.jit.op.JitFloatEqualOp;
import ghidra.pcode.emu.jit.op.JitFloatFloat2FloatOp;
import ghidra.pcode.emu.jit.op.JitFloatFloorOp;
import ghidra.pcode.emu.jit.op.JitFloatInt2FloatOp;
import ghidra.pcode.emu.jit.op.JitFloatLessEqualOp;
import ghidra.pcode.emu.jit.op.JitFloatLessOp;
import ghidra.pcode.emu.jit.op.JitFloatMultOp;
import ghidra.pcode.emu.jit.op.JitFloatNaNOp;
import ghidra.pcode.emu.jit.op.JitFloatNegOp;
import ghidra.pcode.emu.jit.op.JitFloatNotEqualOp;
import ghidra.pcode.emu.jit.op.JitFloatRoundOp;
import ghidra.pcode.emu.jit.op.JitFloatSqrtOp;
import ghidra.pcode.emu.jit.op.JitFloatSubOp;
import ghidra.pcode.emu.jit.op.JitFloatTruncOp;
import ghidra.pcode.emu.jit.op.JitInt2CompOp;
import ghidra.pcode.emu.jit.op.JitIntAddOp;
import ghidra.pcode.emu.jit.op.JitIntAndOp;
import ghidra.pcode.emu.jit.op.JitIntCarryOp;
import ghidra.pcode.emu.jit.op.JitIntDivOp;
import ghidra.pcode.emu.jit.op.JitIntEqualOp;
import ghidra.pcode.emu.jit.op.JitIntLeftOp;
import ghidra.pcode.emu.jit.op.JitIntLessEqualOp;
import ghidra.pcode.emu.jit.op.JitIntLessOp;
import ghidra.pcode.emu.jit.op.JitIntMultOp;
import ghidra.pcode.emu.jit.op.JitIntNegateOp;
import ghidra.pcode.emu.jit.op.JitIntNotEqualOp;
import ghidra.pcode.emu.jit.op.JitIntOrOp;
import ghidra.pcode.emu.jit.op.JitIntRemOp;
import ghidra.pcode.emu.jit.op.JitIntRightOp;
import ghidra.pcode.emu.jit.op.JitIntSBorrowOp;
import ghidra.pcode.emu.jit.op.JitIntSCarryOp;
import ghidra.pcode.emu.jit.op.JitIntSDivOp;
import ghidra.pcode.emu.jit.op.JitIntSExtOp;
import ghidra.pcode.emu.jit.op.JitIntSLessEqualOp;
import ghidra.pcode.emu.jit.op.JitIntSLessOp;
import ghidra.pcode.emu.jit.op.JitIntSRemOp;
import ghidra.pcode.emu.jit.op.JitIntSRightOp;
import ghidra.pcode.emu.jit.op.JitIntSubOp;
import ghidra.pcode.emu.jit.op.JitIntXorOp;
import ghidra.pcode.emu.jit.op.JitIntZExtOp;
import ghidra.pcode.emu.jit.op.JitLzCountOp;
import ghidra.pcode.emu.jit.op.JitNopOp;
import ghidra.pcode.emu.jit.op.JitPopCountOp;
import ghidra.pcode.emu.jit.op.JitSubPieceOp;
import ghidra.pcode.emu.jit.op.JitUnOp;
import ghidra.pcode.emu.jit.op.JitUnimplementedOp;
import ghidra.pcode.emu.jit.var.JitConstVal;
import ghidra.pcode.emu.jit.var.JitOutVar;
import ghidra.pcode.emu.jit.var.JitVal;
import ghidra.program.model.pcode.PcodeOp;
import java.util.List;

public interface JitOp {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static JitOp stubOp(PcodeOp op) {
        if (op instanceof JitPassage.NopPcodeOp) {
            return new JitNopOp(op);
        }
        switch (op.getOpcode()) {
            case 0: {
                return new JitUnimplementedOp(op);
            }
            default: {
                throw new UnsupportedOperationException("Unrecognized stub op: " + op.getMnemonic());
            }
        }
    }

    public static JitUnOp unOp(PcodeOp op, JitOutVar out, JitVal u) {
        return switch (op.getOpcode()) {
            case 1 -> new JitCopyOp(op, out, u);
            case 17 -> new JitIntZExtOp(op, out, u);
            case 18 -> new JitIntSExtOp(op, out, u);
            case 24 -> new JitInt2CompOp(op, out, u);
            case 25 -> new JitIntNegateOp(op, out, u);
            case 72 -> new JitPopCountOp(op, out, u);
            case 73 -> new JitLzCountOp(op, out, u);
            case 37 -> new JitBoolNegateOp(op, out, u);
            case 46 -> new JitFloatNaNOp(op, out, u);
            case 51 -> new JitFloatNegOp(op, out, u);
            case 52 -> new JitFloatAbsOp(op, out, u);
            case 53 -> new JitFloatSqrtOp(op, out, u);
            case 54 -> new JitFloatInt2FloatOp(op, out, u);
            case 55 -> new JitFloatFloat2FloatOp(op, out, u);
            case 56 -> new JitFloatTruncOp(op, out, u);
            case 57 -> new JitFloatCeilOp(op, out, u);
            case 58 -> new JitFloatFloorOp(op, out, u);
            case 59 -> new JitFloatRoundOp(op, out, u);
            default -> throw new UnsupportedOperationException("Unrecognized un op: " + op.getMnemonic());
        };
    }

    public static JitDefOp binOp(PcodeOp op, JitOutVar out, JitVal l, JitVal r) {
        return switch (op.getOpcode()) {
            case 11 -> new JitIntEqualOp(op, out, l, r);
            case 12 -> new JitIntNotEqualOp(op, out, l, r);
            case 13 -> new JitIntSLessOp(op, out, l, r);
            case 14 -> new JitIntSLessEqualOp(op, out, l, r);
            case 15 -> new JitIntLessOp(op, out, l, r);
            case 16 -> new JitIntLessEqualOp(op, out, l, r);
            case 19 -> new JitIntAddOp(op, out, l, r);
            case 20 -> new JitIntSubOp(op, out, l, r);
            case 21 -> new JitIntCarryOp(op, out, l, r);
            case 22 -> new JitIntSCarryOp(op, out, l, r);
            case 23 -> new JitIntSBorrowOp(op, out, l, r);
            case 26 -> new JitIntXorOp(op, out, l, r);
            case 27 -> new JitIntAndOp(op, out, l, r);
            case 28 -> new JitIntOrOp(op, out, l, r);
            case 29 -> new JitIntLeftOp(op, out, l, r);
            case 30 -> new JitIntRightOp(op, out, l, r);
            case 31 -> new JitIntSRightOp(op, out, l, r);
            case 32 -> new JitIntMultOp(op, out, l, r);
            case 33 -> new JitIntDivOp(op, out, l, r);
            case 34 -> new JitIntSDivOp(op, out, l, r);
            case 35 -> new JitIntRemOp(op, out, l, r);
            case 36 -> new JitIntSRemOp(op, out, l, r);
            case 38 -> new JitBoolXorOp(op, out, l, r);
            case 39 -> new JitBoolAndOp(op, out, l, r);
            case 40 -> new JitBoolOrOp(op, out, l, r);
            case 41 -> new JitFloatEqualOp(op, out, l, r);
            case 42 -> new JitFloatNotEqualOp(op, out, l, r);
            case 43 -> new JitFloatLessOp(op, out, l, r);
            case 44 -> new JitFloatLessEqualOp(op, out, l, r);
            case 47 -> new JitFloatAddOp(op, out, l, r);
            case 48 -> new JitFloatDivOp(op, out, l, r);
            case 49 -> new JitFloatMultOp(op, out, l, r);
            case 50 -> new JitFloatSubOp(op, out, l, r);
            case 63 -> new JitSubPieceOp(op, out, l, ((JitConstVal)r).value().intValue());
            default -> throw new UnsupportedOperationException("Unrecognized bin op: " + op.getMnemonic());
        };
    }

    public PcodeOp op();

    public boolean canBeRemoved();

    public List<JitVal> inputs();

    public JitTypeBehavior typeFor(int var1);

    public void link();

    public void unlink();
}

