/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu.jit.analysis;

import ghidra.app.plugin.processors.sleigh.SleighLanguage;
import ghidra.pcode.emu.jit.analysis.JitAnalysisContext;
import ghidra.pcode.emu.jit.analysis.JitDataFlowModel;
import ghidra.pcode.emu.jit.analysis.JitType;
import ghidra.pcode.emu.jit.analysis.JitTypeBehavior;
import ghidra.pcode.emu.jit.analysis.JitTypeModel;
import ghidra.pcode.emu.jit.analysis.JitVarScopeModel;
import ghidra.pcode.emu.jit.gen.GenConsts;
import ghidra.pcode.emu.jit.gen.JitCodeGenerator;
import ghidra.pcode.emu.jit.gen.type.TypeConversions;
import ghidra.pcode.emu.jit.gen.var.VarGen;
import ghidra.pcode.emu.jit.var.JitConstVal;
import ghidra.pcode.emu.jit.var.JitFailVal;
import ghidra.pcode.emu.jit.var.JitMemoryVar;
import ghidra.pcode.emu.jit.var.JitVal;
import ghidra.pcode.emu.jit.var.JitVarnodeVar;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.Endian;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.Register;
import ghidra.program.model.pcode.Varnode;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.TreeMap;
import org.apache.commons.collections4.iterators.ReverseListIterator;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class JitAllocationModel {
    private final JitDataFlowModel dfm;
    private final JitVarScopeModel vsm;
    private final JitTypeModel tm;
    private final SleighLanguage language;
    private final Endian endian;
    private int nextLocal = RunFixedLocal.ALL.size();
    private final Map<JitVal, VarHandler> handlers = new HashMap<JitVal, VarHandler>();
    private final Map<Varnode, VarHandler> handlersPerVarnode = new HashMap<Varnode, VarHandler>();
    private final NavigableMap<Address, JvmLocal> locals = new TreeMap<Address, JvmLocal>();
    private final Map<Varnode, TypeContest> typeContests = new HashMap<Varnode, TypeContest>();

    public JitAllocationModel(JitAnalysisContext context, JitDataFlowModel dfm, JitVarScopeModel vsm, JitTypeModel tm) {
        this.dfm = dfm;
        this.vsm = vsm;
        this.tm = tm;
        this.endian = context.getEndian();
        this.language = context.getLanguage();
        this.allocate();
    }

    private JvmLocal genFreeLocal(String name, JitType.SimpleJitType type, VarDesc desc) {
        int i;
        block0: {
            i = this.nextLocal++;
            if (type.javaType() != Long.TYPE && type.javaType() != Double.TYPE) break block0;
            this.nextLocal += 2;
        }
        return new JvmLocal(i, name, type, desc.toVarnode());
    }

    public int nextFreeLocal() {
        return this.nextLocal;
    }

    private List<JvmLocal> genFreeLocals(String name, List<JitType.SimpleJitType> types, VarDesc desc) {
        JvmLocal[] result = new JvmLocal[types.size()];
        Iterable<JitType.SimpleJitType> it = this.language.isBigEndian() ? types : () -> new ReverseListIterator(types);
        long offset = desc.offset;
        int i = 0;
        for (JitType.SimpleJitType t : it) {
            VarDesc d = new VarDesc(desc.spaceId, offset, t.size(), t, (Language)this.language);
            result[i] = this.genFreeLocal(name + "_" + i, t, d);
            offset += (long)t.size();
            ++i;
        }
        return List.of(result);
    }

    private OneLocalVarHandler createOneLocalHandler(JvmLocal local) {
        JitType.SimpleJitType simpleJitType = local.type;
        Objects.requireNonNull(simpleJitType);
        JitType.SimpleJitType simpleJitType2 = simpleJitType;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JitType.IntJitType.class, JitType.LongJitType.class, JitType.FloatJitType.class, JitType.DoubleJitType.class}, (Object)simpleJitType2, n)) {
            case 0 -> {
                JitType.IntJitType t = (JitType.IntJitType)simpleJitType2;
                yield new IntVarAlloc(local, t);
            }
            case 1 -> {
                JitType.LongJitType t = (JitType.LongJitType)simpleJitType2;
                yield new LongVarAlloc(local, t);
            }
            case 2 -> {
                JitType.FloatJitType t = (JitType.FloatJitType)simpleJitType2;
                yield new FloatVarAlloc(local, t);
            }
            case 3 -> {
                JitType.DoubleJitType t = (JitType.DoubleJitType)simpleJitType2;
                yield new DoubleVarAlloc(local, t);
            }
            default -> throw new AssertionError();
        };
    }

    private VarHandler createComplicatedHandler(Varnode vn) {
        Map.Entry<Address, JvmLocal> leftEntry = this.locals.floorEntry(vn.getAddress());
        assert (JitVarScopeModel.overlapsLeft(leftEntry.getValue().vn, vn));
        Address min = leftEntry.getKey();
        NavigableMap<Address, JvmLocal> sub = this.locals.subMap(min, true, JitVarScopeModel.maxAddr(vn), true);
        ArrayList<MultiLocalPart> parts = new ArrayList<MultiLocalPart>();
        for (JvmLocal local : sub.values()) {
            int offset = switch (this.endian) {
                default -> throw new MatchException(null, null);
                case Endian.BIG -> (int)JitVarScopeModel.maxAddr(leftEntry.getValue().vn).subtract(JitVarScopeModel.maxAddr(vn));
                case Endian.LITTLE -> (int)vn.getAddress().subtract(leftEntry.getKey());
            };
            parts.add(new MultiLocalPart(local, offset));
        }
        return new MultiLocalVarHandler(parts, JitTypeBehavior.INTEGER.type(vn.getSize()));
    }

    private VarHandler getOrCreateHandlerForVarnodeVar(JitVarnodeVar vv) {
        return this.handlersPerVarnode.computeIfAbsent(vv.varnode(), vn -> {
            JvmLocal oneLocal = (JvmLocal)this.locals.get(vn.getAddress());
            if (oneLocal != null && oneLocal.vn.equals(vn)) {
                return this.createOneLocalHandler(oneLocal);
            }
            return this.createComplicatedHandler((Varnode)vn);
        });
    }

    private VarHandler createHandler(JitVal v) {
        if (v instanceof JitConstVal) {
            return NoHandler.INSTANCE;
        }
        if (v instanceof JitFailVal) {
            return NoHandler.INSTANCE;
        }
        if (v instanceof JitMemoryVar) {
            return NoHandler.INSTANCE;
        }
        if (v instanceof JitVarnodeVar) {
            JitVarnodeVar vv = (JitVarnodeVar)v;
            return this.getOrCreateHandlerForVarnodeVar(vv);
        }
        throw new AssertionError();
    }

    private void allocate() {
        for (JitVal v : this.dfm.allValues()) {
            if (!(v instanceof JitVarnodeVar)) continue;
            JitVarnodeVar vv = (JitVarnodeVar)v;
            if (v instanceof JitMemoryVar) continue;
            Varnode vn = vv.varnode();
            Varnode coalesced = this.vsm.getCoalesced(vn);
            TypeContest tc = this.typeContests.computeIfAbsent(coalesced, __ -> new TypeContest());
            if (vn.equals((Object)coalesced)) {
                tc.vote(this.tm.typeOf(v));
                continue;
            }
            tc.vote(JitTypeBehavior.INTEGER.type(coalesced.getSize()));
        }
        block5: for (Map.Entry entry : this.typeContests.entrySet().stream().sorted(Comparator.comparing(e -> ((Varnode)e.getKey()).getAddress())).toList()) {
            JitType jitType;
            VarDesc desc = VarDesc.fromVarnode((Varnode)entry.getKey(), ((TypeContest)entry.getValue()).winner(), (Language)this.language);
            Objects.requireNonNull(desc.type());
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JitType.SimpleJitType.class, JitType.MpIntJitType.class}, (Object)jitType, n)) {
                case 0: {
                    JitType.SimpleJitType t = (JitType.SimpleJitType)jitType;
                    this.locals.put(((Varnode)entry.getKey()).getAddress(), this.genFreeLocal(desc.name(), t, desc));
                    break;
                }
                case 1: {
                    JitType.MpIntJitType t = (JitType.MpIntJitType)jitType;
                    for (JvmLocal leg : this.genFreeLocals(desc.name(), t.legTypes(), desc)) {
                        this.locals.put(leg.vn.getAddress(), leg);
                    }
                    continue block5;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }
        for (JitVal v : this.dfm.allValuesSorted()) {
            this.handlers.put(v, this.createHandler(v));
        }
    }

    public VarHandler getHandler(JitVal v) {
        return this.handlers.get(v);
    }

    public Collection<JvmLocal> allLocals() {
        return this.locals.values();
    }

    public Collection<JvmLocal> localsForVn(Varnode vn) {
        Address min = vn.getAddress();
        Address floor = this.locals.floorKey(min);
        if (floor != null) {
            min = floor;
        }
        return this.locals.subMap(min, true, JitVarScopeModel.maxAddr(vn), true).values();
    }

    public static enum RunFixedLocal implements FixedLocal
    {
        THIS("this", 25, 58){

            @Override
            public String typeDesc(String nameThis) {
                return "L" + nameThis + ";";
            }
        }
        ,
        BLOCK_ID("blockId", 21, 54){

            @Override
            public String typeDesc(String nameThis) {
                return Type.getDescriptor(Integer.TYPE);
            }
        }
        ,
        CTXMOD("ctxmod", 21, 54){

            @Override
            public String typeDesc(String nameThis) {
                return Type.getDescriptor(Boolean.TYPE);
            }

            @Override
            public void generateDeclCode(MethodVisitor mv, String nameThis, Label startLocals, Label endLocals) {
                super.generateDeclCode(mv, nameThis, startLocals, endLocals);
                mv.visitLdcInsn((Object)0);
                mv.visitVarInsn(54, this.index());
            }
        };

        private final String varName;
        private final int opcodeLoad;
        private final int opcodeStore;
        public static final List<FixedLocal> ALL;

        private RunFixedLocal(String varName, int opcodeLoad, int opcodeStore) {
            this.varName = varName;
            this.opcodeLoad = opcodeLoad;
            this.opcodeStore = opcodeStore;
        }

        @Override
        public int index() {
            return this.ordinal();
        }

        @Override
        public String varName() {
            return this.varName;
        }

        @Override
        public int opcodeLoad() {
            return this.opcodeLoad;
        }

        @Override
        public int opcodeStore() {
            return this.opcodeStore;
        }

        static {
            ALL = List.of(RunFixedLocal.values());
        }
    }

    public record JvmLocal(int index, String name, JitType.SimpleJitType type, Varnode vn) {
        public void generateInitCode(JitCodeGenerator gen, MethodVisitor iv) {
            VarGen.generateValInitCode(gen, this.vn);
        }

        public void generateDeclCode(JitCodeGenerator gen, Label start, Label end, MethodVisitor rv) {
            rv.visitLocalVariable(this.name, Type.getDescriptor(this.type.javaType()), null, start, end, this.index);
        }

        public void generateLoadCode(MethodVisitor rv) {
            rv.visitVarInsn(this.type.opcodeLoad(), this.index);
        }

        public void generateStoreCode(MethodVisitor rv) {
            rv.visitVarInsn(this.type.opcodeStore(), this.index);
        }

        public void generateBirthCode(JitCodeGenerator gen, MethodVisitor rv) {
            VarGen.generateValReadCodeDirect(gen, this.type, this.vn, rv);
            this.generateStoreCode(rv);
        }

        public void generateRetireCode(JitCodeGenerator gen, MethodVisitor rv) {
            this.generateLoadCode(rv);
            VarGen.generateValWriteCodeDirect(gen, this.type, this.vn, rv);
        }
    }

    private record VarDesc(int spaceId, long offset, int size, JitType type, Language language) {
        static VarDesc fromVarnode(Varnode vn, JitType type, Language language) {
            return new VarDesc(vn.getSpace(), vn.getOffset(), vn.getSize(), type, language);
        }

        public String name() {
            AddressFactory factory = this.language.getAddressFactory();
            AddressSpace space = factory.getAddressSpace(this.spaceId);
            Register reg = this.language.getRegister(space, this.offset, this.size);
            if (reg != null) {
                return "%s_%d_%s".formatted(reg.getName(), this.size, this.type.nm());
            }
            return "s%d_%x_%d_%s".formatted(this.spaceId, this.offset, this.size, this.type.nm());
        }

        public Varnode toVarnode() {
            AddressFactory factory = this.language.getAddressFactory();
            return new Varnode(factory.getAddressSpace(this.spaceId).getAddress(this.offset), this.size);
        }
    }

    public static final class IntVarAlloc
    extends Record
    implements OneLocalVarHandler {
        private final JvmLocal local;
        private final JitType.IntJitType type;

        public IntVarAlloc(JvmLocal local, JitType.IntJitType type) {
            this.local = local;
            this.type = type;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{IntVarAlloc.class, "local;type", "local", "type"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{IntVarAlloc.class, "local;type", "local", "type"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{IntVarAlloc.class, "local;type", "local", "type"}, this, o);
        }

        @Override
        public JvmLocal local() {
            return this.local;
        }

        @Override
        public JitType.IntJitType type() {
            return this.type;
        }
    }

    public static final class LongVarAlloc
    extends Record
    implements OneLocalVarHandler {
        private final JvmLocal local;
        private final JitType.LongJitType type;

        public LongVarAlloc(JvmLocal local, JitType.LongJitType type) {
            this.local = local;
            this.type = type;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{LongVarAlloc.class, "local;type", "local", "type"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{LongVarAlloc.class, "local;type", "local", "type"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{LongVarAlloc.class, "local;type", "local", "type"}, this, o);
        }

        @Override
        public JvmLocal local() {
            return this.local;
        }

        @Override
        public JitType.LongJitType type() {
            return this.type;
        }
    }

    public static final class FloatVarAlloc
    extends Record
    implements OneLocalVarHandler {
        private final JvmLocal local;
        private final JitType.FloatJitType type;

        public FloatVarAlloc(JvmLocal local, JitType.FloatJitType type) {
            this.local = local;
            this.type = type;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{FloatVarAlloc.class, "local;type", "local", "type"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{FloatVarAlloc.class, "local;type", "local", "type"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{FloatVarAlloc.class, "local;type", "local", "type"}, this, o);
        }

        @Override
        public JvmLocal local() {
            return this.local;
        }

        @Override
        public JitType.FloatJitType type() {
            return this.type;
        }
    }

    public static final class DoubleVarAlloc
    extends Record
    implements OneLocalVarHandler {
        private final JvmLocal local;
        private final JitType.DoubleJitType type;

        public DoubleVarAlloc(JvmLocal local, JitType.DoubleJitType type) {
            this.local = local;
            this.type = type;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{DoubleVarAlloc.class, "local;type", "local", "type"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{DoubleVarAlloc.class, "local;type", "local", "type"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{DoubleVarAlloc.class, "local;type", "local", "type"}, this, o);
        }

        @Override
        public JvmLocal local() {
            return this.local;
        }

        @Override
        public JitType.DoubleJitType type() {
            return this.type;
        }
    }

    public record MultiLocalPart(JvmLocal local, int shift) {
        private JitType chooseLargerType(JitType t1, JitType t2) {
            return t1.size() > t2.size() ? t1 : t2;
        }

        public void generateLoadCode(JitCodeGenerator gen, JitType type, MethodVisitor rv) {
            this.local.generateLoadCode(rv);
            JitType tempType = this.chooseLargerType(this.local.type, type);
            TypeConversions.generate(gen, this.local.type, tempType, rv);
            if (this.shift > 0) {
                JitType jitType = tempType;
                Objects.requireNonNull(jitType);
                JitType jitType2 = jitType;
                int n = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JitType.IntJitType.class, JitType.LongJitType.class}, (Object)jitType2, n)) {
                    case 0: {
                        JitType.IntJitType t = (JitType.IntJitType)jitType2;
                        rv.visitLdcInsn((Object)(this.shift * 8));
                        rv.visitInsn(124);
                        break;
                    }
                    case 1: {
                        JitType.LongJitType t = (JitType.LongJitType)jitType2;
                        rv.visitLdcInsn((Object)(this.shift * 8));
                        rv.visitInsn(125);
                        break;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
            } else if (this.shift < 0) {
                JitType jitType = tempType;
                Objects.requireNonNull(jitType);
                JitType jitType3 = jitType;
                int n = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JitType.IntJitType.class, JitType.LongJitType.class}, (Object)jitType3, n)) {
                    case 0: {
                        JitType.IntJitType t = (JitType.IntJitType)jitType3;
                        rv.visitLdcInsn((Object)(-this.shift * 8));
                        rv.visitInsn(120);
                        break;
                    }
                    case 1: {
                        JitType.LongJitType t = (JitType.LongJitType)jitType3;
                        rv.visitLdcInsn((Object)(-this.shift * 8));
                        rv.visitInsn(121);
                        break;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
            }
            TypeConversions.generate(gen, tempType, type, rv);
        }

        public void generateStoreCode(JitCodeGenerator gen, JitType type, MethodVisitor rv) {
            JitType.LongJitType t;
            JitType.IntJitType t2;
            JitType tempType = this.chooseLargerType(this.local.type, type);
            TypeConversions.generate(gen, type, tempType, rv);
            JitType jitType = tempType;
            Objects.requireNonNull(jitType);
            JitType jitType2 = jitType;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JitType.IntJitType.class, JitType.LongJitType.class}, (Object)jitType2, n)) {
                case 0: {
                    t2 = (JitType.IntJitType)jitType2;
                    if (this.shift > 0) {
                        rv.visitLdcInsn((Object)(this.shift * 8));
                        rv.visitInsn(120);
                        break;
                    }
                    if (this.shift >= 0) break;
                    rv.visitLdcInsn((Object)(-this.shift * 8));
                    rv.visitInsn(124);
                    break;
                }
                case 1: {
                    t = (JitType.LongJitType)jitType2;
                    if (this.shift > 0) {
                        rv.visitLdcInsn((Object)(this.shift * 8));
                        rv.visitInsn(121);
                        break;
                    }
                    if (this.shift >= 0) break;
                    rv.visitLdcInsn((Object)(-this.shift * 8));
                    rv.visitInsn(125);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            TypeConversions.generate(gen, tempType, this.local.type, rv);
            JitType.SimpleJitType simpleJitType = this.local.type;
            Objects.requireNonNull(simpleJitType);
            jitType2 = simpleJitType;
            n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JitType.IntJitType.class, JitType.LongJitType.class}, (Object)jitType2, n)) {
                case 0: {
                    t2 = (JitType.IntJitType)jitType2;
                    int mask = -1 >>> 32 - 8 * type.size();
                    mask = this.shift > 0 ? (mask <<= this.shift * 8) : (mask >>>= -this.shift * 8);
                    rv.visitLdcInsn((Object)mask);
                    rv.visitInsn(126);
                    this.local.generateLoadCode(rv);
                    rv.visitLdcInsn((Object)(~mask));
                    rv.visitInsn(126);
                    rv.visitInsn(128);
                    this.local.generateStoreCode(rv);
                    break;
                }
                case 1: {
                    t = (JitType.LongJitType)jitType2;
                    long mask = -1L >>> 64 - 8 * type.size();
                    mask = this.shift > 0 ? (mask <<= this.shift * 8) : (mask >>>= -this.shift * 8);
                    rv.visitLdcInsn((Object)mask);
                    rv.visitInsn(127);
                    this.local.generateLoadCode(rv);
                    rv.visitLdcInsn((Object)(mask ^ 0xFFFFFFFFFFFFFFFFL));
                    rv.visitInsn(127);
                    rv.visitInsn(129);
                    this.local.generateStoreCode(rv);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }
    }

    public record MultiLocalVarHandler(List<MultiLocalPart> parts, JitType type) implements VarHandler
    {
        @Override
        public void generateInitCode(JitCodeGenerator gen, MethodVisitor iv) {
        }

        @Override
        public void generateDeclCode(JitCodeGenerator gen, Label start, Label end, MethodVisitor rv) {
        }

        @Override
        public void generateLoadCode(JitCodeGenerator gen, JitType type, MethodVisitor rv) {
            this.parts.get(0).generateLoadCode(gen, this.type, rv);
            block4: for (MultiLocalPart part : this.parts.subList(1, this.parts.size())) {
                JitType jitType;
                part.generateLoadCode(gen, this.type, rv);
                Objects.requireNonNull(this.type);
                int n = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JitType.IntJitType.class, JitType.LongJitType.class}, (Object)jitType, n)) {
                    case 0: {
                        JitType.IntJitType t = (JitType.IntJitType)jitType;
                        rv.visitInsn(128);
                        continue block4;
                    }
                    case 1: {
                        JitType.LongJitType t = (JitType.LongJitType)jitType;
                        rv.visitInsn(129);
                        continue block4;
                    }
                }
                throw new AssertionError();
            }
            TypeConversions.generate(gen, this.type, type, rv);
        }

        @Override
        public void generateStoreCode(JitCodeGenerator gen, JitType type, MethodVisitor rv) {
            TypeConversions.generate(gen, type, this.type, rv);
            for (MultiLocalPart part : this.parts.subList(1, this.parts.size()).reversed()) {
                JitType jitType;
                Objects.requireNonNull(this.type);
                int n = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JitType.IntJitType.class, JitType.LongJitType.class}, (Object)jitType, n)) {
                    case 0: {
                        JitType.IntJitType t = (JitType.IntJitType)jitType;
                        rv.visitInsn(89);
                        break;
                    }
                    case 1: {
                        JitType.LongJitType t = (JitType.LongJitType)jitType;
                        rv.visitInsn(92);
                        break;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
                part.generateStoreCode(gen, this.type, rv);
            }
            this.parts.get(0).generateStoreCode(gen, this.type, rv);
        }
    }

    public static interface VarHandler {
        public JitType type();

        public void generateInitCode(JitCodeGenerator var1, MethodVisitor var2);

        public void generateDeclCode(JitCodeGenerator var1, Label var2, Label var3, MethodVisitor var4);

        public void generateLoadCode(JitCodeGenerator var1, JitType var2, MethodVisitor var3);

        public void generateStoreCode(JitCodeGenerator var1, JitType var2, MethodVisitor var3);
    }

    public static enum NoHandler implements VarHandler
    {
        INSTANCE;


        @Override
        public JitType type() {
            return null;
        }

        @Override
        public void generateInitCode(JitCodeGenerator gen, MethodVisitor iv) {
        }

        @Override
        public void generateDeclCode(JitCodeGenerator gen, Label start, Label end, MethodVisitor rv) {
        }

        @Override
        public void generateLoadCode(JitCodeGenerator gen, JitType type, MethodVisitor rv) {
            throw new AssertionError();
        }

        @Override
        public void generateStoreCode(JitCodeGenerator gen, JitType type, MethodVisitor rv) {
            throw new AssertionError();
        }
    }

    record TypeContest(Map<JitType, Integer> map) {
        public TypeContest() {
            this(new HashMap<JitType, Integer>());
        }

        public void vote(JitType type) {
            this.map.compute(type.ext(), (t, v) -> v == null ? 1 : v + 1);
        }

        public JitType winner() {
            int max = this.map.values().stream().max(Integer::compare).get();
            return this.map.entrySet().stream().filter(e -> (Integer)e.getValue() == max).map(Map.Entry::getKey).sorted(Comparator.comparing(JitType::pref)).findFirst().get();
        }
    }

    public static interface OneLocalVarHandler
    extends VarHandler {
        public JvmLocal local();

        @Override
        default public void generateInitCode(JitCodeGenerator gen, MethodVisitor iv) {
        }

        @Override
        default public void generateDeclCode(JitCodeGenerator gen, Label start, Label end, MethodVisitor rv) {
        }

        @Override
        default public void generateLoadCode(JitCodeGenerator gen, JitType type, MethodVisitor rv) {
            this.local().generateLoadCode(rv);
            TypeConversions.generate(gen, this.type(), type, rv);
        }

        @Override
        default public void generateStoreCode(JitCodeGenerator gen, JitType type, MethodVisitor rv) {
            TypeConversions.generate(gen, type, this.type(), rv);
            this.local().generateStoreCode(rv);
        }
    }

    public static enum InitFixedLocal implements FixedLocal
    {
        THIS("this", 25, 58){

            @Override
            public String typeDesc(String nameThis) {
                return "L" + nameThis + ";";
            }
        }
        ,
        THREAD("thread", 25, 58){

            @Override
            public String typeDesc(String nameThis) {
                return GenConsts.TDESC_JIT_PCODE_THREAD;
            }
        };

        private final String varName;
        private final int opcodeLoad;
        private final int opcodeStore;

        private InitFixedLocal(String varName, int opcodeLoad, int opcodeStore) {
            this.varName = varName;
            this.opcodeLoad = opcodeLoad;
            this.opcodeStore = opcodeStore;
        }

        @Override
        public int index() {
            return this.ordinal();
        }

        @Override
        public String varName() {
            return this.varName;
        }

        @Override
        public int opcodeLoad() {
            return this.opcodeLoad;
        }

        @Override
        public int opcodeStore() {
            return this.opcodeStore;
        }
    }

    public static interface FixedLocal {
        public int index();

        public String varName();

        public String typeDesc(String var1);

        public int opcodeLoad();

        public int opcodeStore();

        default public void generateDeclCode(MethodVisitor mv, String nameThis, Label startLocals, Label endLocals) {
            mv.visitLocalVariable(this.varName(), this.typeDesc(nameThis), null, startLocals, endLocals, this.index());
        }

        default public void generateLoadCode(MethodVisitor mv) {
            mv.visitVarInsn(this.opcodeLoad(), this.index());
        }

        default public void generateStoreCode(MethodVisitor mv) {
            mv.visitVarInsn(this.opcodeStore(), this.index());
        }
    }
}

