/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.dex.format;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.StructConverterUtil;
import ghidra.file.formats.android.dex.format.AnnotationSetItem;
import ghidra.file.formats.android.dex.format.DexHeader;
import ghidra.file.formats.android.dex.util.DexUtil;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class FieldAnnotationsItem
implements StructConverter {
    private int fieldIndex;
    private int annotationsOffset;
    private AnnotationSetItem _annotationSetItem;

    public FieldAnnotationsItem(BinaryReader reader, DexHeader dexHeader) throws IOException {
        this.fieldIndex = reader.readNextInt();
        this.annotationsOffset = reader.readNextInt();
        if (this.annotationsOffset > 0) {
            BinaryReader clonedReader = reader.clone((long)DexUtil.adjustOffset(this.annotationsOffset, dexHeader));
            this._annotationSetItem = new AnnotationSetItem(clonedReader, dexHeader);
        }
    }

    public int getFieldIndex() {
        return this.fieldIndex;
    }

    public int getAnnotationsOffset() {
        return this.annotationsOffset;
    }

    public AnnotationSetItem getAnnotationSetItem() {
        return this._annotationSetItem;
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        DataType dataType = StructConverterUtil.toDataType(FieldAnnotationsItem.class);
        dataType.setCategoryPath(new CategoryPath("/dex"));
        return dataType;
    }
}

