/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.functiongraph.graph.layout.flowchart;

import ghidra.graph.viewer.VisualEdge;
import ghidra.graph.viewer.VisualVertex;
import ghidra.graph.viewer.layout.Column;
import ghidra.graph.viewer.layout.GridLocationMap;
import ghidra.graph.viewer.layout.GridPoint;
import ghidra.graph.viewer.layout.GridRange;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class OrthogonalEdgeRouter<V extends VisualVertex, E extends VisualEdge<V>> {
    private Function<E, GridRange> excludedColumnsFunction;
    private GridLocationMap<V, E> grid;
    private Map<Integer, Column<V>> columnMap;

    public OrthogonalEdgeRouter(GridLocationMap<V, E> grid) {
        this.grid = grid;
        this.columnMap = grid.columnsMap();
        this.excludedColumnsFunction = e -> new GridRange();
    }

    public void computeAndSetEdgeArticulations(Collection<E> edges) {
        for (VisualEdge e : edges) {
            VisualVertex v1 = (VisualVertex)e.getStart();
            VisualVertex v2 = (VisualVertex)e.getEnd();
            GridPoint p1 = this.grid.gridPoint((Object)v1);
            GridPoint p2 = this.grid.gridPoint((Object)v2);
            int routingCol = this.findRoutingColumn(e, p1, p2);
            List<GridPoint> edgePoints = this.getEdgePoints(p1, p2, routingCol);
            this.grid.setArticulations((Object)e, edgePoints);
        }
    }

    public void setColumnExclusionFunction(Function<E, GridRange> excludedColumnsFunction) {
        this.excludedColumnsFunction = excludedColumnsFunction;
    }

    private int findRoutingColumn(E e, GridPoint p1, GridPoint p2) {
        boolean isBackEdge;
        if (p2.row == p1.row + 2) {
            return p1.col;
        }
        int startRow = Math.min(p1.row + 1, p2.row - 1);
        int endRow = Math.max(p1.row + 1, p2.row - 1);
        int startCol = Math.min(p1.col, p2.col);
        int endCol = Math.max(p1.col, p2.col);
        boolean bl = isBackEdge = p2.row <= p1.row;
        if (!isBackEdge) {
            if (this.isOpenPath(p1.col, startRow, endRow)) {
                return p1.col;
            }
            if (this.isOpenPath(p2.col, startRow, endRow)) {
                return p2.col;
            }
            for (int col = startCol + 1; col <= endCol - 1; ++col) {
                if (!this.isOpenPath(col, startRow, endRow)) continue;
                return col;
            }
        }
        GridRange excludedRange = this.excludedColumnsFunction.apply(e);
        for (int i = 1; i <= startCol; ++i) {
            boolean rightValid;
            int left = startCol - i;
            int right = endCol + i;
            boolean leftExcluded = excludedRange.contains(left);
            boolean rightExcluded = excludedRange.contains(right);
            boolean leftValid = !leftExcluded && this.isOpenPath(left, startRow, endRow);
            boolean bl2 = rightValid = !rightExcluded && this.isOpenPath(right, startRow, endRow);
            if (leftValid) {
                if (!rightValid) {
                    return left;
                }
                return p1.row < p2.row ? left : right;
            }
            if (!rightValid) continue;
            return right;
        }
        return 0;
    }

    private boolean isOpenPath(int col, int startRow, int endRow) {
        Column<V> column = this.columnMap.get(col);
        if (column == null) {
            return true;
        }
        return column.isOpenBetween(startRow, endRow);
    }

    private List<GridPoint> getEdgePoints(GridPoint p1, GridPoint p2, int routingCol) {
        ArrayList<GridPoint> points = new ArrayList<GridPoint>();
        points.add(p1);
        if (routingCol == p1.col) {
            if (routingCol != p2.col) {
                points.add(new GridPoint(p2.row - 1, p1.col));
                points.add(new GridPoint(p2.row - 1, p2.col));
            }
        } else {
            points.add(new GridPoint(p1.row + 1, p1.col));
            points.add(new GridPoint(p1.row + 1, routingCol));
            if (routingCol != p2.col) {
                points.add(new GridPoint(p2.row - 1, routingCol));
                points.add(new GridPoint(p2.row - 1, p2.col));
            }
        }
        points.add(p2);
        return points;
    }
}

