/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.ascii;

import ghidra.program.model.data.AbstractStringDataType;
import ghidra.program.model.data.Unicode32DataType;
import ghidra.program.model.data.UnicodeDataType;
import ghidra.program.model.lang.Endian;
import ghidra.util.DataConverter;
import ghidra.util.ascii.ByteStreamCharMatcher;
import ghidra.util.ascii.CharSetRecognizer;
import ghidra.util.ascii.CharWidth;
import ghidra.util.ascii.MinLengthCharSequenceMatcher;
import ghidra.util.ascii.Sequence;

public class MultiByteCharMatcher
implements ByteStreamCharMatcher {
    private MinLengthCharSequenceMatcher charMatcher;
    private long index = -1L;
    private long offset;
    private byte[] bytes;
    private DataConverter converter;
    private int bytesPerChar;
    private final CharWidth charWidth;

    public MultiByteCharMatcher(int minLength, CharSetRecognizer charSet, CharWidth charWidth, Endian endian, int alignment, int offset) {
        if (offset < 0 || offset >= charWidth.size()) {
            throw new IllegalArgumentException("offset must be between 0 and bytesPerChar");
        }
        this.charWidth = charWidth;
        this.bytesPerChar = charWidth.size();
        this.offset = offset;
        int charAlignment = this.computeCharSequenceAlignemt(alignment, this.bytesPerChar);
        this.charMatcher = new MinLengthCharSequenceMatcher(minLength, charSet, charAlignment);
        this.converter = DataConverter.getInstance((boolean)endian.isBigEndian());
        this.bytes = new byte[charWidth.size()];
    }

    private int computeCharSequenceAlignemt(int alignment, int bytesInChar) {
        return Math.max(alignment / bytesInChar, 1);
    }

    @Override
    public boolean add(byte b) {
        if (this.charWidth == CharWidth.UTF8) {
            return this.charMatcher.addChar(b & 0xFF);
        }
        ++this.index;
        if (this.index < this.offset) {
            return false;
        }
        int mod = (int)(this.index - this.offset) % this.bytesPerChar;
        this.bytes[mod] = b;
        if (mod < this.bytesPerChar - 1) {
            return false;
        }
        int c = this.bytesPerChar == 2 ? this.converter.getShort(this.bytes) : this.converter.getInt(this.bytes);
        return this.charMatcher.addChar(c);
    }

    @Override
    public Sequence getSequence() {
        Sequence sequence = this.charMatcher.getSequence();
        if (sequence == null || this.charWidth == CharWidth.UTF8) {
            return sequence;
        }
        long start = sequence.getStart() * (long)this.bytesPerChar + this.offset;
        long end = sequence.getEnd() * (long)this.bytesPerChar + (long)this.bytesPerChar - 1L + this.offset;
        UnicodeDataType stringDatatype = this.charWidth == CharWidth.UTF16 ? UnicodeDataType.dataType : Unicode32DataType.dataType;
        return new Sequence(start, end, (AbstractStringDataType)stringDatatype, sequence.isNullTerminated());
    }

    @Override
    public boolean endSequence() {
        return this.charMatcher.endSequence();
    }

    @Override
    public void reset() {
        this.index = -1L;
        this.charMatcher.reset();
    }
}

