/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.base.replace.items;

import ghidra.app.services.DataTypeManagerService;
import ghidra.features.base.quickfix.QuickFixStatus;
import ghidra.features.base.replace.RenameQuickFix;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.Enum;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import java.util.Map;

public class RenameEnumValueQuickFix
extends RenameQuickFix {
    private Enum enumm;
    private long enumValue;

    public RenameEnumValueQuickFix(Program program, Enum enumDt, String valueName, String newName) {
        super(program, valueName, newName);
        this.enumm = enumDt;
        this.enumValue = enumDt.getValue(valueName);
        this.validate();
    }

    @Override
    public String getItemType() {
        return "Enum Value";
    }

    private void validate() {
        if (this.enumm.contains(this.replacement)) {
            this.setStatus(QuickFixStatus.WARNING, "New name not allowed because it duplicates an existing value name");
        }
    }

    @Override
    protected void statusChanged(QuickFixStatus newStatus) {
        if (newStatus == QuickFixStatus.NONE) {
            this.validate();
        }
    }

    @Override
    public Address getAddress() {
        return null;
    }

    @Override
    public String getPath() {
        return this.enumm.getPathName();
    }

    @Override
    public String doGetCurrent() {
        if (this.enumm.contains(this.original)) {
            return this.original;
        }
        if (this.enumm.contains(this.replacement)) {
            return this.replacement;
        }
        return null;
    }

    @Override
    public void execute() {
        try {
            this.enumm.add(this.replacement, this.enumValue);
            this.enumm.remove(this.original);
        }
        catch (Exception e) {
            this.setStatus(QuickFixStatus.ERROR, "Rename enum value failed: " + e.getMessage());
        }
    }

    @Override
    public ProgramLocation getProgramLocation() {
        return null;
    }

    @Override
    public Map<String, String> getCustomToolTipData() {
        return Map.of("Enum", this.enumm.getPathName());
    }

    @Override
    protected boolean navigateSpecial(ServiceProvider services, boolean fromSelectionChange) {
        DataTypeManagerService dtmService = (DataTypeManagerService)services.getService(DataTypeManagerService.class);
        if (dtmService == null) {
            return false;
        }
        dtmService.setDataTypeSelected((DataType)this.enumm);
        if (!fromSelectionChange) {
            dtmService.edit((DataType)this.enumm);
        }
        return true;
    }
}

