/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.viewer.field;

import ghidra.app.util.ListingHighlightProvider;
import ghidra.app.util.viewer.field.AbstractOffsetFieldFactory;
import ghidra.app.util.viewer.field.FieldFactory;
import ghidra.app.util.viewer.format.FieldFormatModel;
import ghidra.framework.options.Options;
import ghidra.framework.options.ToolOptions;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Function;
import ghidra.program.util.OffsetFieldType;

public class FunctionOffsetFieldFactory
extends AbstractOffsetFieldFactory {
    private static final String FIELD_OFFSET_DESCRIPTION = "Function";
    private static final String FIELD_NAME_DESCRIPTION = "Function";

    public FunctionOffsetFieldFactory() {
        super("Function");
    }

    private FunctionOffsetFieldFactory(FieldFormatModel model, ListingHighlightProvider hlProvider, Options displayOptions, Options fieldOptions) {
        super("Function", "Function", model, hlProvider, displayOptions, fieldOptions);
    }

    @Override
    public FieldFactory newInstance(FieldFormatModel formatModel, ListingHighlightProvider highlightProvider, ToolOptions options, ToolOptions fieldOptions) {
        return new FunctionOffsetFieldFactory(formatModel, highlightProvider, (Options)options, (Options)fieldOptions);
    }

    @Override
    public String getOffsetValue(CodeUnit cu) {
        Address addr = cu.getAddress();
        Function function = cu.getProgram().getListing().getFunctionContaining(addr);
        String text = "";
        if (function != null) {
            long offset = addr.subtract(function.getEntryPoint());
            text = String.format(this.useHex ? "0x%x" : "%d", offset);
            if (this.showName) {
                text = "%s:%s".formatted(function.getName(), text);
            }
        }
        return text;
    }

    @Override
    public OffsetFieldType getOffsetFieldType() {
        return OffsetFieldType.FUNCTION;
    }
}

