/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe.cli.tables;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.pe.cli.streams.CliStreamMetadata;
import ghidra.app.util.bin.format.pe.cli.tables.CliAbstractTable;
import ghidra.app.util.bin.format.pe.cli.tables.CliAbstractTableRow;
import ghidra.app.util.bin.format.pe.cli.tables.CliTypeTable;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.StructureDataType;
import java.io.IOException;

public class CliTableClassLayout
extends CliAbstractTable {
    public CliTableClassLayout(BinaryReader reader, CliStreamMetadata stream, CliTypeTable tableId) throws IOException {
        super(reader, stream, tableId);
        for (int i = 0; i < this.numRows; ++i) {
            this.rows.add(new CliClassLayoutRow(reader.readNextShort(), reader.readNextInt(), this.readTableIndex(reader, CliTypeTable.TypeDef)));
        }
    }

    public StructureDataType getRowDataType() {
        StructureDataType rowDt = new StructureDataType(new CategoryPath("/PE/CLI/Metadata/Tables"), "ClassLayout Row", 0);
        rowDt.add(WORD, "PackingSize", null);
        rowDt.add(DWORD, "ClassSize", null);
        rowDt.add(this.metadataStream.getTableIndexDataType(CliTypeTable.TypeDef), "Parent", null);
        return rowDt;
    }

    public class CliClassLayoutRow
    extends CliAbstractTableRow {
        public short packingSize;
        public int classSize;
        public int parentIndex;

        public CliClassLayoutRow(short packingSize, int classSize, int parentIndex) {
            this.packingSize = packingSize;
            this.classSize = classSize;
            this.parentIndex = parentIndex;
        }

        @Override
        public String getRepresentation() {
            return String.format("Packing %d ClassSize %d Parent %s", this.packingSize, this.classSize, CliTableClassLayout.this.getRowRepresentationSafe(CliTypeTable.TypeDef, this.parentIndex));
        }
    }
}

