/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.instructionsearch.ui;

import ghidra.app.plugin.core.instructionsearch.InstructionSearchPlugin;
import ghidra.app.plugin.core.instructionsearch.model.InstructionSearchData;
import ghidra.app.plugin.core.instructionsearch.ui.InstructionSearchDialog;
import ghidra.app.plugin.core.instructionsearch.ui.InstructionTable;
import ghidra.app.plugin.core.instructionsearch.ui.InstructionTablePanel;
import ghidra.app.plugin.core.instructionsearch.ui.PreviewTable;
import ghidra.app.plugin.core.instructionsearch.ui.PreviewTablePanel;
import ghidra.util.exception.InvalidInputException;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.BoundedRangeModel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;

public class InstructionSearchMainPanel
extends JPanel {
    private InstructionTablePanel instructionTablePanel;
    private PreviewTablePanel previewTablePanel;
    private static int splitterVal = -1;
    private InstructionSearchData searchData;

    public InstructionSearchMainPanel(InstructionSearchPlugin plugin, InstructionSearchDialog dialog) throws InvalidInputException {
        super(new BorderLayout());
        this.searchData = dialog.getSearchData();
        if (this.searchData == null) {
            throw new InvalidInputException("Search data object cannot be null");
        }
        int operands = this.searchData.getMaxNumOperands();
        this.instructionTablePanel = new InstructionTablePanel(operands, plugin, dialog);
        this.previewTablePanel = new PreviewTablePanel(1, plugin, dialog);
        this.linkScrollPanes(this.instructionTablePanel.getScrollPane(), this.previewTablePanel.getScrollPane());
        JSplitPane splitter = this.splitPanels(this.instructionTablePanel.getWorkPanel(), this.previewTablePanel);
        this.add((Component)splitter, "Center");
    }

    public PreviewTable getPreviewTable() {
        return this.previewTablePanel.getTable();
    }

    public PreviewTablePanel getPreviewTablePanel() {
        return this.previewTablePanel;
    }

    public InstructionTablePanel getInstructionTablePanel() {
        return this.instructionTablePanel;
    }

    public InstructionTable getInstructionTable() {
        return this.instructionTablePanel.getTable();
    }

    public void buildPreview() throws InvalidInputException {
        this.previewTablePanel.buildPreview();
    }

    private void linkScrollPanes(JScrollPane panel1, JScrollPane panel2) {
        BoundedRangeModel model = panel1.getVerticalScrollBar().getModel();
        panel2.getVerticalScrollBar().setModel(model);
    }

    private JSplitPane splitPanels(JPanel panel1, JPanel panel2) {
        JSplitPane splitter = new JSplitPane(1, panel1, panel2);
        splitter.setDividerLocation(splitterVal);
        splitter.addPropertyChangeListener("dividerLocation", pce -> {
            splitterVal = (Integer)pce.getNewValue();
        });
        return splitter;
    }
}

