/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.cmd.function;

import ghidra.framework.cmd.Command;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.LocalVariableImpl;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.Variable;
import ghidra.program.model.symbol.SourceType;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;

public class AddMemoryVarCmd
implements Command<Program> {
    private Address memAddr;
    private Address firstUseAddr;
    private String name;
    private DataType dt;
    private SourceType source;
    private String errMsg = "";

    public AddMemoryVarCmd(Address memAddr, Address firstUseAddr, String name, SourceType source) {
        this.memAddr = memAddr;
        this.firstUseAddr = firstUseAddr;
        this.name = name;
        this.source = source;
    }

    public AddMemoryVarCmd(Address memAddr, Address firstUseAddr, String name, DataType dt, SourceType source) {
        this.memAddr = memAddr;
        this.firstUseAddr = firstUseAddr;
        this.name = name;
        this.dt = dt;
        this.source = source;
    }

    public boolean applyTo(Program program) {
        Function f = program.getListing().getFunctionContaining(this.firstUseAddr);
        if (f == null) {
            this.errMsg = "Address not contained within function: " + String.valueOf(this.firstUseAddr);
            return false;
        }
        int firstUseOffset = (int)this.firstUseAddr.subtract(f.getEntryPoint());
        try {
            LocalVariableImpl var = new LocalVariableImpl(this.name, firstUseOffset, this.dt, this.memAddr, program);
            if (f.addLocalVariable((Variable)var, this.source) == null) {
                this.errMsg = "Create memory variable failed";
                return false;
            }
        }
        catch (DuplicateNameException e) {
            this.errMsg = "Variable named " + this.name + " already exists";
            return false;
        }
        catch (InvalidInputException e) {
            this.errMsg = "Variable named " + this.name + ": " + e.getMessage();
            return false;
        }
        return true;
    }

    public String getName() {
        return "Create Memory Variable";
    }

    public String getStatusMsg() {
        return this.errMsg;
    }
}

