/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.store;

import ghidra.framework.store.FileSystemListener;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

public class FileSystemEventManager
implements FileSystemListener {
    private List<FileSystemListener> listeners = new CopyOnWriteArrayList<FileSystemListener>();
    private BlockingQueue<FileSystemEvent> eventQueue = new LinkedBlockingQueue<FileSystemEvent>();
    private final boolean asyncDispatchEnabled;
    private volatile ThreadState state = ThreadState.STOPPED;
    private Thread thread;

    public FileSystemEventManager(boolean enableAsynchronousDispatching) {
        this.asyncDispatchEnabled = enableAsynchronousDispatching;
    }

    public boolean isAsynchronous() {
        return this.asyncDispatchEnabled;
    }

    public synchronized void dispose() {
        this.state = ThreadState.DISPOSED;
        if (this.asyncDispatchEnabled) {
            if (this.thread != null && this.thread.isAlive()) {
                this.thread.interrupt();
            }
            this.eventQueue.clear();
        }
    }

    private synchronized void startDispatchThread() {
        if (this.asyncDispatchEnabled && this.state == ThreadState.STOPPED) {
            this.state = ThreadState.RUNNING;
            this.thread = new FileSystemEventProcessingThread();
            this.thread.start();
        }
    }

    public void add(FileSystemListener listener) {
        this.startDispatchThread();
        this.listeners.add(listener);
    }

    public void remove(FileSystemListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void itemMoved(String parentPath, String name, String newParentPath, String newName) {
        this.handleEvent(new ItemMovedEvent(parentPath, name, newParentPath, newName));
    }

    @Override
    public void itemRenamed(String parentPath, String itemName, String newName) {
        this.handleEvent(new ItemRenamedEvent(parentPath, itemName, newName));
    }

    @Override
    public void itemDeleted(String parentPath, String itemName) {
        this.handleEvent(new ItemDeletedEvent(parentPath, itemName));
    }

    @Override
    public void folderRenamed(String parentPath, String folderName, String newFolderName) {
        this.handleEvent(new FolderRenamedEvent(parentPath, folderName, newFolderName));
    }

    @Override
    public void folderMoved(String parentPath, String folderName, String newParentPath) {
        this.handleEvent(new FolderMovedEvent(parentPath, folderName, newParentPath));
    }

    @Override
    public void folderDeleted(String parentPath, String folderName) {
        this.handleEvent(new FolderDeletedEvent(parentPath, folderName));
    }

    @Override
    public void itemCreated(String parentPath, String itemName) {
        this.handleEvent(new ItemCreatedEvent(parentPath, itemName));
    }

    @Override
    public void folderCreated(String parentPath, String folderName) {
        this.handleEvent(new FolderCreatedEvent(parentPath, folderName));
    }

    @Override
    public void itemChanged(String parentPath, String itemName) {
        this.handleEvent(new ItemChangedEvent(parentPath, itemName));
    }

    @Override
    public void syncronize() {
        if (this.asyncDispatchEnabled) {
            this.queueEvent(new SynchronizeEvent());
        }
    }

    private boolean queueEvent(FileSystemEvent ev) {
        if (this.state == ThreadState.RUNNING) {
            return this.eventQueue.add(ev);
        }
        return false;
    }

    private void handleEvent(FileSystemEvent e) {
        if (this.state == ThreadState.DISPOSED) {
            return;
        }
        if (this.asyncDispatchEnabled) {
            this.queueEvent(e);
        } else {
            e.process(this.listeners);
        }
    }

    public boolean flushEvents(long timeout, TimeUnit unit) {
        if (!this.asyncDispatchEnabled) {
            return true;
        }
        MarkerEvent event = new MarkerEvent();
        if (!this.queueEvent(event)) {
            return true;
        }
        try {
            return event.waitForEvent(timeout, unit);
        }
        catch (InterruptedException e) {
            return true;
        }
    }

    private static enum ThreadState {
        STOPPED,
        RUNNING,
        DISPOSED;

    }

    private class FileSystemEventProcessingThread
    extends Thread {
        FileSystemEventProcessingThread() {
            super("File System Listener");
            this.setDaemon(true);
        }

        @Override
        public void run() {
            while (FileSystemEventManager.this.state == ThreadState.RUNNING) {
                try {
                    FileSystemEvent event = FileSystemEventManager.this.eventQueue.take();
                    event.process(FileSystemEventManager.this.listeners);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    private static class ItemMovedEvent
    extends FileSystemEvent {
        ItemMovedEvent(String parentPath, String name, String newParentPath, String newName) {
            super(parentPath, name, newParentPath, newName);
        }

        @Override
        void dispatch(FileSystemListener listener) {
            listener.itemMoved(this.parentPath, this.name, this.newParentPath, this.newName);
        }
    }

    private static abstract class FileSystemEvent {
        String parentPath;
        String name;
        String newParentPath;
        String newName;

        FileSystemEvent(String parentPath, String name, String newParentPath, String newName) {
            this.parentPath = parentPath;
            this.name = name;
            this.newParentPath = newParentPath;
            this.newName = newName;
        }

        void process(List<FileSystemListener> listeners) {
            for (FileSystemListener l : listeners) {
                this.dispatch(l);
            }
        }

        abstract void dispatch(FileSystemListener var1);

        public String toString() {
            return this.getClass().getSimpleName();
        }
    }

    private static class ItemRenamedEvent
    extends FileSystemEvent {
        ItemRenamedEvent(String parentPath, String name, String newName) {
            super(parentPath, name, null, newName);
        }

        @Override
        void dispatch(FileSystemListener listener) {
            listener.itemRenamed(this.parentPath, this.name, this.newName);
        }
    }

    private static class ItemDeletedEvent
    extends FileSystemEvent {
        ItemDeletedEvent(String parentPath, String name) {
            super(parentPath, name, null, null);
        }

        @Override
        void dispatch(FileSystemListener listener) {
            listener.itemDeleted(this.parentPath, this.name);
        }
    }

    private static class FolderRenamedEvent
    extends FileSystemEvent {
        FolderRenamedEvent(String parentPath, String name, String newName) {
            super(parentPath, name, null, newName);
        }

        @Override
        void dispatch(FileSystemListener listener) {
            listener.folderRenamed(this.parentPath, this.name, this.newName);
        }
    }

    private static class FolderMovedEvent
    extends FileSystemEvent {
        FolderMovedEvent(String parentPath, String name, String newParentPath) {
            super(parentPath, name, newParentPath, null);
        }

        @Override
        void dispatch(FileSystemListener listener) {
            listener.folderMoved(this.parentPath, this.name, this.newParentPath);
        }
    }

    private static class FolderDeletedEvent
    extends FileSystemEvent {
        FolderDeletedEvent(String parentPath, String name) {
            super(parentPath, name, null, null);
        }

        @Override
        void dispatch(FileSystemListener listener) {
            listener.folderDeleted(this.parentPath, this.name);
        }
    }

    private static class ItemCreatedEvent
    extends FileSystemEvent {
        ItemCreatedEvent(String parentPath, String name) {
            super(parentPath, name, null, null);
        }

        @Override
        void dispatch(FileSystemListener listener) {
            listener.itemCreated(this.parentPath, this.name);
        }
    }

    private static class FolderCreatedEvent
    extends FileSystemEvent {
        FolderCreatedEvent(String parentPath, String name) {
            super(parentPath, name, null, null);
        }

        @Override
        void dispatch(FileSystemListener listener) {
            listener.folderCreated(this.parentPath, this.name);
        }
    }

    private static class ItemChangedEvent
    extends FileSystemEvent {
        ItemChangedEvent(String parentPath, String name) {
            super(parentPath, name, null, null);
        }

        @Override
        void dispatch(FileSystemListener listener) {
            listener.itemChanged(this.parentPath, this.name);
        }
    }

    private static class SynchronizeEvent
    extends FileSystemEvent {
        SynchronizeEvent() {
            super(null, null, null, null);
        }

        @Override
        void dispatch(FileSystemListener listener) {
            listener.syncronize();
        }
    }

    private static class MarkerEvent
    extends FileSystemEvent {
        private CountDownLatch latch = new CountDownLatch(1);

        MarkerEvent() {
            super(null, null, null, null);
        }

        @Override
        void dispatch(FileSystemListener listener) {
        }

        @Override
        void process(List<FileSystemListener> listeners) {
            this.latch.countDown();
        }

        boolean waitForEvent(long timeout, TimeUnit unit) throws InterruptedException {
            return this.latch.await(timeout, unit);
        }
    }
}

