/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.model.columns;

import docking.widgets.table.AbstractDynamicTableColumn;
import docking.widgets.table.GTableCellRenderingData;
import generic.Span;
import ghidra.app.plugin.core.debug.gui.model.PathTableModel;
import ghidra.docking.settings.Settings;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.Trace;
import ghidra.trace.model.target.TraceObjectValue;
import ghidra.trace.model.time.schedule.TraceSchedule;
import ghidra.util.table.column.AbstractGColumnRenderer;
import ghidra.util.table.column.GColumnRenderer;
import java.awt.Component;

public class TracePathLastLifespanColumn
extends AbstractDynamicTableColumn<PathTableModel.PathRow, SpanAndRadix, Trace> {
    private final LastLifespanRenderer renderer = new LastLifespanRenderer();

    public String getColumnName() {
        return "Life";
    }

    public GColumnRenderer<SpanAndRadix> getColumnRenderer() {
        return this.renderer;
    }

    public SpanAndRadix getValue(PathTableModel.PathRow rowObject, Settings settings, Trace data, ServiceProvider serviceProvider) throws IllegalArgumentException {
        TraceSchedule.TimeRadix radix;
        TraceObjectValue lastEntry = rowObject.getPath().getLastEntry();
        TraceSchedule.TimeRadix timeRadix = radix = data == null ? TraceSchedule.TimeRadix.DEFAULT : data.getTimeManager().getTimeRadix();
        if (lastEntry == null) {
            return new SpanAndRadix((Lifespan)Lifespan.ALL, radix);
        }
        return new SpanAndRadix(lastEntry.getLifespan(), radix);
    }

    private final class LastLifespanRenderer
    extends AbstractGColumnRenderer<SpanAndRadix> {
        private LastLifespanRenderer() {
        }

        public String getFilterString(SpanAndRadix t, Settings settings) {
            return t == null ? "<null>" : t.toString();
        }

        public Component getTableCellRendererComponent(GTableCellRenderingData data) {
            super.getTableCellRendererComponent(data);
            PathTableModel.PathRow row = (PathTableModel.PathRow)data.getRowObject();
            if (row.isCurrent()) {
                this.setBold();
            }
            return this;
        }
    }

    record SpanAndRadix(Lifespan span, TraceSchedule.TimeRadix radix) implements Comparable<SpanAndRadix>
    {
        @Override
        public final String toString() {
            return this.span.toString(arg_0 -> ((TraceSchedule.TimeRadix)this.radix).format(arg_0));
        }

        @Override
        public int compareTo(SpanAndRadix that) {
            return this.span.compareTo((Span)that.span);
        }
    }
}

