/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.control;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;
import org.jungrapht.visualization.MultiLayerTransformer;
import org.jungrapht.visualization.PropertyLoader;
import org.jungrapht.visualization.VisualizationModel;
import org.jungrapht.visualization.VisualizationServer;
import org.jungrapht.visualization.VisualizationViewer;
import org.jungrapht.visualization.control.AbstractGraphMousePlugin;
import org.jungrapht.visualization.control.DefaultGraphMouse;
import org.jungrapht.visualization.control.GraphElementAccessor;
import org.jungrapht.visualization.control.Modifiers;
import org.jungrapht.visualization.control.TransformSupport;
import org.jungrapht.visualization.layout.model.LayoutModel;
import org.jungrapht.visualization.layout.model.Point;
import org.jungrapht.visualization.selection.MutableSelectedState;
import org.jungrapht.visualization.selection.ShapePickSupport;
import org.jungrapht.visualization.selection.VertexEndpointsSelectedEdgeSelectedState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VertexSelectingGraphMousePlugin<V, E>
extends AbstractGraphMousePlugin
implements MouseListener,
MouseMotionListener {
    private static final Logger log = LoggerFactory.getLogger(VertexSelectingGraphMousePlugin.class);
    private static final int TOO_CLOSE_LIMIT = 5;
    private static final String PICK_AREA_SIZE = "jungrapht.pickAreaSize";
    protected int pickSize = Integer.getInteger("jungrapht.pickAreaSize", 4);
    protected V vertex;
    protected V deselectedVertex;
    protected boolean locked;
    protected Rectangle2D footprintRectangle = new Rectangle2D.Float();
    protected VisualizationServer.Paintable pickFootprintPaintable;
    protected Color lensColor = Color.cyan;
    protected Point2D deltaDown;
    protected int singleSelectionMask;
    protected int toggleSingleSelectionMask;
    protected boolean showFootprint;

    public static <V, E> Builder<V, E, ?, ?> builder() {
        return new Builder();
    }

    public VertexSelectingGraphMousePlugin(Builder<V, E, ?, ?> builder) {
        this(builder.singleSelectionMask, builder.toggleSingleSelectionMask, builder.showFootprint);
    }

    public VertexSelectingGraphMousePlugin() {
        this(VertexSelectingGraphMousePlugin.builder());
    }

    public VertexSelectingGraphMousePlugin(int singleSelectionMask, int toggleSingleSelectionMask, boolean showFootprint) {
        this.singleSelectionMask = singleSelectionMask;
        this.toggleSingleSelectionMask = toggleSingleSelectionMask;
        this.showFootprint = showFootprint;
        this.pickFootprintPaintable = new FootprintPaintable();
        this.cursor = Cursor.getPredefinedCursor(12);
    }

    public static <V, E> void configure(VisualizationViewer<V, E> visualizationViewer) {
        visualizationViewer.setSelectedEdgeState(new VertexEndpointsSelectedEdgeSelectedState(visualizationViewer.getVisualizationModel()::getGraph, visualizationViewer.getSelectedVertexState()));
        visualizationViewer.setGraphMouse(((DefaultGraphMouse.Builder)DefaultGraphMouse.builder().vertexSelectionOnly(true)).build());
    }

    public Color getLensColor() {
        return this.lensColor;
    }

    public void setLensColor(Color lensColor) {
        this.lensColor = lensColor;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.down = e.getPoint();
        log.trace("mouse pick at screen coords {}", (Object)e.getPoint());
        this.deltaDown = this.down;
        VisualizationViewer vv = (VisualizationViewer)e.getSource();
        TransformSupport transformSupport = vv.getTransformSupport();
        this.footprintRectangle = new Rectangle2D.Float((float)e.getPoint().x - (float)(this.pickSize / 2), (float)e.getPoint().y - (float)(this.pickSize / 2), this.pickSize, this.pickSize);
        if (this.showFootprint) {
            vv.addPostRenderPaintable(this.pickFootprintPaintable);
        }
        vv.repaint();
        Point2D layoutPoint = transformSupport.inverseTransform(vv, this.down);
        log.trace("layout coords of mouse click {}", (Object)layoutPoint);
        boolean vertexWasSelected = false;
        if (e.getModifiersEx() == this.singleSelectionMask) {
            vertexWasSelected = this.singleVertexSelection(e, layoutPoint, false);
        } else if (e.getModifiersEx() == this.toggleSingleSelectionMask) {
            vertexWasSelected = this.singleVertexSelection(e, layoutPoint, true);
        }
        if (vertexWasSelected) {
            e.consume();
        }
    }

    protected boolean singleVertexSelection(MouseEvent e, Point2D layoutPoint, boolean toggleSelection) {
        VisualizationServer vv = (VisualizationServer)e.getSource();
        GraphElementAccessor pickSupport = vv.getPickSupport();
        MutableSelectedState selectedVertexState = vv.getSelectedVertexState();
        LayoutModel layoutModel = vv.getVisualizationModel().getLayoutModel();
        if (pickSupport instanceof ShapePickSupport) {
            ShapePickSupport shapePickSupport = (ShapePickSupport)pickSupport;
            this.vertex = shapePickSupport.getVertex(layoutModel, this.footprintRectangle);
        } else {
            this.vertex = pickSupport.getVertex(layoutModel, layoutPoint.getX(), layoutPoint.getY());
        }
        if (this.vertex != null) {
            log.trace("mousePressed set the vertex to {}", this.vertex);
            if (selectedVertexState.isSelected(this.vertex)) {
                if (toggleSelection) {
                    selectedVertexState.deselect(this.vertex);
                    this.vertex = null;
                }
            } else {
                if (!toggleSelection) {
                    selectedVertexState.clear();
                }
                selectedVertexState.select(this.vertex);
            }
            e.consume();
            return true;
        }
        return false;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        java.awt.Point out = e.getPoint();
        VisualizationViewer vv = (VisualizationViewer)e.getSource();
        MultiLayerTransformer multiLayerTransformer = vv.getRenderContext().getMultiLayerTransformer();
        MutableSelectedState ps = vv.getSelectedVertexState();
        log.trace("down:{} out:{}", (Object)this.down, (Object)out);
        if (this.vertex != null && !this.down.equals(out)) {
            Point2D graphPoint = multiLayerTransformer.inverseTransform(out);
            log.trace("p in graph coords is {}", (Object)graphPoint);
            Point2D graphDown = multiLayerTransformer.inverseTransform(this.deltaDown);
            log.trace("graphDown (down in graph coords) is {}", (Object)graphDown);
            VisualizationModel visualizationModel = vv.getVisualizationModel();
            LayoutModel layoutModel = visualizationModel.getLayoutModel();
            double dx = graphPoint.getX() - graphDown.getX();
            double dy = graphPoint.getY() - graphDown.getY();
            log.trace("dx, dy: {},{}", (Object)dx, (Object)dy);
            for (Object v : vv.getSelectedVertices()) {
                Point vp = (Point)layoutModel.apply(v);
                vp = vp.add(dx, dy);
                layoutModel.set(v, vp);
            }
            this.deltaDown = out;
        }
        this.down = null;
        this.vertex = null;
        vv.removePostRenderPaintable(this.pickFootprintPaintable);
        vv.repaint();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        log.trace("mouseDragged");
        VisualizationViewer vv = (VisualizationViewer)e.getSource();
        if (!this.locked) {
            MutableSelectedState selectedVertexState = vv.getSelectedVertexState();
            MultiLayerTransformer multiLayerTransformer = vv.getRenderContext().getMultiLayerTransformer();
            java.awt.Point p = e.getPoint();
            log.trace("view p for drag event is {}", (Object)p);
            log.trace("down is {}", (Object)this.down);
            if (this.vertex != null) {
                selectedVertexState.select(this.vertex);
                Point2D graphPoint = multiLayerTransformer.inverseTransform(p);
                log.trace("p in graph coords is {}", (Object)graphPoint);
                Point2D graphDown = multiLayerTransformer.inverseTransform(this.deltaDown);
                log.trace("graphDown (down in graph coords) is {}", (Object)graphDown);
                VisualizationModel visualizationModel = vv.getVisualizationModel();
                LayoutModel layoutModel = visualizationModel.getLayoutModel();
                double dx = graphPoint.getX() - graphDown.getX();
                double dy = graphPoint.getY() - graphDown.getY();
                log.trace("dx, dy: {},{}", (Object)dx, (Object)dy);
                MutableSelectedState ps = vv.getSelectedVertexState();
                for (Object v : vv.getSelectedVertices()) {
                    Point vp = (Point)layoutModel.apply(v);
                    vp = vp.add(dx, dy);
                    layoutModel.set(v, vp);
                }
                this.deltaDown = p;
            }
            if (this.vertex != null) {
                e.consume();
            }
            vv.repaint();
        }
    }

    protected Point2D inverseTransform(VisualizationViewer<V, E> vv, Point2D p) {
        MultiLayerTransformer multiLayerTransformer = vv.getRenderContext().getMultiLayerTransformer();
        return multiLayerTransformer.inverseTransform(p);
    }

    protected Shape transform(VisualizationViewer<V, E> vv, Shape shape) {
        MultiLayerTransformer multiLayerTransformer = vv.getRenderContext().getMultiLayerTransformer();
        return multiLayerTransformer.transform(shape);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        JComponent c = (JComponent)e.getSource();
        c.setCursor(this.cursor);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        JComponent c = (JComponent)e.getSource();
        c.setCursor(Cursor.getPredefinedCursor(0));
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    static {
        PropertyLoader.load();
    }

    public static class Builder<V, E, T extends VertexSelectingGraphMousePlugin, B extends Builder<V, E, T, B>> {
        protected int singleSelectionMask = Modifiers.masks.get(System.getProperty("jungrapht.singleSelectionMask", "MB1_MENU"));
        protected int toggleSingleSelectionMask = Modifiers.masks.get(System.getProperty("jungrapht.toggleSingleSelectionMask", "MB1_SHIFT_MENU"));
        protected boolean showFootprint = Boolean.parseBoolean(System.getProperty("jungrapht.showFootprint", "false"));

        public B self() {
            return (B)this;
        }

        public B singleSelectionMask(int singleSelectionMask) {
            this.singleSelectionMask = singleSelectionMask;
            return this.self();
        }

        public B toggleSingleSelectionMask(int toggleSingleSelectionMask) {
            this.toggleSingleSelectionMask = toggleSingleSelectionMask;
            return this.self();
        }

        public B showFootprint(boolean showFootprint) {
            this.showFootprint = showFootprint;
            return this.self();
        }

        public T build() {
            return (T)new VertexSelectingGraphMousePlugin(this);
        }
    }

    class FootprintPaintable
    implements VisualizationServer.Paintable {
        FootprintPaintable() {
        }

        @Override
        public void paint(Graphics g) {
            Color oldColor = g.getColor();
            g.setColor(VertexSelectingGraphMousePlugin.this.lensColor);
            ((Graphics2D)g).draw(VertexSelectingGraphMousePlugin.this.footprintRectangle);
            g.setColor(oldColor);
        }

        @Override
        public boolean useTransform() {
            return false;
        }
    }
}

