/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization;

import java.awt.Font;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.swing.CellRendererPane;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jgrapht.Graph;
import org.jungrapht.visualization.MultiLayerTransformer;
import org.jungrapht.visualization.RenderContextStateChange;
import org.jungrapht.visualization.control.GraphElementAccessor;
import org.jungrapht.visualization.decorators.EdgeShape;
import org.jungrapht.visualization.layout.model.Rectangle;
import org.jungrapht.visualization.renderers.EdgeLabelRenderer;
import org.jungrapht.visualization.renderers.Renderer;
import org.jungrapht.visualization.renderers.VertexLabelRenderer;
import org.jungrapht.visualization.selection.MutableSelectedState;
import org.jungrapht.visualization.transform.shape.GraphicsDecorator;
import org.jungrapht.visualization.util.AWT;
import org.jungrapht.visualization.util.EdgeIndexFunction;

public interface RenderContext<V, E>
extends RenderContextStateChange.Producer {
    public static final float[] dotting = new float[]{1.0f, 3.0f};
    public static final float[] dashing = new float[]{5.0f};
    public static final int LABEL_OFFSET = 10;

    public int getLabelOffset();

    public void setLabelOffset(int var1);

    public float getArrowPlacementTolerance();

    public void setArrowPlacementTolerance(float var1);

    public Shape getEdgeArrow();

    public void setEdgeArrow(Shape var1);

    public boolean renderEdgeArrow();

    public void setRenderEdgeArrow(boolean var1);

    public void setupArrows(boolean var1);

    public void setArrowsOnUndirectedEdges(boolean var1);

    public boolean getArrowsOnUndirectedEdges();

    public Function<E, Font> getEdgeFontFunction();

    public void setEdgeFontFunction(Function<E, Font> var1);

    public Predicate<E> getEdgeIncludePredicate();

    public void setEdgeIncludePredicate(Predicate<E> var1);

    public float getEdgeLabelCloseness();

    public void setEdgeLabelCloseness(float var1);

    public EdgeLabelRenderer getEdgeLabelRenderer();

    public void setEdgeLabelRenderer(EdgeLabelRenderer var1);

    public Function<E, Paint> getEdgeFillPaintFunction();

    public void setEdgeFillPaintFunction(Function<E, Paint> var1);

    public Function<E, Paint> getSelectedEdgeFillPaintFunction();

    public void setSelectedEdgeFillPaintFunction(Function<E, Paint> var1);

    public Function<E, Paint> getEdgeDrawPaintFunction();

    public void setEdgeDrawPaintFunction(Function<E, Paint> var1);

    public Function<E, Paint> getSelectedEdgeDrawPaintFunction();

    public void setSelectedEdgeDrawPaintFunction(Function<E, Paint> var1);

    public Function<E, Paint> getArrowDrawPaintFunction();

    public void setArrowDrawPaintFunction(Function<E, Paint> var1);

    public Function<E, Paint> getArrowFillPaintFunction();

    public void setArrowFillPaintFunction(Function<E, Paint> var1);

    public BiFunction<Graph<V, E>, E, Shape> getEdgeShapeFunction();

    default public BiFunction<Graph<V, E>, E, Shape> getUnarticulatedEdgeShapeFunction() {
        BiFunction<Graph<V, E>, E, Shape> edgeShapeFunction = this.getEdgeShapeFunction();
        if (edgeShapeFunction instanceof EdgeShape.ArticulatedLine) {
            return EdgeShape.line();
        }
        return edgeShapeFunction;
    }

    public void setEdgeShapeFunction(BiFunction<Graph<V, E>, E, Shape> var1);

    public Function<E, String> getEdgeLabelFunction();

    public void setEdgeLabelFunction(Function<E, String> var1);

    public Function<E, Stroke> getEdgeStrokeFunction();

    @Deprecated
    default public Function<E, Stroke> edgeStrokeFunction() {
        return this.getEdgeStrokeFunction();
    }

    public void setEdgeStrokeFunction(Function<E, Stroke> var1);

    default public Function<E, Stroke> getSelectedEdgeStrokeFunction() {
        return this.getEdgeStrokeFunction();
    }

    default public void setSelectedEdgeStrokeFunction(Function<E, Stroke> selectedEdgeStrokeFunction) {
    }

    public void setEdgeWidth(float var1);

    public float getEdgeWidth();

    public void setSelectedEdgeWidth(float var1);

    public float getSelectedEdgeWidth();

    public void setEdgeArrowWidth(int var1);

    public int getEdgeArrowWidth();

    public void setEdgeArrowLength(int var1);

    public int getEdgeArrowLength();

    public Function<E, Stroke> getEdgeArrowStrokeFunction();

    public void setEdgeArrowStrokeFunction(Function<E, Stroke> var1);

    public GraphicsDecorator getGraphicsContext();

    public void setGraphicsContext(GraphicsDecorator var1);

    public EdgeIndexFunction<V, E> getParallelEdgeIndexFunction();

    public void setParallelEdgeIndexFunction(EdgeIndexFunction<V, E> var1);

    public MutableSelectedState<E> getSelectedEdgeState();

    public void setSelectedEdgeState(MutableSelectedState<E> var1);

    public MutableSelectedState<V> getSelectedVertexState();

    public void setSelectedVertexState(MutableSelectedState<V> var1);

    public CellRendererPane getRendererPane();

    public void setRendererPane(CellRendererPane var1);

    public JComponent getScreenDevice();

    public void setScreenDevice(JComponent var1);

    public Function<V, Font> getVertexFontFunction();

    public void setVertexFontFunction(Function<V, Font> var1);

    public Function<V, Icon> getVertexIconFunction();

    public void setVertexIconFunction(Function<V, Icon> var1);

    public Predicate<V> getVertexIncludePredicate();

    public void setVertexIncludePredicate(Predicate<V> var1);

    public VertexLabelRenderer getVertexLabelRenderer();

    public void setVertexLabelRenderer(VertexLabelRenderer var1);

    public Function<V, Paint> getVertexFillPaintFunction();

    public void setVertexFillPaintFunction(Function<V, Paint> var1);

    public Function<V, Paint> getSelectedVertexFillPaintFunction();

    public void setSelectedVertexFillPaintFunction(Function<V, Paint> var1);

    public Function<V, Paint> getVertexDrawPaintFunction();

    public void setVertexDrawPaintFunction(Function<V, Paint> var1);

    public Function<V, Paint> getSelectedVertexDrawPaintFunction();

    public void setSelectedVertexDrawPaintFunction(Function<V, Paint> var1);

    public Function<V, Shape> getVertexShapeFunction();

    default public Function<V, Rectangle> getVertexBoundsFunction() {
        return this.getVertexShapeFunction().andThen(s -> AWT.convert(s.getBounds2D()));
    }

    public void setVertexShapeFunction(Function<V, Shape> var1);

    public Function<V, String> getVertexLabelFunction();

    public void setVertexLabelFunction(Function<V, String> var1);

    public Function<V, Paint> getVertexLabelDrawPaintFunction();

    public void setVertexLabelDrawPaintFunction(Function<V, Paint> var1);

    public Function<V, Stroke> getVertexStrokeFunction();

    public void setVertexStrokeFunction(Function<V, Stroke> var1);

    public Function<V, Stroke> getSelectedVertexStrokeFunction();

    public void setSelectedVertexStrokeFunction(Function<V, Stroke> var1);

    public MultiLayerTransformer getMultiLayerTransformer();

    public void setMultiLayerTransformer(MultiLayerTransformer var1);

    @Deprecated
    default public GraphElementAccessor<V, E> getPickSupport() {
        return this.getSelectionSupport();
    }

    @Deprecated
    default public void setPickSupport(GraphElementAccessor<V, E> selectionSupport) {
        this.setSelectionSupport(selectionSupport);
    }

    public GraphElementAccessor<V, E> getSelectionSupport();

    public void setSelectionSupport(GraphElementAccessor<V, E> var1);

    public Renderer.VertexLabel.Position getVertexLabelPosition();

    public void setVertexLabelPosition(Renderer.VertexLabel.Position var1);

    public static class UndirectedEdgeArrowPredicate
    implements Predicate<Graph<?, ?>> {
        @Override
        public boolean test(Graph<?, ?> graph) {
            return !graph.getType().isDirected();
        }
    }

    public static class DirectedEdgeArrowPredicate
    implements Predicate<Graph<?, ?>> {
        @Override
        public boolean test(Graph<?, ?> graph) {
            return graph.getType().isDirected();
        }
    }
}

