/*
 * Decompiled with CFR 0.152.
 */
package db;

import db.Field;
import db.FieldKeyNode;
import db.FixedKeyInteriorNode;
import db.NodeMgr;
import db.Schema;
import db.buffers.DataBuffer;
import ghidra.util.exception.AssertException;
import java.io.IOException;

abstract class FixedKeyNode
implements FieldKeyNode {
    private static final int KEY_COUNT_SIZE = 4;
    private static final int KEY_COUNT_OFFSET = 1;
    static final int FIXEDKEY_NODE_HEADER_SIZE = 5;
    protected final Field keyType;
    protected final int keySize;
    protected NodeMgr nodeMgr;
    protected DataBuffer buffer;
    protected FixedKeyInteriorNode parent;
    protected int keyCount;

    FixedKeyNode(NodeMgr nodeMgr, DataBuffer buf) throws IOException {
        this.nodeMgr = nodeMgr;
        this.buffer = buf;
        Schema schema = nodeMgr.getTableSchema();
        if (!schema.useFixedKeyNodes()) {
            throw new AssertException("unsupported schema");
        }
        this.keyType = schema.getKeyFieldType();
        this.keySize = this.keyType.length();
        this.keyCount = this.buffer.getInt(1);
        nodeMgr.addNode(this);
    }

    FixedKeyNode(NodeMgr nodeMgr, byte nodeType) throws IOException {
        this.nodeMgr = nodeMgr;
        this.buffer = nodeMgr.getBufferMgr().createBuffer();
        NodeMgr.setNodeType(this.buffer, nodeType);
        Schema schema = nodeMgr.getTableSchema();
        if (!schema.useFixedKeyNodes()) {
            throw new AssertException("unsupported schema");
        }
        this.keyType = schema.getKeyFieldType();
        this.keySize = this.keyType.length();
        this.setKeyCount(0);
        nodeMgr.addNode(this);
    }

    @Override
    public FixedKeyInteriorNode getParent() {
        return this.parent;
    }

    @Override
    public int getBufferId() {
        return this.buffer.getId();
    }

    @Override
    public DataBuffer getBuffer() {
        return this.buffer;
    }

    FixedKeyNode getRoot() {
        if (this.parent != null) {
            return this.parent.getRoot();
        }
        return this;
    }

    @Override
    public int getKeyCount() {
        return this.keyCount;
    }

    @Override
    public void setKeyCount(int cnt) {
        this.keyCount = cnt;
        this.buffer.putInt(1, this.keyCount);
    }

    abstract byte[] getKey(int var1);

    @Override
    public final Field getKeyField(int index) {
        Field key = this.keyType.newField();
        key.setBinaryData(this.getKey(index));
        return key;
    }
}

