/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.data;

import db.DBHandle;
import db.DBRecord;
import db.Field;
import db.RecordIterator;
import db.Schema;
import ghidra.framework.data.OpenMode;
import ghidra.program.database.data.TypedefDBAdapterV0;
import ghidra.program.database.data.TypedefDBAdapterV1;
import ghidra.program.database.data.TypedefDBAdapterV2;
import ghidra.util.UniversalID;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

abstract class TypedefDBAdapter {
    static final String TYPEDEF_TABLE_NAME = "Typedefs";
    static final Schema SCHEMA = TypedefDBAdapterV2.V2_SCHEMA;
    static final int TYPEDEF_DT_ID_COL = 0;
    static final int TYPEDEF_FLAGS_COL = 1;
    static final int TYPEDEF_NAME_COL = 2;
    static final int TYPEDEF_CAT_COL = 3;
    static final int TYPEDEF_SOURCE_ARCHIVE_ID_COL = 4;
    static final int TYPEDEF_UNIVERSAL_DT_ID_COL = 5;
    static final int TYPEDEF_SOURCE_SYNC_TIME_COL = 6;
    static final int TYPEDEF_LAST_CHANGE_TIME_COL = 7;
    static final int TYPEDEF_FLAG_AUTONAME = 1;

    TypedefDBAdapter() {
    }

    static TypedefDBAdapter getAdapter(DBHandle handle, OpenMode openMode, String tablePrefix, TaskMonitor monitor) throws VersionException, IOException, CancelledException {
        try {
            return new TypedefDBAdapterV2(handle, tablePrefix, openMode == OpenMode.CREATE);
        }
        catch (VersionException e) {
            if (!e.isUpgradable() || openMode == OpenMode.UPDATE) {
                throw e;
            }
            TypedefDBAdapter adapter = TypedefDBAdapter.findReadOnlyAdapter(handle);
            if (openMode == OpenMode.UPGRADE) {
                adapter = TypedefDBAdapter.upgrade(handle, adapter, tablePrefix, monitor);
            }
            return adapter;
        }
    }

    private static TypedefDBAdapter findReadOnlyAdapter(DBHandle handle) throws VersionException {
        try {
            return new TypedefDBAdapterV1(handle);
        }
        catch (VersionException versionException) {
            return new TypedefDBAdapterV0(handle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static TypedefDBAdapter upgrade(DBHandle handle, TypedefDBAdapter oldAdapter, String tablePrefix, TaskMonitor monitor) throws VersionException, IOException, CancelledException {
        DBHandle tmpHandle = new DBHandle();
        long id = tmpHandle.startTransaction();
        TypedefDBAdapterV2 tmpAdapter = null;
        try {
            tmpAdapter = new TypedefDBAdapterV2(tmpHandle, tablePrefix, true);
            RecordIterator it = oldAdapter.getRecords();
            while (it.hasNext()) {
                monitor.checkCancelled();
                DBRecord rec = it.next();
                ((TypedefDBAdapter)tmpAdapter).updateRecord(rec, false);
            }
            oldAdapter.deleteTable(handle);
            TypedefDBAdapterV2 newAdapter = new TypedefDBAdapterV2(handle, tablePrefix, true);
            it = ((TypedefDBAdapter)tmpAdapter).getRecords();
            while (it.hasNext()) {
                monitor.checkCancelled();
                DBRecord rec = it.next();
                ((TypedefDBAdapter)newAdapter).updateRecord(rec, false);
            }
            TypedefDBAdapterV2 typedefDBAdapterV2 = newAdapter;
            return typedefDBAdapterV2;
        }
        finally {
            tmpHandle.endTransaction(id, true);
            tmpHandle.close();
        }
    }

    abstract DBRecord createRecord(long var1, String var3, short var4, long var5, long var7, long var9, long var11) throws IOException;

    abstract DBRecord getRecord(long var1) throws IOException;

    abstract RecordIterator getRecords() throws IOException;

    abstract boolean removeRecord(long var1) throws IOException;

    abstract void updateRecord(DBRecord var1, boolean var2) throws IOException;

    abstract void deleteTable(DBHandle var1) throws IOException;

    abstract Field[] getRecordIdsInCategory(long var1) throws IOException;

    abstract Field[] getRecordIdsForSourceArchive(long var1) throws IOException;

    abstract DBRecord getRecordWithIDs(UniversalID var1, UniversalID var2) throws IOException;

    public abstract int getRecordCount();
}

