/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcodeCPort.slghpatexpress;

import generic.stl.VectorSTL;
import ghidra.pcodeCPort.context.SleighError;
import ghidra.pcodeCPort.slghpatexpress.ExpressUtils;
import ghidra.pcodeCPort.slghpatexpress.PatternExpression;
import ghidra.pcodeCPort.slghpatexpress.PatternValue;
import ghidra.pcodeCPort.slghpatexpress.TokenPattern;
import ghidra.pcodeCPort.slghpatexpress.ValExpressEquation;
import ghidra.sleigh.grammar.Location;

public class LessEquation
extends ValExpressEquation {
    public LessEquation(Location location, PatternValue l, PatternExpression r) {
        super(location, l, r);
    }

    @Override
    public void genPattern(VectorSTL<TokenPattern> ops) {
        long lhsmin = this.lhs.minValue();
        long lhsmax = this.lhs.maxValue();
        VectorSTL semval = new VectorSTL();
        VectorSTL min = new VectorSTL();
        VectorSTL max = new VectorSTL();
        VectorSTL cur = new VectorSTL();
        int count = 0;
        this.rhs.listValues((VectorSTL<PatternValue>)semval);
        this.rhs.getMinMax((VectorSTL<Long>)min, (VectorSTL<Long>)max);
        cur = min;
        do {
            long val = this.rhs.getSubValue((VectorSTL<Long>)cur);
            for (long lhsval = lhsmin; lhsval <= lhsmax; ++lhsval) {
                if (lhsval >= val) continue;
                if (count == 0) {
                    this.setTokenPattern(ExpressUtils.buildPattern(this.lhs, lhsval, (VectorSTL<PatternValue>)semval, (VectorSTL<Long>)cur));
                } else {
                    this.setTokenPattern(this.getTokenPattern().doOr(ExpressUtils.buildPattern(this.lhs, lhsval, (VectorSTL<PatternValue>)semval, (VectorSTL<Long>)cur)));
                }
                ++count;
            }
        } while (ExpressUtils.advance_combo((VectorSTL<Long>)cur, (VectorSTL<Long>)min, (VectorSTL<Long>)max));
        if (count == 0) {
            throw new SleighError("LessEquation constraint is impossible to match", this.lhs.location);
        }
    }
}

