/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.assembler.sleigh.expr;

import ghidra.app.plugin.assembler.sleigh.expr.SolverException;
import ghidra.app.plugin.processors.sleigh.expression.TokenField;
import ghidra.util.NumericUtilities;

public class MaskedLong
implements Comparable<MaskedLong> {
    public static final MaskedLong ZERO = new MaskedLong(-1L, 0L);
    public static final MaskedLong UNKS = new MaskedLong(0L, 0L);
    public static final MaskedLong ONES = new MaskedLong(-1L, -1L);
    protected long msk;
    protected long val;

    protected MaskedLong(long msk, long val) {
        this.msk = msk;
        this.val = val & msk;
    }

    public static MaskedLong fromMaskAndValue(long msk, long val) {
        if (msk == 0L) {
            return UNKS;
        }
        if (msk == -1L && val == 0L) {
            return ZERO;
        }
        if (msk == -1L && val == -1L) {
            return ONES;
        }
        return new MaskedLong(msk, val);
    }

    public static MaskedLong fromLong(long val) {
        return MaskedLong.fromMaskAndValue(-1L, val);
    }

    public long longValue() {
        return this.val;
    }

    public long getMask() {
        return this.msk;
    }

    public boolean isFullyDefined() {
        return this.msk == -1L;
    }

    public boolean isFullyUndefined() {
        return this.msk == 0L;
    }

    public MaskedLong mask(long mask) {
        return MaskedLong.fromMaskAndValue(this.msk & mask, this.val);
    }

    public MaskedLong signExtend() {
        int bits = 64 - Long.numberOfLeadingZeros(this.msk);
        return this.signExtend(bits);
    }

    public MaskedLong zeroExtend() {
        int bits = 64 - Long.numberOfLeadingZeros(this.msk);
        return this.zeroExtend(bits);
    }

    public MaskedLong unknownExtend(int n) {
        long newMsk = MaskedLong.zeroExtend(this.msk, n);
        long newVal = MaskedLong.zeroExtend(this.val, n);
        return MaskedLong.fromMaskAndValue(newMsk, newVal);
    }

    public MaskedLong signExtend(int n) {
        long newMsk = MaskedLong.signExtend(this.msk, n);
        long newVal = MaskedLong.signExtend(this.val, n);
        return MaskedLong.fromMaskAndValue(newMsk, newVal);
    }

    public MaskedLong zeroExtend(int n) {
        long newMsk = MaskedLong.signExtend(this.msk, n);
        long newVal = MaskedLong.zeroExtend(this.val, n);
        return MaskedLong.fromMaskAndValue(newMsk, newVal);
    }

    public MaskedLong combine(MaskedLong that) throws SolverException {
        if (!this.agrees(that)) {
            throw new SolverException("Cannot combine masked longs that disagree");
        }
        return MaskedLong.fromMaskAndValue(this.msk | that.msk, this.val | that.val);
    }

    public MaskedLong shiftCircular(long n, int size, int dir) {
        if (dir == 1) {
            n = ((long)size - n) % (long)size;
        }
        if (n == 0L | size == 0) {
            return this;
        }
        long unaffected = size == 64 ? 0L : -1L << size;
        long umsk = unaffected & this.msk;
        long uval = unaffected & this.val;
        long affected = unaffected ^ 0xFFFFFFFFFFFFFFFFL;
        long amsk = affected & this.msk;
        long aval = affected & this.val;
        long newMsk = (amsk >>> (int)((long)size - n) | amsk << (int)n | umsk) & affected;
        long newVal = aval >>> (int)((long)size - n) | aval << (int)n | uval;
        return MaskedLong.fromMaskAndValue(newMsk, newVal);
    }

    public MaskedLong shiftCircular(MaskedLong n, int size, int dir) {
        if (!n.isFullyDefined()) {
            throw new UnsupportedOperationException("Cannot circular shift by an unknown amount");
        }
        return this.shiftCircular(n.longValue(), size, dir);
    }

    public MaskedLong shiftLeft(long n) {
        if (n == 0L) {
            return this;
        }
        long atright = -1L << (int)n ^ 0xFFFFFFFFFFFFFFFFL;
        return MaskedLong.fromMaskAndValue(this.msk << (int)n | atright, this.val << (int)n);
    }

    public MaskedLong shiftLeft(MaskedLong n) {
        if (!n.isFullyDefined()) {
            throw new UnsupportedOperationException("Cannot left shift by an unknown amount");
        }
        return this.shiftLeft(n.longValue());
    }

    public MaskedLong invShiftLeft(long n) throws SolverException {
        if (n == 0L) {
            return this;
        }
        long checkDef = (-1L << (int)n ^ 0xFFFFFFFFFFFFFFFFL) & this.val;
        if (checkDef != 0L) {
            throw new SolverException("Cannot invert left shift where ones appear on the right");
        }
        return this.shiftRightPositional(n);
    }

    public MaskedLong invShiftLeft(MaskedLong n) throws SolverException {
        if (!n.isFullyDefined()) {
            throw new UnsupportedOperationException("Cannot right shift by an unknown amount");
        }
        return this.invShiftLeft(n.longValue());
    }

    public MaskedLong shiftRight(long n) {
        if (n == 0L) {
            return this;
        }
        return MaskedLong.fromMaskAndValue(this.msk >> (int)n, this.val >> (int)n);
    }

    public MaskedLong shiftRight(MaskedLong n) {
        if (!n.isFullyDefined()) {
            throw new UnsupportedOperationException("Cannot right shift by an unknown amount");
        }
        return this.shiftRight(n.longValue());
    }

    public MaskedLong invShiftRight(long n) throws SolverException {
        if (n == 0L) {
            return this;
        }
        long checkVal = Long.MIN_VALUE >> (int)n & this.val;
        long checkMsk = Long.MIN_VALUE >> (int)n & this.msk;
        if (checkMsk == 0L) {
            return new MaskedLong(this.msk << (int)n, this.val << (int)n);
        }
        if (checkVal == 0L) {
            return new MaskedLong(this.msk << (int)n | Long.MIN_VALUE, this.val << (int)n);
        }
        if (checkVal == checkMsk) {
            return new MaskedLong(this.msk << (int)n | Long.MIN_VALUE, this.val << (int)n | Long.MIN_VALUE);
        }
        throw new SolverException("Cannot invert arithmetic right shift where bits to the left disagree");
    }

    public MaskedLong invShiftRight(MaskedLong n) throws SolverException {
        if (!n.isFullyDefined()) {
            throw new UnsupportedOperationException("Cannot left shift by an unknown amount");
        }
        return this.invShiftRight(n.longValue());
    }

    public MaskedLong shiftRightLogical(long n) {
        if (n == 0L) {
            return this;
        }
        long atleft = Long.MIN_VALUE >> (int)(n - 1L);
        return MaskedLong.fromMaskAndValue(this.msk >>> (int)n | atleft, this.val >>> (int)n);
    }

    public MaskedLong shiftRightLogical(MaskedLong n) {
        if (!n.isFullyDefined()) {
            throw new UnsupportedOperationException("Cannot right logical shift by an unknown amount");
        }
        return this.shiftRightLogical(n.longValue());
    }

    public MaskedLong shiftRightPositional(long n) {
        return MaskedLong.fromMaskAndValue(this.msk >>> (int)n, this.val >>> (int)n);
    }

    public MaskedLong invShiftRightLogical(long n) throws SolverException {
        if (n == 0L) {
            return this;
        }
        long checkDef = Long.MIN_VALUE >> (int)(n - 1L) & this.val;
        if (checkDef != 0L) {
            throw new SolverException("Cannot invert logical right shift where ones appear on the left");
        }
        return new MaskedLong(this.msk << (int)n, this.val << (int)n);
    }

    public MaskedLong invShiftRightLogical(MaskedLong n) throws SolverException {
        if (!n.isFullyDefined()) {
            throw new UnsupportedOperationException("Cannot left shift by an unknown amount");
        }
        return this.invShiftRightLogical(n.longValue());
    }

    public MaskedLong byteSwap(int n) {
        return MaskedLong.fromMaskAndValue(TokenField.byteSwap(this.msk, n), TokenField.byteSwap(this.val, n));
    }

    public MaskedLong and(MaskedLong that) {
        long newMsk = this.msk & that.msk;
        long newVal = this.val & that.val;
        newMsk |= this.msk & (this.val ^ 0xFFFFFFFFFFFFFFFFL);
        assert (newVal == ((newMsk |= that.msk & (that.val ^ 0xFFFFFFFFFFFFFFFFL)) & newVal));
        return MaskedLong.fromMaskAndValue(newMsk, newVal);
    }

    public MaskedLong invAnd(MaskedLong that) throws SolverException {
        long newMsk = this.msk & that.msk;
        long newVal = this.val;
        if ((newMsk & this.val & (that.val ^ 0xFFFFFFFFFFFFFFFFL)) != 0L) {
            throw new SolverException("0 & X == 1 cannot be solved.");
        }
        newMsk &= that.val;
        assert (newVal == ((newMsk |= this.val) & newVal));
        return MaskedLong.fromMaskAndValue(newMsk, newVal);
    }

    public MaskedLong or(MaskedLong that) {
        long newMsk = this.msk & that.msk;
        long newVal = this.val | that.val;
        newMsk |= this.val;
        assert (newVal == ((newMsk |= that.val) & newVal));
        return MaskedLong.fromMaskAndValue(newMsk, newVal);
    }

    public MaskedLong invOr(MaskedLong that) throws SolverException {
        long newMsk = this.msk & that.msk;
        long newVal = this.val;
        if ((newMsk & (this.val ^ 0xFFFFFFFFFFFFFFFFL) & that.val) != 0L) {
            throw new SolverException("1 | X == 0 cannot be solved.");
        }
        newMsk &= that.msk & that.val ^ 0xFFFFFFFFFFFFFFFFL;
        return MaskedLong.fromMaskAndValue(newMsk |= this.msk & (this.val ^ 0xFFFFFFFFFFFFFFFFL), newVal);
    }

    public MaskedLong xor(MaskedLong that) {
        long newMsk = this.msk & that.msk;
        long newVal = this.val ^ that.val;
        return MaskedLong.fromMaskAndValue(newMsk, newVal);
    }

    public MaskedLong negate() {
        if (!this.isFullyDefined()) {
            throw new UnsupportedOperationException("Cannot negate unknown values, yet.");
        }
        return MaskedLong.fromMaskAndValue(-1L, -this.val);
    }

    public MaskedLong not() {
        return MaskedLong.fromMaskAndValue(this.msk, this.val ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public MaskedLong add(MaskedLong that) {
        if (!this.isFullyDefined() || !that.isFullyDefined()) {
            return MaskedLong.doRippleCarry(this, that, false);
        }
        return MaskedLong.fromMaskAndValue(-1L, this.val + that.val);
    }

    public MaskedLong subtract(MaskedLong that) {
        if (!this.isFullyDefined() || !that.isFullyDefined()) {
            return MaskedLong.doRippleCarry(this, that, true);
        }
        return MaskedLong.fromMaskAndValue(-1L, this.val - that.val);
    }

    private static MaskedLong doRippleCarry(MaskedLong l, MaskedLong r, boolean subtract) {
        byte cmv = subtract ? (byte)3 : 2;
        long dmsk = 0L;
        long dval = 0L;
        for (long cur = 1L; cur != 0L; cur <<= 1) {
            byte lmv = 0;
            lmv = (byte)(lmv | ((l.msk & cur) != 0L ? 2 : 0));
            lmv = (byte)(lmv | ((l.val & cur) != 0L ? 1 : 0));
            byte rmv = 0;
            rmv = (byte)(rmv | ((r.msk & cur) != 0L ? 2 : 0));
            rmv = (byte)(rmv | ((r.val & cur) != 0L ^ subtract ? 1 : 0));
            byte nextcmv = MaskedLong.or(MaskedLong.and(cmv, lmv), MaskedLong.and(cmv, rmv), MaskedLong.and(lmv, rmv));
            byte dmv = MaskedLong.xor(cmv, lmv, rmv);
            cmv = nextcmv;
            if ((dmv & 2) == 0) continue;
            dmsk |= cur;
            if ((dmv & 1) == 0) continue;
            dval |= cur;
        }
        return MaskedLong.fromMaskAndValue(dmsk, dval);
    }

    private static byte and(byte rmv, byte lmv) {
        if (lmv == 2 || rmv == 2) {
            return 2;
        }
        if (lmv == 3 && rmv == 3) {
            return 3;
        }
        return 0;
    }

    private static byte or(byte rmv, byte lmv) {
        if (lmv == 3 || rmv == 3) {
            return 3;
        }
        if (lmv == 2 && rmv == 2) {
            return 2;
        }
        return 0;
    }

    private static byte or(byte t1, byte t2, byte t3) {
        return MaskedLong.or(MaskedLong.or(t1, t2), t3);
    }

    private static byte xor(byte rmv, byte lmv) {
        if ((lmv & 2) == 0 || (rmv & 2) == 0) {
            return 0;
        }
        return (byte)(lmv ^ rmv | 2);
    }

    private static byte xor(byte t1, byte t2, byte t3) {
        return MaskedLong.xor(MaskedLong.xor(t1, t2), t3);
    }

    public MaskedLong multiply(MaskedLong that) {
        if (this.isFullyDefined() && that.isFullyDefined()) {
            return MaskedLong.fromMaskAndValue(-1L, this.val * that.val);
        }
        if (that.isFullyDefined()) {
            if (Long.bitCount(that.val) == 1) {
                return this.shiftLeft(Long.numberOfTrailingZeros(that.val));
            }
        } else if (this.isFullyDefined() && Long.bitCount(this.val) == 1) {
            return that.shiftLeft(Long.numberOfTrailingZeros(this.val));
        }
        int thisSize = Long.numberOfTrailingZeros(this.msk ^ 0xFFFFFFFFFFFFFFFFL);
        int thatSize = Long.numberOfTrailingZeros(that.msk ^ 0xFFFFFFFFFFFFFFFFL);
        if (thisSize + Long.numberOfLeadingZeros(this.msk) == 64 && thatSize + Long.numberOfLeadingZeros(that.msk) == 64) {
            int newSize = thisSize + thatSize;
            return MaskedLong.fromMaskAndValue(-1L << newSize ^ 0xFFFFFFFFFFFFFFFFL, this.val * that.val);
        }
        throw new UnsupportedOperationException("Cannot multiply unknown values, yet.");
    }

    public MaskedLong divideSigned(MaskedLong that) {
        if (this.isFullyDefined() && that.isFullyDefined()) {
            long newVal = this.val / that.val;
            return MaskedLong.fromMaskAndValue(-1L, newVal);
        }
        if (that.isFullyDefined()) {
            if (Long.bitCount(that.val) == 1) {
                return this.shiftRight(Long.numberOfTrailingZeros(that.val));
            }
            if (Long.numberOfLeadingZeros(this.msk) + Long.numberOfTrailingZeros(this.msk ^ 0xFFFFFFFFFFFFFFFFL) == 64) {
                return MaskedLong.fromMaskAndValue(this.msk, this.val / that.val);
            }
        }
        throw new UnsupportedOperationException("Cannot divide unknown values, yet.");
    }

    public MaskedLong divideUnsigned(MaskedLong that) {
        if (this.isFullyDefined() && that.isFullyDefined()) {
            long newVal = Long.divideUnsigned(this.val, that.val);
            return MaskedLong.fromMaskAndValue(-1L, newVal);
        }
        if (that.isFullyDefined()) {
            if (Long.bitCount(that.val) == 1) {
                return this.shiftRightLogical(Long.numberOfTrailingZeros(that.val));
            }
            if (Long.numberOfLeadingZeros(this.msk) + Long.numberOfTrailingZeros(this.msk ^ 0xFFFFFFFFFFFFFFFFL) == 64) {
                return MaskedLong.fromMaskAndValue(this.msk, Long.divideUnsigned(this.val, that.val));
            }
        }
        throw new UnsupportedOperationException("Cannot divide unknown values, yet.");
    }

    public MaskedLong invMultiplyUnsigned(MaskedLong that) throws SolverException {
        if (that.isFullyDefined()) {
            if (Long.bitCount(that.val) == 1) {
                return this.invShiftLeft(Long.numberOfTrailingZeros(that.val));
            }
            if (Long.numberOfLeadingZeros(this.msk) + Long.numberOfTrailingZeros(this.msk ^ 0xFFFFFFFFFFFFFFFFL) == 64) {
                return MaskedLong.fromMaskAndValue(this.msk, Long.divideUnsigned(this.val, that.val));
            }
        }
        throw new UnsupportedOperationException("Cannot divide unknown values, yet.");
    }

    public boolean agrees(MaskedLong that) {
        long bothmsk = this.msk & that.msk;
        return (this.val & bothmsk) == (that.val & bothmsk);
    }

    public boolean agrees(long that) {
        return this.val == (that &= this.msk);
    }

    public boolean agrees(Object that) {
        if (that instanceof Long) {
            return this.agrees((Long)that);
        }
        if (that instanceof MaskedLong) {
            return this.agrees((MaskedLong)that);
        }
        throw new IllegalArgumentException("must be Long or MaskedLong: " + String.valueOf(that));
    }

    public boolean isInRange(long max, boolean signed) {
        if (-1L == max) {
            return true;
        }
        long min = 0L;
        if (signed) {
            min = (max >>>= 1) ^ 0xFFFFFFFFFFFFFFFFL;
            long ckVal = this.signExtend().longValue();
            return min <= ckVal && ckVal <= max;
        }
        long ckVal = this.zeroExtend().longValue();
        if (max < 0L) {
            return ckVal >= 0L || ckVal <= max;
        }
        return ckVal >= 0L && ckVal <= max;
    }

    @Override
    public int compareTo(MaskedLong that) {
        long result = this.msk - that.msk;
        if (result < 0L) {
            return -1;
        }
        if (result > 0L) {
            return 1;
        }
        result = this.val - that.val;
        if (result < 0L) {
            return -1;
        }
        if (result > 0L) {
            return 1;
        }
        return 0;
    }

    public boolean equals(Object other) {
        if (!(other instanceof MaskedLong)) {
            return false;
        }
        MaskedLong that = (MaskedLong)other;
        return this.msk == that.msk && this.val == that.val;
    }

    public int hashCode() {
        int result = Long.hashCode(this.msk);
        result *= 31;
        return result += Long.hashCode(this.val);
    }

    public String toString() {
        return NumericUtilities.convertMaskedValueToHexString((long)this.msk, (long)this.val, (int)16, (boolean)true, (int)2, (String)":");
    }

    protected static long signExtend(long val, int bits) {
        int slam = 64 - bits;
        return val << slam >> slam;
    }

    protected static long zeroExtend(long val, int bits) {
        int slam = 64 - bits;
        return val << slam >>> slam;
    }

    public MaskedLong fillMask() {
        return new MaskedLong(-1L, this.val);
    }
}

