/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.demangler.swift.datatypes;

import ghidra.app.util.demangler.Demangled;
import ghidra.app.util.demangler.DemangledDataType;
import ghidra.app.util.demangler.DemangledException;
import ghidra.app.util.demangler.DemangledList;
import ghidra.app.util.demangler.DemangledVariable;
import ghidra.app.util.demangler.swift.SwiftDemangler;
import ghidra.app.util.demangler.swift.datatypes.SwiftStructure;

public class SwiftTuple
extends SwiftStructure {
    public SwiftTuple(String mangled, String originalDemangled, DemangledList list, SwiftDemangler demangler) throws DemangledException {
        super(mangled, originalDemangled, "tuple%d".formatted(list.size()), null, demangler);
        int i = 0;
        for (Demangled element : list) {
            if (element instanceof DemangledDataType) {
                DemangledDataType ddt = (DemangledDataType)element;
                this.addField(Integer.toString(i), ddt);
            } else if (element instanceof DemangledVariable) {
                DemangledVariable variable = (DemangledVariable)element;
                this.addField(variable.getName(), variable.getDataType());
            }
            ++i;
        }
    }
}

