/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph.viewer.renderer;

import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.visualization.Layer;
import edu.uci.ics.jung.visualization.MultiLayerTransformer;
import edu.uci.ics.jung.visualization.RenderContext;
import edu.uci.ics.jung.visualization.transform.shape.GraphicsDecorator;
import generic.theme.GColor;
import generic.theme.GThemeDefaults;
import ghidra.graph.viewer.layout.GridCoordinates;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.geom.Point2D;

public class GridPainter {
    private GridCoordinates grid;

    public GridPainter(GridCoordinates gridCoordinates) {
        this.grid = gridCoordinates;
    }

    public void paintLayoutGridCells(RenderContext<?, ?> renderContext, Layout<?, ?> layout) {
        Point2D end;
        Point2D start;
        if (this.grid == null) {
            return;
        }
        int rowCount = this.grid.rowCount();
        int colCount = this.grid.columnCount();
        GraphicsDecorator g = renderContext.getGraphicsContext();
        Color originalColor = g.getColor();
        GColor gridColor = GThemeDefaults.Colors.Palette.ORANGE;
        GColor textColor = GThemeDefaults.Colors.Palette.BLACK;
        Rectangle bounds = this.grid.getBounds();
        int width = bounds.width;
        int height = bounds.height;
        MultiLayerTransformer transformer = renderContext.getMultiLayerTransformer();
        int previous = -1;
        for (int row = 0; row < rowCount; ++row) {
            int y = this.grid.y(row);
            if (y == previous) continue;
            previous = y;
            start = new Point2D.Double(0.0, y);
            end = new Point2D.Double(width, y);
            start = transformer.transform(Layer.LAYOUT, start);
            end = transformer.transform(Layer.LAYOUT, end);
            g.setColor((Color)textColor);
            g.drawString(Integer.toString(row), (float)start.getX() - 20.0f, (float)(start.getY() + 5.0));
            g.setColor((Color)gridColor);
            g.drawLine((int)start.getX(), (int)start.getY(), (int)end.getX(), (int)end.getY());
        }
        previous = -1;
        for (int col = 0; col < colCount; ++col) {
            int x = this.grid.x(col);
            if (x == previous) continue;
            previous = x;
            start = new Point2D.Double(x, 0.0);
            end = new Point2D.Double(x, height);
            start = transformer.transform(Layer.LAYOUT, start);
            end = transformer.transform(Layer.LAYOUT, end);
            g.setColor((Color)textColor);
            g.drawString(Integer.toString(col), (float)start.getX() - 5.0f, (float)(start.getY() - 10.0));
            g.setColor((Color)gridColor);
            g.drawLine((int)start.getX(), (int)start.getY(), (int)end.getX(), (int)end.getY());
        }
        g.setColor(originalColor);
    }
}

