/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.go;

import ghidra.app.plugin.core.go.ipc.GhidraGoListener;
import ghidra.framework.main.AppInfo;
import ghidra.framework.main.ApplicationLevelOnlyPlugin;
import ghidra.framework.main.FrontEndTool;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginEvent;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.ProjectPluginEvent;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.framework.protocol.ghidra.GhidraURL;
import ghidra.util.Msg;
import java.io.IOException;
import java.net.URL;

@PluginInfo(category="Common", status=PluginStatus.UNSTABLE, packageName="Ghidra Core", shortDescription="Listens for new GhidraURL's to launch using FrontEndTool's accept method", description="Polls the ghidraGo directory for any url files written by the GhidraGoSender and processes them in Ghidra", eventsConsumed={ProjectPluginEvent.class})
public class GhidraGoPlugin
extends Plugin
implements ApplicationLevelOnlyPlugin {
    private GhidraGoListener listener;

    public GhidraGoPlugin(PluginTool tool) {
        super(tool);
    }

    protected void init() {
        super.init();
    }

    protected void dispose() {
        if (this.listener != null) {
            this.listener.dispose();
            this.listener = null;
        }
        super.dispose();
    }

    public void processEvent(PluginEvent event) {
        if (event instanceof ProjectPluginEvent) {
            if (((ProjectPluginEvent)event).getProject() == null) {
                this.dispose();
            } else {
                try {
                    this.listener = new GhidraGoListener(url -> this.accept((URL)url));
                }
                catch (IOException e) {
                    Msg.showError((Object)((Object)this), null, (String)"GhidraGoPlugin Exception", (Object)"Unable to create Listener", (Throwable)e);
                }
            }
        }
    }

    public boolean accept(URL url) {
        Msg.info((Object)((Object)this), (Object)("GhidraGo accepting the resource at " + String.valueOf(GhidraURL.getProjectURL((URL)url))));
        FrontEndTool frontEndTool = AppInfo.getFrontEndTool();
        frontEndTool.toFront();
        return frontEndTool.accept(url);
    }
}

