/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.layout.quadtree;

import java.util.Objects;
import org.jungrapht.visualization.layout.model.Point;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ForceObject<T> {
    private static final Logger log = LoggerFactory.getLogger(ForceObject.class);
    public final Point p;
    public Point f;
    protected double mass;
    private final T element;

    public ForceObject(T element, Point p, double mass) {
        this.element = element;
        this.p = p;
        this.f = Point.ORIGIN;
        this.mass = mass;
    }

    public ForceObject(T element, Point p) {
        this(element, p, 1.0);
    }

    public ForceObject(T element, double x, double y) {
        this(element, Point.of(x, y), 1.0);
    }

    public ForceObject(T element, double x, double y, double mass) {
        this.element = element;
        this.p = Point.of(x, y);
        this.mass = mass;
    }

    public double getMass() {
        return this.mass;
    }

    protected void addForceFrom(ForceObject<T> other) {
    }

    public ForceObject add(ForceObject<T> other) {
        double totalMass = this.mass + other.mass;
        Point p = Point.of((this.p.x * this.mass + other.p.x * other.mass) / totalMass, (this.p.y * this.mass + other.p.y * other.mass) / totalMass);
        return new ForceObject<String>("force", p, totalMass);
    }

    public T getElement() {
        return this.element;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ForceObject that = (ForceObject)o;
        if (Double.compare(that.mass, this.mass) != 0) {
            return false;
        }
        if (!Objects.equals(this.p, that.p)) {
            return false;
        }
        return Objects.equals(this.element, that.element);
    }

    public int hashCode() {
        int result = this.p != null ? this.p.hashCode() : 0;
        long temp = Double.doubleToLongBits(this.mass);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.element != null ? this.element.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "ForceObject{element=" + this.element + ", p=" + this.p + ", mass=" + this.mass + ", force=" + this.f + "}";
    }
}

