/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.layout.model;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.jgrapht.Graph;
import org.jungrapht.visualization.layout.algorithms.LayoutAlgorithm;
import org.jungrapht.visualization.layout.algorithms.util.Pair;
import org.jungrapht.visualization.layout.event.LayoutSizeChange;
import org.jungrapht.visualization.layout.event.LayoutStateChange;
import org.jungrapht.visualization.layout.event.LayoutVertexPositionChange;
import org.jungrapht.visualization.layout.event.ModelChange;
import org.jungrapht.visualization.layout.event.ViewChange;
import org.jungrapht.visualization.layout.model.LayoutModel;
import org.jungrapht.visualization.layout.model.Point;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AggregateLayoutModel<V>
implements LayoutModel<V> {
    private static final Logger log = LoggerFactory.getLogger(AggregateLayoutModel.class);
    protected final LayoutModel<V> delegate;
    protected Map<LayoutModel<V>, Point> layouts = new HashMap<LayoutModel<V>, Point>();

    public AggregateLayoutModel(LayoutModel<V> delegate) {
        this.delegate = delegate;
    }

    public void put(LayoutModel<V> layoutModel, Point center) {
        if (log.isTraceEnabled()) {
            log.trace("put layout: {} at {}", layoutModel, (Object)center);
        }
        this.layouts.put(layoutModel, center);
        this.connectListeners(layoutModel);
    }

    private void connectListeners(LayoutModel<V> newLayoutModel) {
        for (LayoutStateChange.Listener layoutStateChangeListener : this.delegate.getLayoutStateChangeSupport().getLayoutStateChangeListeners()) {
            newLayoutModel.getLayoutStateChangeSupport().addLayoutStateChangeListener(layoutStateChangeListener);
        }
        for (ModelChange.Listener changeListener : this.delegate.getModelChangeSupport().getModelChangeListeners()) {
            newLayoutModel.getModelChangeSupport().addModelChangeListener(changeListener);
        }
    }

    private void disconnectListeners(LayoutModel<V> newLayoutModel) {
        newLayoutModel.getLayoutStateChangeSupport().getLayoutStateChangeListeners().clear();
        newLayoutModel.getModelChangeSupport().getModelChangeListeners().clear();
    }

    @Override
    public Point get(LayoutModel<V> layout) {
        return this.layouts.get(layout);
    }

    @Override
    public void accept(LayoutAlgorithm<V> layoutAlgorithm) {
        this.delegate.accept(layoutAlgorithm);
    }

    @Override
    public Map<V, Point> getLocations() {
        return this.delegate.getLocations();
    }

    @Override
    public void setInitialDimensionFunction(Function<Graph<V, ?>, Pair<Integer>> initialDimensionFunction) {
        this.delegate.setInitialDimensionFunction(initialDimensionFunction);
    }

    @Override
    public void setSize(int width, int height) {
        this.delegate.setSize(width, height);
    }

    @Override
    public void setPreferredSize(int width, int height) {
        this.delegate.setPreferredSize(width, height);
    }

    @Override
    public void stop() {
        this.delegate.stop();
        for (LayoutModel<V> childLayoutModel : this.layouts.keySet()) {
            childLayoutModel.stop();
        }
    }

    @Override
    public void setRelaxing(boolean relaxing) {
        this.delegate.setRelaxing(relaxing);
    }

    @Override
    public boolean isRelaxing() {
        return this.delegate.isRelaxing();
    }

    @Override
    public void set(V vertex, Point location) {
        this.delegate.set(vertex, location);
    }

    @Override
    public void set(V vertex, double x, double y) {
        this.delegate.set(vertex, Point.of(x, y));
    }

    @Override
    public Point get(V vertex) {
        return this.delegate.get(vertex);
    }

    @Override
    public <E> Graph<V, E> getGraph() {
        return this.delegate.getGraph();
    }

    @Override
    public void setGraph(Graph<V, ?> graph) {
        this.delegate.setGraph(graph);
    }

    public void remove(LayoutModel<V> layout) {
        this.layouts.remove(layout);
    }

    public void removeAll() {
        this.layouts.clear();
    }

    @Override
    public int getWidth() {
        return this.delegate.getWidth();
    }

    @Override
    public int getHeight() {
        return this.delegate.getHeight();
    }

    @Override
    public int getPreferredWidth() {
        return this.delegate.getPreferredWidth();
    }

    @Override
    public int getPreferredHeight() {
        return this.delegate.getPreferredHeight();
    }

    @Override
    public boolean isLocked(V vertex) {
        for (LayoutModel<V> layoutModel : this.layouts.keySet()) {
            if (!layoutModel.isLocked(vertex)) continue;
            return true;
        }
        return this.delegate.isLocked(vertex);
    }

    @Override
    public void lock(V vertex, boolean state) {
        for (LayoutModel<V> layoutModel : this.layouts.keySet()) {
            if (!layoutModel.getGraph().containsVertex(vertex)) continue;
            layoutModel.lock(vertex, state);
        }
        this.delegate.lock(vertex, state);
    }

    @Override
    public void lock(boolean locked) {
        this.delegate.lock(locked);
        for (LayoutModel<V> model : this.layouts.keySet()) {
            model.lock(locked);
        }
    }

    @Override
    public boolean isLocked() {
        return this.delegate.isLocked();
    }

    @Override
    public void setInitializer(Function<V, Point> initializer) {
        this.delegate.setInitializer(initializer);
    }

    @Override
    public void resizeToSurroundingRectangle() {
        this.delegate.resizeToSurroundingRectangle();
    }

    @Override
    public LayoutStateChange.Support getLayoutStateChangeSupport() {
        return this.delegate.getLayoutStateChangeSupport();
    }

    @Override
    public LayoutSizeChange.Support<V> getLayoutSizeChangeSupport() {
        return this.delegate.getLayoutSizeChangeSupport();
    }

    @Override
    public Point apply(V vertex) {
        for (LayoutModel<V> layoutModel : this.layouts.keySet()) {
            if (!layoutModel.getGraph().containsVertex(vertex)) continue;
            Point center = this.layouts.get(layoutModel);
            int width = layoutModel.getWidth();
            int height = layoutModel.getHeight();
            double deltaX = center.x - (double)(width / 2);
            double deltaY = center.y - (double)(height / 2);
            Point vertexCenter = (Point)layoutModel.apply(vertex);
            log.trace("sublayout center is {}", (Object)vertexCenter);
            double[] srcPoints = new double[]{vertexCenter.x, vertexCenter.y};
            double[] destPoints = new double[2];
            Point translatedCenter = vertexCenter.add(deltaX, deltaY);
            return translatedCenter;
        }
        return (Point)this.delegate.apply(vertex);
    }

    @Override
    public ModelChange.Support getModelChangeSupport() {
        return this.delegate.getModelChangeSupport();
    }

    @Override
    public ViewChange.Support getViewChangeSupport() {
        return this.delegate.getViewChangeSupport();
    }

    @Override
    public LayoutVertexPositionChange.Support<V> getLayoutVertexPositionSupport() {
        return this.delegate.getLayoutVertexPositionSupport();
    }

    @Override
    public void layoutVertexPositionChanged(LayoutVertexPositionChange.Event<V> evt) {
    }

    @Override
    public void layoutVertexPositionChanged(LayoutVertexPositionChange.GraphEvent<V> evt) {
    }

    @Override
    public void appendLayoutModel(LayoutModel<V> layoutModel) {
        this.delegate.appendLayoutModel(layoutModel);
    }
}

