/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.layout.algorithms;

import java.util.Comparator;
import java.util.Map;
import java.util.function.Predicate;
import org.jgrapht.Graph;
import org.jungrapht.visualization.layout.algorithms.LayoutAlgorithm;
import org.jungrapht.visualization.layout.algorithms.util.VertexBoundsFunctionConsumer;
import org.jungrapht.visualization.layout.model.Rectangle;

public interface TreeLayout<V>
extends LayoutAlgorithm<V>,
VertexBoundsFunctionConsumer<V> {
    public static final int TREE_LAYOUT_HORIZONTAL_SPACING = Integer.getInteger("jungrapht.treeLayoutHorizontalSpacing", 50);
    public static final int TREE_LAYOUT_VERTICAL_SPACING = Integer.getInteger("jungrapht.treeLayoutVerticalSpacing", 50);

    public Map<V, Rectangle> getBaseBounds();

    public void setRootPredicate(Predicate<V> var1);

    public void setRootComparator(Comparator<V> var1);

    public static <V, E> boolean isLoopVertex(Graph<V, E> graph, V v) {
        return graph.outgoingEdgesOf(v).equals(graph.incomingEdgesOf(v));
    }

    public static <V, E> boolean isZeroDegreeVertex(Graph<V, E> graph, V v) {
        return graph.degreeOf(v) == 0;
    }

    public static <V, E> boolean isIsolatedVertex(Graph<V, E> graph, V v) {
        return TreeLayout.isLoopVertex(graph, v) || TreeLayout.isZeroDegreeVertex(graph, v);
    }

    public static <V, E> int vertexIsolationScore(Graph<V, E> graph, V v) {
        if (TreeLayout.isZeroDegreeVertex(graph, v)) {
            return 2;
        }
        if (TreeLayout.isLoopVertex(graph, v)) {
            return 1;
        }
        return 0;
    }
}

