/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.bsim.query.protocol;

import ghidra.features.bsim.gui.filters.BSimFilterType;
import ghidra.features.bsim.gui.filters.FunctionTagBSimFilterType;
import ghidra.features.bsim.query.description.ExecutableRecord;
import ghidra.features.bsim.query.description.FunctionDescription;
import ghidra.features.bsim.query.protocol.ChildAtom;
import ghidra.features.bsim.query.protocol.FilterAtom;
import ghidra.util.xml.SpecXmlUtils;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlPullParser;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class BSimFilter {
    private List<FilterAtom> atoms = new ArrayList<FilterAtom>();
    private int filterflags_mask = 0;
    private int filterflags_value = 0;
    private Map<String, List<FilterAtom>> filterNameToFilterMapAND = null;
    private Map<String, List<FilterAtom>> filterNameToFilterMapOR = null;

    public int numAtoms() {
        return this.atoms.size();
    }

    public FilterAtom getAtom(int i) {
        return this.atoms.get(i);
    }

    public void addAtom(BSimFilterType type, String val) {
        if (type.isChildFilter()) {
            int i;
            String exe = "unknown";
            if (val.charAt(0) == '[' && (i = val.indexOf(93)) >= 0) {
                exe = val.substring(1, i);
                val = val.substring(i + 1);
            }
            ChildAtom childatom = new ChildAtom();
            childatom.type = type;
            childatom.value = null;
            childatom.name = val;
            childatom.exename = exe;
            this.atoms.add(childatom);
        } else {
            FilterAtom newatom = new FilterAtom(type, val);
            if (newatom.isValid()) {
                this.atoms.add(newatom);
                if (type instanceof FunctionTagBSimFilterType) {
                    int flag = ((FunctionTagBSimFilterType)type).getFlag();
                    this.filterflags_mask |= flag;
                    if (newatom.value.equals("true")) {
                        this.filterflags_value |= flag;
                    }
                }
            }
        }
    }

    public BSimFilter clone() {
        BSimFilter op2 = new BSimFilter();
        for (int i = 0; i < this.atoms.size(); ++i) {
            op2.atoms.add(this.atoms.get(i).clone());
        }
        op2.filterflags_mask = this.filterflags_mask;
        op2.filterflags_value = this.filterflags_value;
        return op2;
    }

    public void clear() {
        this.atoms.clear();
        this.filterflags_mask = 0;
        this.filterflags_value = 0;
    }

    public boolean isEmpty() {
        if (this.filterflags_mask != 0) {
            return false;
        }
        for (int i = 0; i < this.atoms.size(); ++i) {
            if (this.atoms.get((int)i).type.isBlank()) continue;
            return false;
        }
        return true;
    }

    public void saveXml(Writer fwrite) throws IOException {
        fwrite.append("<exefilter>");
        if (this.filterflags_mask != 0) {
            fwrite.append("<flags mask=\"");
            fwrite.append(SpecXmlUtils.encodeUnsignedInteger((long)this.filterflags_mask));
            fwrite.append("\">");
            fwrite.append(SpecXmlUtils.encodeUnsignedInteger((long)this.filterflags_value));
            fwrite.append("</flags>\n");
        }
        for (int i = 0; i < this.atoms.size(); ++i) {
            this.atoms.get(i).saveXml(fwrite);
        }
        fwrite.append("</exefilter>\n");
    }

    public void restoreXml(XmlPullParser parser) {
        parser.start(new String[]{"exefilter"});
        this.atoms.clear();
        while (parser.peek().isStart()) {
            FilterAtom newatom;
            XmlElement el = parser.peek();
            if (el.getName().equals("flags")) {
                el = parser.start(new String[0]);
                this.filterflags_mask = SpecXmlUtils.decodeInt((String)el.getAttribute("mask"));
                this.filterflags_value = SpecXmlUtils.decodeInt((String)parser.end().getText());
                continue;
            }
            if (el.getName().equals("childatom")) {
                newatom = new ChildAtom();
                ((ChildAtom)newatom).restoreXml(parser);
                this.atoms.add(newatom);
                continue;
            }
            newatom = new FilterAtom();
            newatom.restoreXml(parser);
            this.atoms.add(newatom);
        }
        parser.end();
    }

    public boolean evaluate(FunctionDescription func) {
        if ((func.getFlags() & this.filterflags_mask) != this.filterflags_value) {
            return false;
        }
        ExecutableRecord exe = func.getExecutableRecord();
        if (this.filterNameToFilterMapAND == null) {
            this.populateFilterMaps();
        }
        return this.processFilters(exe);
    }

    private void populateFilterMaps() {
        this.filterNameToFilterMapAND = new HashMap<String, List<FilterAtom>>();
        this.filterNameToFilterMapOR = new HashMap<String, List<FilterAtom>>();
        for (FilterAtom atom : this.atoms) {
            ArrayList<FilterAtom> list;
            String name = atom.type.getLabel();
            BSimFilterType filter = atom.type;
            if (filter.orMultipleEntries()) {
                if (!this.filterNameToFilterMapOR.containsKey(name)) {
                    list = new ArrayList<FilterAtom>();
                    list.add(atom);
                    this.filterNameToFilterMapOR.put(name, list);
                    continue;
                }
                this.filterNameToFilterMapOR.get(name).add(atom);
                continue;
            }
            if (!this.filterNameToFilterMapAND.containsKey(name)) {
                list = new ArrayList();
                list.add(atom);
                this.filterNameToFilterMapAND.put(name, list);
                continue;
            }
            this.filterNameToFilterMapAND.get(name).add(atom);
        }
    }

    private boolean processFilters(ExecutableRecord exe) {
        List<FilterAtom> value;
        for (Map.Entry<String, List<FilterAtom>> entry : this.filterNameToFilterMapAND.entrySet()) {
            value = entry.getValue();
            if (this.evaluateAND(value, exe)) continue;
            return false;
        }
        for (Map.Entry<String, List<FilterAtom>> entry : this.filterNameToFilterMapOR.entrySet()) {
            value = entry.getValue();
            if (this.evaluateOR(value, exe)) continue;
            return false;
        }
        return true;
    }

    private boolean evaluateAND(List<FilterAtom> filters, ExecutableRecord exe) {
        for (FilterAtom filter : filters) {
            if (filter.evaluate(exe)) continue;
            return false;
        }
        return true;
    }

    private boolean evaluateOR(List<FilterAtom> filters, ExecutableRecord exe) {
        for (FilterAtom filter : filters) {
            if (!filter.evaluate(exe)) continue;
            return true;
        }
        return false;
    }

    public void replaceWith(BSimFilter other) {
        this.atoms = other.atoms;
        this.filterflags_mask = other.filterflags_mask;
        this.filterflags_value = other.filterflags_value;
    }

    public List<FilterEntry> getFilterEntries() {
        List<FilterAtom> atomList;
        ArrayList<FilterEntry> filterStrings = new ArrayList<FilterEntry>();
        if (this.filterNameToFilterMapAND == null) {
            this.populateFilterMaps();
        }
        for (Map.Entry<String, List<FilterAtom>> entry : this.filterNameToFilterMapOR.entrySet()) {
            atomList = entry.getValue();
            filterStrings.add(new FilterEntry(atomList.get((int)0).type, this.getValues(atomList)));
        }
        for (Map.Entry<String, List<FilterAtom>> entry : this.filterNameToFilterMapAND.entrySet()) {
            atomList = entry.getValue();
            filterStrings.add(new FilterEntry(atomList.get((int)0).type, this.getValues(atomList)));
        }
        return filterStrings;
    }

    private List<String> getValues(List<FilterAtom> atomList) {
        return atomList.stream().map(a -> a.getValueString()).collect(Collectors.toList());
    }

    public record FilterEntry(BSimFilterType filterType, List<String> values) {
    }
}

