/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.bsim.gui.overview;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.DialogComponentProvider;
import docking.WindowPosition;
import docking.action.DockingActionIf;
import docking.action.builder.ActionBuilder;
import docking.widgets.table.RowObjectTableModel;
import generic.lsh.vector.LSHVectorFactory;
import ghidra.app.context.ProgramActionContext;
import ghidra.app.events.ProgramSelectionPluginEvent;
import ghidra.app.services.GoToService;
import ghidra.features.bsim.gui.BSimSearchPlugin;
import ghidra.features.bsim.gui.overview.BSimOverviewModel;
import ghidra.features.bsim.gui.overview.BSimOverviewRowObject;
import ghidra.features.bsim.gui.search.dialog.BSimSearchSettings;
import ghidra.features.bsim.gui.search.results.BSimSearchInfoDisplayDialog;
import ghidra.features.bsim.query.BSimServerInfo;
import ghidra.features.bsim.query.protocol.ResponseNearestVector;
import ghidra.framework.model.DomainObjectEvent;
import ghidra.framework.model.DomainObjectListener;
import ghidra.framework.model.EventType;
import ghidra.framework.plugintool.ComponentProviderAdapter;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginEvent;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramEvent;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.ProgramSelection;
import ghidra.util.HelpLocation;
import ghidra.util.table.GhidraFilterTable;
import ghidra.util.table.GhidraTable;
import ghidra.util.table.SelectionNavigationAction;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import resources.Icons;

public class BSimOverviewProvider
extends ComponentProviderAdapter {
    private static final String PROVIDER_WINDOW_GROUP = "bsim.overview";
    private static final String NAME = "BSim Function Overview";
    private JComponent component;
    private BSimSearchPlugin plugin;
    private Program program;
    private BSimOverviewModel overviewModel;
    private GhidraTable table;
    private BSimServerInfo serverInfo;
    private BSimSearchSettings settings;
    private DomainObjectListener listener;

    public BSimOverviewProvider(BSimSearchPlugin plugin, BSimServerInfo serverInfo, Program program, LSHVectorFactory vFactory, BSimSearchSettings settings) {
        super(plugin.getTool(), NAME, plugin.getName());
        this.plugin = plugin;
        this.serverInfo = serverInfo;
        this.program = program;
        this.settings = settings;
        this.setHelpLocation(new HelpLocation("BSimSearchPlugin", "BSim_Overview_Results"));
        this.setDefaultWindowPosition(WindowPosition.WINDOW);
        this.setWindowGroup(PROVIDER_WINDOW_GROUP);
        this.setWindowMenuGroup("BSim");
        this.setTabText(program.getName() + " -- " + String.valueOf(serverInfo));
        this.setTitle(NAME);
        this.setTransient();
        this.component = this.buildComponent(vFactory);
        this.tool.addComponentProvider((ComponentProvider)this, true);
        this.createActions();
        this.updateSubTitle();
        this.listener = ev -> {
            if (ev.contains(new EventType[]{ProgramEvent.SYMBOL_RENAMED, DomainObjectEvent.RESTORED})) {
                this.overviewModel.fireTableDataChanged();
            }
        };
        program.addListener(this.listener);
    }

    public Program getProgram() {
        return this.program;
    }

    public JComponent getComponent() {
        return this.component;
    }

    private void createActions() {
        this.addLocalAction((DockingActionIf)new SelectionNavigationAction((Plugin)this.plugin, this.table));
        HelpLocation help = new HelpLocation("BSimSearchPlugin", "Overview_Search_Info_Action");
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Search Info", this.getOwner()).toolBarIcon(Icons.INFO_ICON)).helpLocation(help)).onAction(c -> this.showSearchInfo())).buildAndInstallLocal((ComponentProvider)this);
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Make Selection", this.getOwner()).popupMenuPath(new String[]{"Make Selection"})).description("Make a selection using selected rows")).helpLocation(new HelpLocation("BSimSearchPlugin", "Overview_Make_Selection"))).toolBarIcon(Icons.MAKE_SELECTION_ICON)).enabledWhen(c -> this.table.getSelectedRowCount() > 0)).onAction(c -> this.makeSelection())).buildAndInstallLocal((ComponentProvider)this);
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Overview BSim Search From Dialog", this.getOwner()).popupMenuPath(new String[]{"Search Selected Functions..."})).description("Displays the BSim Simliar Functions Search Dialog with the selected funtions.")).helpLocation(new HelpLocation("BSimSearchPlugin", "Overview_Initiate_Search_Dialog"))).enabledWhen(c -> this.table.getSelectedRowCount() > 0)).onAction(c -> this.initialBSimSearch(true))).buildAndInstallLocal((ComponentProvider)this);
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Overview BSim Search", this.getOwner()).popupMenuPath(new String[]{"Search Selected Functions"})).description("Performs a BSim Similar Functions Search on the selected functions.")).helpLocation(new HelpLocation("BSimSearchPlugin", "Overview_Initiate_Search"))).enabledWhen(c -> this.table.getSelectedRowCount() > 0)).onAction(c -> this.initialBSimSearch(false))).buildAndInstallLocal((ComponentProvider)this);
    }

    private void showSearchInfo() {
        this.tool.showDialog((DialogComponentProvider)new BSimSearchInfoDisplayDialog(this.serverInfo, this.settings, true));
    }

    private void initialBSimSearch(boolean showDialog) {
        ArrayList<Address> selectedFunctionAddresses = new ArrayList<Address>();
        int[] selectedRows = this.table.getSelectedRows();
        List rowObjects = this.overviewModel.getRowObjects(selectedRows);
        for (BSimOverviewRowObject rowObject : rowObjects) {
            selectedFunctionAddresses.add(rowObject.getFunctionEntryPoint());
        }
        this.plugin.doBSimSearch(this.program, selectedFunctionAddresses, showDialog);
    }

    private void makeSelection() {
        ProgramSelection selection = this.table.getProgramSelection();
        if (this.program == null || this.program.isClosed() || selection.getNumAddresses() == 0L) {
            return;
        }
        GoToService service = (GoToService)this.tool.getService(GoToService.class);
        if (service != null) {
            service.goTo(new ProgramLocation(this.program, selection.getMinAddress()));
        }
        this.tool.firePluginEvent((PluginEvent)new ProgramSelectionPluginEvent(this.getName(), selection, this.program));
    }

    private void updateSubTitle() {
        int rowCount = this.overviewModel.getRowCount();
        int unfilteredCount = this.overviewModel.getUnfilteredRowCount();
        StringBuilder buf = new StringBuilder();
        buf.append(this.program.getName());
        buf.append(" (");
        buf.append(rowCount);
        buf.append(" functions");
        if (rowCount != unfilteredCount) {
            buf.append(" (out of ").append(unfilteredCount).append(')');
        }
        buf.append(")");
        this.setSubTitle(buf.toString());
    }

    private JComponent buildComponent(LSHVectorFactory vectorFactory) {
        JPanel panel = new JPanel(new BorderLayout());
        this.overviewModel = new BSimOverviewModel(this.tool, this.program, vectorFactory);
        GhidraFilterTable filterTable = new GhidraFilterTable((RowObjectTableModel)this.overviewModel);
        this.table = filterTable.getTable();
        this.table.getSelectionModel().addListSelectionListener(e -> this.notifyContextChanged());
        this.table.setNavigateOnSelectionEnabled(true);
        this.overviewModel.addTableModelListener(e -> this.updateSubTitle());
        filterTable.installNavigation((ServiceProvider)this.tool);
        panel.setPreferredSize(new Dimension(600, 400));
        panel.add((Component)filterTable, "Center");
        return panel;
    }

    private void notifyContextChanged() {
        this.tool.contextChanged((ComponentProvider)this);
    }

    public void overviewResultAdded(ResponseNearestVector result) {
        this.overviewModel.addResult(result);
    }

    public void setFinalOverviewResults(ResponseNearestVector result) {
        this.overviewModel.reload(this.program, result);
        this.component.revalidate();
    }

    public void componentHidden() {
        super.componentHidden();
        if (this.plugin != null) {
            this.program.removeListener(this.listener);
            this.plugin.providerClosed(this);
        }
    }

    public ActionContext getActionContext(MouseEvent event) {
        if (this.program == null) {
            return null;
        }
        return new ProgramActionContext((ComponentProvider)this, this.program, (Component)this.table);
    }

    public String toString() {
        return this.getTitle();
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public final boolean equals(Object obj) {
        return super.equals(obj);
    }

    BSimOverviewModel getModel() {
        return this.overviewModel;
    }
}

