/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.plugintool.mgr;

import ghidra.framework.cmd.BackgroundCommand;
import ghidra.framework.plugintool.PluginTool;
import ghidra.util.task.Task;
import ghidra.util.task.TaskListener;
import ghidra.util.task.TaskMonitorComponent;
import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

class ToolTaskMonitor
extends TaskMonitorComponent
implements TaskListener {
    private PluginTool tool;
    private Runnable addPanelRunnable;
    private Runnable removePanelRunnable;

    ToolTaskMonitor(PluginTool pluginTool) {
        this.tool = pluginTool;
        this.addPanelRunnable = () -> {
            if (this.tool != null) {
                this.tool.addStatusComponent((JComponent)((Object)this), false, true);
            }
        };
        this.removePanelRunnable = () -> {
            if (this.tool != null) {
                this.tool.removeStatusComponent((JComponent)((Object)this));
            }
        };
    }

    public void updateTaskCmd(BackgroundCommand<?> cmd) {
        this.showProgress(cmd.hasProgress());
        this.setTaskName(cmd.getName());
    }

    void initialize(Task task) {
        if (this.tool == null) {
            return;
        }
        this.reset();
        this.showProgress(task.hasProgress());
        task.addTaskListener((TaskListener)this);
        this.setTaskName(task.getTaskTitle());
        this.setCancelEnabled(task.canCancel());
        SwingUtilities.invokeLater(this.addPanelRunnable);
    }

    void dispose() {
        this.cancel();
        this.tool = null;
    }

    public void taskCompleted(Task task) {
        SwingUtilities.invokeLater(this.removePanelRunnable);
    }

    public void taskCancelled(Task task) {
        SwingUtilities.invokeLater(this.removePanelRunnable);
    }

    public Dimension getPreferredSize() {
        Dimension preferredSize = super.getPreferredSize();
        preferredSize.width += 200;
        return preferredSize;
    }
}

