/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.model;

import ghidra.framework.model.DomainObjectChangeRecord;
import ghidra.framework.model.DomainObjectChangedEvent;
import ghidra.framework.model.DomainObjectListener;
import ghidra.framework.model.EventType;
import ghidra.util.Msg;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import utilities.util.reflection.ReflectionUtilities;
import utility.function.Callback;

public abstract class AbstractDomainObjectListenerBuilder<R extends DomainObjectChangeRecord, B extends AbstractDomainObjectListenerBuilder<R, B>> {
    private String name;
    private BooleanSupplier ignoreCheck;
    private List<EventTrigger> terminateList = new ArrayList<EventTrigger>();
    private List<EventTrigger> onAnyList = new ArrayList<EventTrigger>();
    private Map<EventType, TypedRecordConsumer<? extends DomainObjectChangeRecord>> onEachMap = new HashMap<EventType, TypedRecordConsumer<? extends DomainObjectChangeRecord>>();
    private Class<? extends DomainObjectChangeRecord> activeRecordType;

    public AbstractDomainObjectListenerBuilder(String name, Class<R> recordClass) {
        this.name = name;
        this.activeRecordType = recordClass;
    }

    public String getName() {
        return this.name;
    }

    protected abstract B self();

    public B ignoreWhen(BooleanSupplier supplier) {
        this.ignoreCheck = supplier;
        return this.self();
    }

    public AnyBuilder any(EventType ... eventTypes) {
        return new AnyBuilder(eventTypes);
    }

    public EachBuilder each(EventType ... eventTypes) {
        return new EachBuilder(eventTypes);
    }

    public <R2 extends DomainObjectChangeRecord, B2 extends AbstractDomainObjectListenerBuilder<R2, B2>> B2 with(Class<R2> clazz) {
        this.activeRecordType = clazz;
        B newSelf = this.self();
        return (B2)newSelf;
    }

    public DomainObjectListener build() {
        BuilderDomainObjectListener listener = new BuilderDomainObjectListener(this.name);
        listener.setIgnoreCheck(this.ignoreCheck);
        if (!this.terminateList.isEmpty()) {
            listener.setTerminateList(this.terminateList);
        }
        if (!this.onAnyList.isEmpty()) {
            listener.setOnAnyList(this.onAnyList);
        }
        if (!this.onEachMap.isEmpty()) {
            listener.setOnEachMap(this.onEachMap);
        }
        return listener;
    }

    public class AnyBuilder {
        List<EventType> eventTypeList = new ArrayList<EventType>();

        public AnyBuilder(EventType[] eventTypes) {
            this.eventTypeList.addAll(Arrays.asList(eventTypes));
        }

        public B call(Callback callback) {
            EventType[] eventTypes = this.eventTypeList.toArray(new EventType[this.eventTypeList.size()]);
            AbstractDomainObjectListenerBuilder.this.onAnyList.add(new EventTrigger(callback, eventTypes));
            return AbstractDomainObjectListenerBuilder.this.self();
        }

        public B call(Consumer<DomainObjectChangedEvent> consumer) {
            EventType[] eventTypes = this.eventTypeList.toArray(new EventType[this.eventTypeList.size()]);
            AbstractDomainObjectListenerBuilder.this.onAnyList.add(new EventTrigger(consumer, eventTypes));
            return AbstractDomainObjectListenerBuilder.this.self();
        }

        public B terminate(Callback callback) {
            EventType[] eventTypes = this.eventTypeList.toArray(new EventType[this.eventTypeList.size()]);
            AbstractDomainObjectListenerBuilder.this.terminateList.add(new EventTrigger(callback, eventTypes));
            return AbstractDomainObjectListenerBuilder.this.self();
        }

        public B terminate(Consumer<DomainObjectChangedEvent> consumer) {
            EventType[] eventTypes = this.eventTypeList.toArray(new EventType[this.eventTypeList.size()]);
            AbstractDomainObjectListenerBuilder.this.terminateList.add(new EventTrigger(consumer, eventTypes));
            return AbstractDomainObjectListenerBuilder.this.self();
        }
    }

    public class EachBuilder {
        List<EventType> eventTypeList = new ArrayList<EventType>();

        public EachBuilder(EventType[] eventTypes) {
            this.eventTypeList.addAll(Arrays.asList(eventTypes));
        }

        public B call(Consumer<R> consumer) {
            TypedRecordConsumer trc = new TypedRecordConsumer(consumer, AbstractDomainObjectListenerBuilder.this.activeRecordType);
            for (EventType eventType : this.eventTypeList) {
                AbstractDomainObjectListenerBuilder.this.onEachMap.put(eventType, trc);
            }
            return AbstractDomainObjectListenerBuilder.this.self();
        }

        public B call(BiConsumer<DomainObjectChangedEvent, R> biConsumer) {
            TypedRecordConsumer trc = new TypedRecordConsumer(biConsumer, AbstractDomainObjectListenerBuilder.this.activeRecordType);
            for (EventType eventType : this.eventTypeList) {
                AbstractDomainObjectListenerBuilder.this.onEachMap.put(eventType, trc);
            }
            return AbstractDomainObjectListenerBuilder.this.self();
        }
    }

    static class BuilderDomainObjectListener
    implements DomainObjectListener {
        private String name;
        private BooleanSupplier ignoreCheck = () -> false;
        private List<EventTrigger> terminateList;
        private List<EventTrigger> onAnyList;
        private Map<EventType, TypedRecordConsumer<? extends DomainObjectChangeRecord>> onEachMap;
        private EventType[] eachEventTypes;

        BuilderDomainObjectListener(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        void setIgnoreCheck(BooleanSupplier supplier) {
            this.ignoreCheck = supplier != null ? supplier : () -> false;
        }

        void setTerminateList(List<EventTrigger> terminatEventList) {
            this.terminateList = terminatEventList;
        }

        void setOnAnyList(List<EventTrigger> onAnyList) {
            this.onAnyList = onAnyList;
        }

        void setOnEachMap(Map<EventType, TypedRecordConsumer<? extends DomainObjectChangeRecord>> onEachMap) {
            this.onEachMap = onEachMap;
            this.eachEventTypes = onEachMap.keySet().toArray(new EventType[onEachMap.size()]);
        }

        @Override
        public void domainObjectChanged(DomainObjectChangedEvent event) {
            if (this.ignoreCheck.getAsBoolean()) {
                return;
            }
            if (this.terminateList != null && this.processTerminateList(event)) {
                return;
            }
            if (this.onAnyList != null) {
                this.processOnAnyList(event);
            }
            if (this.onEachMap != null) {
                this.processOnEachMap(event);
            }
        }

        private boolean processTerminateList(DomainObjectChangedEvent event) {
            for (EventTrigger trigger : this.terminateList) {
                if (!trigger.isTriggered(event)) continue;
                trigger.accept(event);
                return true;
            }
            return false;
        }

        private void processOnAnyList(DomainObjectChangedEvent event) {
            for (EventTrigger trigger : this.onAnyList) {
                if (!trigger.isTriggered(event)) continue;
                trigger.accept(event);
            }
        }

        private void processOnEachMap(DomainObjectChangedEvent event) {
            if (event.numRecords() > this.onEachMap.size() && !event.contains(this.eachEventTypes)) {
                return;
            }
            for (DomainObjectChangeRecord record : event) {
                EventType type = record.getEventType();
                TypedRecordConsumer<? extends DomainObjectChangeRecord> typedRecordConsumer = this.onEachMap.get(type);
                if (typedRecordConsumer == null) continue;
                typedRecordConsumer.accept(event, record);
            }
        }
    }

    static class TypedRecordConsumer<RR>
    implements BiConsumer<DomainObjectChangedEvent, DomainObjectChangeRecord> {
        private Class<? extends DomainObjectChangeRecord> recordClass;
        private BiConsumer<DomainObjectChangedEvent, RR> consumer;
        private String inceptionInformation;

        TypedRecordConsumer(Consumer<RR> consumerX, Class<? extends DomainObjectChangeRecord> recordClass) {
            this((DomainObjectChangedEvent a, RR b) -> consumerX.accept(b), recordClass);
        }

        TypedRecordConsumer(BiConsumer<DomainObjectChangedEvent, RR> consumer, Class<? extends DomainObjectChangeRecord> recordClass) {
            this.consumer = consumer;
            this.recordClass = recordClass;
            this.recordInception();
        }

        private void recordInception() {
            this.inceptionInformation = this.getInceptionFromTheFirstClassThatIsNotUsOrABuilder();
        }

        private String getInceptionFromTheFirstClassThatIsNotUsOrABuilder() {
            Throwable t = ReflectionUtilities.createThrowableWithStackOlderThan((Class[])new Class[]{this.getClass()});
            StackTraceElement[] trace = ReflectionUtilities.filterStackTrace((StackTraceElement[])t.getStackTrace(), (String[])new String[]{"ListenerBuilder"});
            String classInfo = trace[0].toString();
            return classInfo;
        }

        @Override
        public void accept(DomainObjectChangedEvent event, DomainObjectChangeRecord rec) {
            if (this.recordClass.isInstance(rec)) {
                this.consumer.accept(event, rec);
            } else {
                Msg.error((Object)this, (Object)("Registered incorrect record class for event type: " + this.inceptionInformation));
            }
        }
    }

    static class EventTrigger
    implements Consumer<DomainObjectChangedEvent> {
        private final Consumer<DomainObjectChangedEvent> consumer;
        private final EventType[] eventTypes;

        EventTrigger(Consumer<DomainObjectChangedEvent> consumer, EventType ... eventTypes) {
            this.consumer = consumer;
            this.eventTypes = eventTypes;
        }

        EventTrigger(Callback callback, EventType ... eventTypes) {
            this((DomainObjectChangedEvent e) -> callback.call(), eventTypes);
        }

        public boolean isTriggered(DomainObjectChangedEvent event) {
            return event.contains(this.eventTypes);
        }

        @Override
        public void accept(DomainObjectChangedEvent e) {
            this.consumer.accept(e);
        }
    }
}

