/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets;

import docking.DockingUtils;
import docking.widgets.shapes.Location;
import docking.widgets.shapes.PopupWindowPlacer;
import docking.widgets.shapes.PopupWindowPlacerBuilder;
import generic.theme.GColor;
import generic.theme.GThemeDefaults;
import generic.util.WindowUtilities;
import ghidra.util.bean.GGlassPane;
import ghidra.util.bean.GGlassPanePainter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import util.CollectionUtils;

public class PopupWindow {
    private static final int X_PADDING = 25;
    private static final int Y_PADDING = 25;
    private static final List<WeakReference<PopupWindow>> VISIBLE_POPUPS = new ArrayList<WeakReference<PopupWindow>>();
    private static final PopupWindowPlacer DEFAULT_WINDOW_PLACER = new PopupWindowPlacerBuilder().rightEdge(Location.BOTTOM).leftEdge(Location.BOTTOM).bottomEdge(Location.RIGHT).topEdge(Location.CENTER).leastOverlapCorner().throwsAssertException().build();
    private Rectangle mouseMovementArea;
    private JWindow popup;
    private Component sourceComponent;
    private PopupWindowPlacer popupWindowPlacer = DEFAULT_WINDOW_PLACER;
    private MouseMotionListener sourceMouseMotionListener;
    private MouseListener sourceMouseListener;
    private Timer closeTimer;
    private JComponent displayComponent;

    public static void hideAllWindows() {
        for (WeakReference<PopupWindow> weakReference : VISIBLE_POPUPS) {
            PopupWindow popupWindow = (PopupWindow)weakReference.get();
            if (popupWindow == null) continue;
            popupWindow.hide();
        }
    }

    public PopupWindow(JComponent displayComponent) {
        this(PopupWindow.getDefaultParentWindow(), displayComponent);
    }

    public PopupWindow(Component sourceComponent, JComponent displayComponent) {
        this(PopupWindow.getParentWindow(sourceComponent), displayComponent);
    }

    private static Window getParentWindow(Component sourceComponent) {
        if (sourceComponent == null) {
            return PopupWindow.getDefaultParentWindow();
        }
        Window window = WindowUtilities.windowForComponent((Component)sourceComponent);
        if (window != null) {
            return window;
        }
        return PopupWindow.getDefaultParentWindow();
    }

    private static Window getDefaultParentWindow() {
        KeyboardFocusManager kfm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        Window activeWindow = kfm.getActiveWindow();
        if (activeWindow == null) {
            activeWindow = JOptionPane.getRootFrame();
        }
        return activeWindow;
    }

    public PopupWindow(Window parentWindow, JComponent displayComponent) {
        this.displayComponent = displayComponent;
        this.popup = new JWindow(parentWindow);
        this.popup.setFocusableWindowState(false);
        this.popup.getContentPane().add(displayComponent);
        this.popup.pack();
        this.closeTimer = new Timer(750, event -> this.hide());
        this.closeTimer.setRepeats(false);
        MouseAdapter closeWindowListener = new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                PopupWindow.this.closeTimer.stop();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                PopupWindow.this.closeTimer.start();
            }
        };
        this.addMouseListener(this.popup, closeWindowListener);
        this.sourceMouseMotionListener = new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                Point localPoint = e.getPoint();
                SwingUtilities.convertPointToScreen(localPoint, e.getComponent());
                if (!PopupWindow.this.mouseMovementArea.contains(localPoint)) {
                    PopupWindow.this.hide();
                } else {
                    PopupWindow.this.closeTimer.restart();
                }
                e.consume();
            }
        };
        this.sourceMouseListener = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                PopupWindow.this.hide();
            }
        };
    }

    private void addMouseListener(Container c, MouseListener listener) {
        Component[] children;
        c.addMouseListener(listener);
        for (Component element : children = c.getComponents()) {
            if (element instanceof Container) {
                this.addMouseListener((Container)element, listener);
                continue;
            }
            element.addMouseListener(listener);
        }
    }

    public JComponent getDisplayComponent() {
        return this.displayComponent;
    }

    public void setWindowName(String name) {
        this.popup.setName(name);
    }

    public void addComponentListener(ComponentListener listener) {
        this.popup.addComponentListener(listener);
    }

    public boolean isShowing() {
        return this.popup.isShowing();
    }

    public void hide() {
        this.popup.setVisible(false);
        if (this.sourceComponent != null) {
            this.sourceComponent.removeMouseMotionListener(this.sourceMouseMotionListener);
            this.sourceComponent.removeMouseListener(this.sourceMouseListener);
        }
        this.sourceComponent = null;
    }

    public void dispose() {
        this.hide();
        this.popup.dispose();
        this.removeOldPopupReferences();
    }

    private void removeOldPopupReferences() {
        Iterator<WeakReference<PopupWindow>> iterator = VISIBLE_POPUPS.iterator();
        while (iterator.hasNext()) {
            WeakReference<PopupWindow> reference = iterator.next();
            PopupWindow window = (PopupWindow)reference.get();
            if (window != this) continue;
            reference.clear();
            iterator.remove();
            return;
        }
    }

    public void pack() {
        this.popup.pack();
    }

    public void setCloseWindowDelay(int delayInMillis) {
        this.closeTimer = new Timer(delayInMillis, event -> this.hide());
        this.closeTimer.setRepeats(false);
    }

    public void setPopupPlacer(PopupWindowPlacer popupWindowPlacer) {
        this.popupWindowPlacer = popupWindowPlacer == null ? DEFAULT_WINDOW_PLACER : popupWindowPlacer;
    }

    public void showOffsetPopup(MouseEvent e, Rectangle keepVisibleArea, boolean forceShow) {
        if (forceShow || DockingUtils.isTipWindowEnabled()) {
            PopupSource popupSource = new PopupSource(e, keepVisibleArea);
            this.doShowPopup(popupSource);
        }
    }

    public void showPopup(MouseEvent e, boolean forceShow) {
        if (forceShow || DockingUtils.isTipWindowEnabled()) {
            PopupSource popupSource = new PopupSource(e);
            this.doShowPopup(popupSource);
        }
    }

    public void showPopup(Component component, Point location, boolean forceShow) {
        if (forceShow || DockingUtils.isTipWindowEnabled()) {
            PopupSource popupSource = new PopupSource(component, location, null);
            this.doShowPopup(popupSource);
        }
    }

    public void showPopup(MouseEvent e) {
        this.showPopup(e, false);
    }

    private void doShowPopup(PopupSource popupSource) {
        PopupWindow.hideAllWindows();
        this.sourceComponent = popupSource.getSource();
        this.sourceComponent.addMouseListener(this.sourceMouseListener);
        this.sourceComponent.addMouseMotionListener(this.sourceMouseMotionListener);
        Dimension popupSize = this.popup.getSize();
        PopupWindow.ensureSize(popupSize);
        Rectangle visibleArea = popupSource.getScreenKeepVisibleArea();
        Rectangle screenBounds = WindowUtilities.getVisibleScreenBounds().getBounds();
        Rectangle placement = this.popupWindowPlacer.getPlacement(popupSize, visibleArea, screenBounds);
        this.mouseMovementArea = placement.union(visibleArea);
        this.popup.setBounds(placement);
        this.popup.setVisible(true);
        this.removeOldPopupReferences();
        VISIBLE_POPUPS.add(new WeakReference<PopupWindow>(this));
    }

    private static void ensureSize(Dimension popupDimension) {
        Dimension screenDimension = WindowUtilities.getVisibleScreenBounds().getBounds().getSize();
        if (screenDimension.width < popupDimension.width) {
            popupDimension.width = screenDimension.width / 2;
        }
        if (screenDimension.height < popupDimension.height) {
            popupDimension.height = screenDimension.height / 2;
        }
    }

    private class PopupSource {
        private Component source;
        private Rectangle screenKeepVisibleArea;
        private Point location;
        private static List<GGlassPanePainter> painters = new ArrayList<GGlassPanePainter>();

        PopupSource(MouseEvent e) {
            this(e, null);
        }

        PopupSource(MouseEvent e, Rectangle keepVisibleArea) {
            this(e.getComponent(), e.getPoint(), keepVisibleArea);
        }

        PopupSource(Component source, Point location, Rectangle keepVisibleArea) {
            if (CollectionUtils.isAllNull((Object[])new Object[]{location, keepVisibleArea})) {
                throw new NullPointerException("Both location and keepVisibleArea cannot be null");
            }
            if (keepVisibleArea == null) {
                keepVisibleArea = new Rectangle(location, new Dimension(0, 0));
            }
            this.location = location;
            this.source = source;
            this.screenKeepVisibleArea = this.createScreenKeepVisibleArea(location, keepVisibleArea);
            this.installDebugPainter(keepVisibleArea);
        }

        Component getSource() {
            return this.source;
        }

        Rectangle getScreenKeepVisibleArea() {
            return this.screenKeepVisibleArea;
        }

        private Rectangle createScreenKeepVisibleArea(Point p, Rectangle keepVisibleAea) {
            Rectangle newArea = keepVisibleAea;
            if (keepVisibleAea == null) {
                Point point = new Point(p);
                newArea = new Rectangle(point);
                newArea.grow(25, 25);
            }
            return this.createScreenKeepVisibleArea(newArea);
        }

        private Rectangle createScreenKeepVisibleArea(Rectangle keepVisibleAea) {
            Objects.requireNonNull(keepVisibleAea);
            Rectangle newArea = new Rectangle(keepVisibleAea);
            Point point = newArea.getLocation();
            SwingUtilities.convertPointToScreen(point, this.source);
            newArea.setLocation(point);
            return newArea;
        }

        private void installDebugPainter(Rectangle keepVisibleArea) {
        }

        private class ShapeDebugPainter
        implements GGlassPanePainter {
            private ShapeDebugPainter() {
            }

            public void paint(GGlassPane glassPane, Graphics g) {
                int alpha = 150;
                if (PopupWindow.this.mouseMovementArea != null) {
                    Rectangle r = PopupWindow.this.mouseMovementArea;
                    Point p = new Point(r.getLocation());
                    SwingUtilities.convertPointFromScreen(p, (Component)glassPane);
                    GColor c = GThemeDefaults.Colors.Palette.LAVENDER.withAlpha(alpha);
                    g.setColor((Color)c);
                    g.fillRect(p.x, p.y, r.width, r.height);
                }
                if (PopupSource.this.location != null) {
                    Point p = new Point(PopupSource.this.location);
                    p = SwingUtilities.convertPoint(PopupSource.this.source, p.x, p.y, (Component)glassPane);
                    g.setColor((Color)GThemeDefaults.Colors.Palette.RED.withAlpha(alpha));
                    int offset = 10;
                    g.fillRect(p.x - offset, p.y - offset, offset * 2, offset * 2);
                }
            }
        }
    }
}

