/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.wizard.add;

import docking.wizard.WizardModel;
import docking.wizard.WizardStep;
import ghidra.feature.vt.api.main.VTProgramCorrelatorFactory;
import ghidra.feature.vt.api.main.VTSession;
import ghidra.feature.vt.gui.wizard.add.AddToSessionData;
import ghidra.feature.vt.gui.wizard.add.CorrelatorChooserPanel;
import ghidra.feature.vt.gui.wizard.add.VTAddToSessionWizardModel;
import ghidra.util.HelpLocation;
import java.util.List;
import javax.swing.JComponent;

public class CorrelatorChooserStep
extends WizardStep<AddToSessionData> {
    private CorrelatorChooserPanel panel;

    public CorrelatorChooserStep(VTAddToSessionWizardModel model, VTSession session) {
        super((WizardModel)model, "Select Correlation Algorithm(s)", new HelpLocation("VersionTrackingPlugin", "Correlator_Panel"));
        this.panel = new CorrelatorChooserPanel(session, () -> this.notifyStatusChanged());
    }

    public void initialize(AddToSessionData data) {
    }

    public boolean isValid() {
        List<VTProgramCorrelatorFactory> correlators = this.panel.getSelectedCorrelators();
        return !correlators.isEmpty();
    }

    public void populateData(AddToSessionData data) {
        data.setCorrelators(this.panel.getSelectedCorrelators());
    }

    public boolean apply(AddToSessionData data) {
        return true;
    }

    public JComponent getComponent() {
        return this.panel;
    }

    public boolean canFinish(AddToSessionData data) {
        return data.getCorrelators() != null;
    }
}

