# CLI commands

Gemini CLI supports several built-in commands to help you manage your session,
customize the interface, and control its behavior. These commands are prefixed
with a forward slash (`/`), an at symbol (`@`), or an exclamation mark (`!`).

## Slash commands (`/`)

Slash commands provide meta-level control over the CLI itself.

### Built-in Commands

- **`/about`**
  - **Description:** Show version info. Please share this information when
    filing issues.

- **`/auth`**
  - **Description:** Open a dialog that lets you change the authentication
    method.

- **`/bug`**
  - **Description:** File an issue about Gemini CLI. By default, the issue is
    filed within the GitHub repository for Gemini CLI. The string you enter
    after `/bug` will become the headline for the bug being filed. The default
    `/bug` behavior can be modified using the `advanced.bugCommand` setting in
    your `.gemini/settings.json` files.

- **`/chat`**
  - **Description:** Save and resume conversation history for branching
    conversation state interactively, or resuming a previous state from a later
    session.
  - **Sub-commands:**
    - **`delete <tag>`**
      - **Description:** Deletes a saved conversation checkpoint.
    - **`list`**
      - **Description:** Lists available tags for chat state resumption.
      - **Note:** This command only lists chats saved within the current
        project. Because chat history is project-scoped, chats saved in other
        project directories will not be displayed.
    - **`resume <tag>`**
      - **Description:** Resumes a conversation from a previous save.
      - **Note:** You can only resume chats that were saved within the current
        project. To resume a chat from a different project, you must run the
        Gemini CLI from that project's directory.
    - **`save <tag>`**
      - **Description:** Saves the current conversation history. You must add a
        `<tag>` for identifying the conversation state.
      - **Details on checkpoint location:** The default locations for saved chat
        checkpoints are:
        - Linux/macOS: `~/.gemini/tmp/<project_hash>/`
        - Windows: `C:\Users\<YourUsername>\.gemini\tmp\<project_hash>\`
        - **Behavior:** Chats are saved into a project-specific directory,
          determined by where you run the CLI. Consequently, saved chats are
          only accessible when working within that same project.
        - **Note:** These checkpoints are for manually saving and resuming
          conversation states. For automatic checkpoints created before file
          modifications, see the
          [Checkpointing documentation](../cli/checkpointing.md).
    - **`share [filename]`**
      - **Description** Writes the current conversation to a provided Markdown
        or JSON file. If no filename is provided, then the CLI will generate
        one.
      - **Usage** `/chat share file.md` or `/chat share file.json`.

- **`/clear`**
  - **Description:** Clear the terminal screen, including the visible session
    history and scrollback within the CLI. The underlying session data (for
    history recall) might be preserved depending on the exact implementation,
    but the visual display is cleared.
  - **Keyboard shortcut:** Press **Ctrl+L** at any time to perform a clear
    action.

- **`/compress`**
  - **Description:** Replace the entire chat context with a summary. This saves
    on tokens used for future tasks while retaining a high level summary of what
    has happened.

- **`/copy`**
  - **Description:** Copies the last output produced by Gemini CLI to your
    clipboard, for easy sharing or reuse.
  - **Behavior:**
    - Local sessions use system clipboard tools (pbcopy/xclip/clip).
    - Remote sessions (SSH/WSL) use OSC 52 and require terminal support.
  - **Note:** This command requires platform-specific clipboard tools to be
    installed.
    - On Linux, it requires `xclip` or `xsel`. You can typically install them
      using your system's package manager.
    - On macOS, it requires `pbcopy`, and on Windows, it requires `clip`. These
      tools are typically pre-installed on their respective systems.

- **`/directory`** (or **`/dir`**)
  - **Description:** Manage workspace directories for multi-directory support.
  - **Sub-commands:**
    - **`add`**:
      - **Description:** Add a directory to the workspace. The path can be
        absolute or relative to the current working directory. Moreover, the
        reference from home directory is supported as well.
      - **Usage:** `/directory add <path1>,<path2>`
      - **Note:** Disabled in restrictive sandbox profiles. If you're using
        that, use `--include-directories` when starting the session instead.
    - **`show`**:
      - **Description:** Display all directories added by `/directory add` and
        `--include-directories`.
      - **Usage:** `/directory show`

- **`/docs`**
  - **Description:** Open the Gemini CLI documentation in your browser.

- **`/editor`**
  - **Description:** Open a dialog for selecting supported editors.

- **`/extensions`**
  - **Description:** Lists all active extensions in the current Gemini CLI
    session. See [Gemini CLI Extensions](../extensions/index.md).

- **`/help`**
  - **Description:** Display help information about Gemini CLI, including
    available commands and their usage.

- **`/shortcuts`**
  - **Description:** Toggle the shortcuts panel above the input.
  - **Shortcut:** Press `?` when the prompt is empty.

- **`/hooks`**
  - **Description:** Manage hooks, which allow you to intercept and customize
    Gemini CLI behavior at specific lifecycle events.
  - **Sub-commands:**
    - **`disable-all`**:
      - **Description:** Disable all enabled hooks.
    - **`disable <hook-name>`**:
      - **Description:** Disable a hook by name.
    - **`enable-all`**:
      - **Description:** Enable all disabled hooks.
    - **`enable <hook-name>`**:
      - **Description:** Enable a hook by name.
    - **`list`** (or `show`, `panel`):
      - **Description:** Display all registered hooks with their status.

- **`/ide`**
  - **Description:** Manage IDE integration.
  - **Sub-commands:**
    - **`disable`**:
      - **Description:** Disable IDE integration.
    - **`enable`**:
      - **Description:** Enable IDE integration.
    - **`install`**:
      - **Description:** Install required IDE companion.
    - **`status`**:
      - **Description:** Check status of IDE integration.

- **`/init`**
  - **Description:** To help users easily create a `GEMINI.md` file, this
    command analyzes the current directory and generates a tailored context
    file, making it simpler for them to provide project-specific instructions to
    the Gemini agent.

- **`/introspect`**
  - **Description:** Provide debugging information about the current Gemini CLI
    session, including the state of loaded sub-agents and active hooks. This
    command is primarily for advanced users and developers.

- **`/mcp`**
  - **Description:** Manage configured Model Context Protocol (MCP) servers.
  - **Sub-commands:**
    - **`auth`**:
      - **Description:** Authenticate with an OAuth-enabled MCP server.
      - **Usage:** `/mcp auth <server-name>`
      - **Details:** If `<server-name>` is provided, it initiates the OAuth flow
        for that server. If no server name is provided, it lists all configured
        servers that support OAuth authentication.
    - **`desc`**
      - **Description:** List configured MCP servers and tools with
        descriptions.
    - **`list`** or **`ls`**:
      - **Description:** List configured MCP servers and tools. This is the
        default action if no subcommand is specified.
    - **`refresh`**:
      - **Description:** Restarts all MCP servers and re-discovers their
        available tools.
    - **`schema`**:
      - **Description:** List configured MCP servers and tools with descriptions
        and schemas.

- **`/memory`**
  - **Description:** Manage the AI's instructional context (hierarchical memory
    loaded from `GEMINI.md` files).
  - **Sub-commands:**
    - **`add`**:
      - **Description:** Adds the following text to the AI's memory. Usage:
        `/memory add <text to remember>`
    - **`list`**:
      - **Description:** Lists the paths of the GEMINI.md files in use for
        hierarchical memory.
    - **`refresh`**:
      - **Description:** Reload the hierarchical instructional memory from all
        `GEMINI.md` files found in the configured locations (global,
        project/ancestors, and sub-directories). This command updates the model
        with the latest `GEMINI.md` content.
    - **`show`**:
      - **Description:** Display the full, concatenated content of the current
        hierarchical memory that has been loaded from all `GEMINI.md` files.
        This lets you inspect the instructional context being provided to the
        Gemini model.
    - **Note:** For more details on how `GEMINI.md` files contribute to
      hierarchical memory, see the
      [CLI Configuration documentation](../get-started/configuration.md).

- [**`/model`**](./model.md)
  - **Description:** Opens a dialog to choose your Gemini model.

- **`/policies`**
  - **Description:** Manage policies.
  - **Sub-commands:**
    - **`list`**:
      - **Description:** List all active policies grouped by mode.

- **`/privacy`**
  - **Description:** Display the Privacy Notice and allow users to select
    whether they consent to the collection of their data for service improvement
    purposes.

- **`/quit`** (or **`/exit`**)
  - **Description:** Exit Gemini CLI.

- **`/restore`**
  - **Description:** Restores the project files to the state they were in just
    before a tool was executed. This is particularly useful for undoing file
    edits made by a tool. If run without a tool call ID, it will list available
    checkpoints to restore from.
  - **Usage:** `/restore [tool_call_id]`
  - **Note:** Only available if checkpointing is configured via
    [settings](../get-started/configuration.md). See
    [Checkpointing documentation](../cli/checkpointing.md) for more details.

- [**`/rewind`**](./rewind.md)
  - **Description:** Navigates backward through the conversation history,
    allowing you to review past interactions and potentially revert to a
    previous state. This feature helps in managing complex or branched
    conversations.

- **`/resume`**
  - **Description:** Browse and resume previous conversation sessions. Opens an
    interactive session browser where you can search, filter, and select from
    automatically saved conversations.
  - **Features:**
    - **Management:** Delete unwanted sessions directly from the browser
    - **Resume:** Select any session to resume and continue the conversation
    - **Search:** Use `/` to search through conversation content across all
      sessions
    - **Session Browser:** Interactive interface showing all saved sessions with
      timestamps, message counts, and first user message for context
    - **Sorting:** Sort sessions by date or message count
  - **Note:** All conversations are automatically saved as you chat - no manual
    saving required. See [Session Management](../cli/session-management.md) for
    complete details.

- [**`/settings`**](./settings.md)
  - **Description:** Open the settings editor to view and modify Gemini CLI
    settings.
  - **Details:** This command provides a user-friendly interface for changing
    settings that control the behavior and appearance of Gemini CLI. It is
    equivalent to manually editing the `.gemini/settings.json` file, but with
    validation and guidance to prevent errors. See the
    [settings documentation](./settings.md) for a full list of available
    settings.
  - **Usage:** Simply run `/settings` and the editor will open. You can then
    browse or search for specific settings, view their current values, and
    modify them as desired. Changes to some settings are applied immediately,
    while others require a restart.

- **`/shells`** (or **`/bashes`**)
  - **Description:** Toggle the background shells view. This allows you to view
    and manage long-running processes that you've sent to the background.
- **`/setup-github`**
  - **Description:** Set up GitHub Actions to triage issues and review PRs with
    Gemini.

- [**`/skills`**](./skills.md)
  - **Description:** Manage Agent Skills, which provide on-demand expertise and
    specialized workflows.
  - **Sub-commands:**
    - **`disable <name>`**:
      - **Description:** Disable a specific skill by name.
      - **Usage:** `/skills disable <name>`
    - **`enable <name>`**:
      - **Description:** Enable a specific skill by name.
      - **Usage:** `/skills enable <name>`
    - **`list`**:
      - **Description:** List all discovered skills and their current status
        (enabled/disabled).
    - **`reload`**:
      - **Description:** Refresh the list of discovered skills from all tiers
        (workspace, user, and extensions).

- **`/stats`**
  - **Description:** Display detailed statistics for the current Gemini CLI
    session, including token usage, cached token savings (when available), and
    session duration. Note: Cached token information is only displayed when
    cached tokens are being used, which occurs with API key authentication but
    not with OAuth authentication at this time.

- **`/terminal-setup`**
  - **Description:** Configure terminal keybindings for multiline input (VS
    Code, Cursor, Windsurf).

- [**`/theme`**](./themes.md)
  - **Description:** Open a dialog that lets you change the visual theme of
    Gemini CLI.

- [**`/tools`**](../tools/index.md)
  - **Description:** Display a list of tools that are currently available within
    Gemini CLI.
  - **Usage:** `/tools [desc]`
  - **Sub-commands:**
    - **`desc`** or **`descriptions`**:
      - **Description:** Show detailed descriptions of each tool, including each
        tool's name with its full description as provided to the model.
    - **`nodesc`** or **`nodescriptions`**:
      - **Description:** Hide tool descriptions, showing only the tool names.

- **`/vim`**
  - **Description:** Toggle vim mode on or off. When vim mode is enabled, the
    input area supports vim-style navigation and editing commands in both NORMAL
    and INSERT modes.
  - **Features:**
    - **Count support:** Prefix commands with numbers (e.g., `3h`, `5w`, `10G`)
    - **Editing commands:** Delete with `x`, change with `c`, insert with `i`,
      `a`, `o`, `O`; complex operations like `dd`, `cc`, `dw`, `cw`
    - **INSERT mode:** Standard text input with escape to return to NORMAL mode
    - **NORMAL mode:** Navigate with `h`, `j`, `k`, `l`; jump by words with `w`,
      `b`, `e`; go to line start/end with `0`, `$`, `^`; go to specific lines
      with `G` (or `gg` for first line)
    - **Persistent setting:** Vim mode preference is saved to
      `~/.gemini/settings.json` and restored between sessions
    - **Repeat last command:** Use `.` to repeat the last editing operation
    - **Status indicator:** When enabled, shows `[NORMAL]` or `[INSERT]` in the
      footer

### Custom commands

Custom commands allow you to create personalized shortcuts for your most-used
prompts. For detailed instructions on how to create, manage, and use them,
please see the dedicated [Custom Commands documentation](./custom-commands.md).

## Input prompt shortcuts

These shortcuts apply directly to the input prompt for text manipulation.

- **Undo:**
  - **Keyboard shortcut:** Press **Alt+z** or **Cmd+z** to undo the last action
    in the input prompt.

- **Redo:**
  - **Keyboard shortcut:** Press **Shift+Alt+Z** or **Shift+Cmd+Z** to redo the
    last undone action in the input prompt.

## At commands (`@`)

At commands are used to include the content of files or directories as part of
your prompt to Gemini. These commands include git-aware filtering.

- **`@<path_to_file_or_directory>`**
  - **Description:** Inject the content of the specified file or files into your
    current prompt. This is useful for asking questions about specific code,
    text, or collections of files.
  - **Examples:**
    - `@path/to/your/file.txt Explain this text.`
    - `@src/my_project/ Summarize the code in this directory.`
    - `What is this file about? @README.md`
  - **Details:**
    - If a path to a single file is provided, the content of that file is read.
    - If a path to a directory is provided, the command attempts to read the
      content of files within that directory and any subdirectories.
    - Spaces in paths should be escaped with a backslash (e.g.,
      `@My\ Documents/file.txt`).
    - The command uses the `read_many_files` tool internally. The content is
      fetched and then inserted into your query before being sent to the Gemini
      model.
    - **Git-aware filtering:** By default, git-ignored files (like
      `node_modules/`, `dist/`, `.env`, `.git/`) are excluded. This behavior can
      be changed via the `context.fileFiltering` settings.
    - **File types:** The command is intended for text-based files. While it
      might attempt to read any file, binary files or very large files might be
      skipped or truncated by the underlying `read_many_files` tool to ensure
      performance and relevance. The tool indicates if files were skipped.
  - **Output:** The CLI will show a tool call message indicating that
    `read_many_files` was used, along with a message detailing the status and
    the path(s) that were processed.

- **`@` (Lone at symbol)**
  - **Description:** If you type a lone `@` symbol without a path, the query is
    passed as-is to the Gemini model. This might be useful if you are
    specifically talking _about_ the `@` symbol in your prompt.

### Error handling for `@` commands

- If the path specified after `@` is not found or is invalid, an error message
  will be displayed, and the query might not be sent to the Gemini model, or it
  will be sent without the file content.
- If the `read_many_files` tool encounters an error (e.g., permission issues),
  this will also be reported.

## Shell mode and passthrough commands (`!`)

The `!` prefix lets you interact with your system's shell directly from within
Gemini CLI.

- **`!<shell_command>`**
  - **Description:** Execute the given `<shell_command>` using `bash` on
    Linux/macOS or `powershell.exe -NoProfile -Command` on Windows (unless you
    override `ComSpec`). Any output or errors from the command are displayed in
    the terminal.
  - **Examples:**
    - `!ls -la` (executes `ls -la` and returns to Gemini CLI)
    - `!git status` (executes `git status` and returns to Gemini CLI)

- **`!` (Toggle shell mode)**
  - **Description:** Typing `!` on its own toggles shell mode.
    - **Entering shell mode:**
      - When active, shell mode uses a different coloring and a "Shell Mode
        Indicator".
      - While in shell mode, text you type is interpreted directly as a shell
        command.
    - **Exiting shell mode:**
      - When exited, the UI reverts to its standard appearance and normal Gemini
        CLI behavior resumes.

- **Caution for all `!` usage:** Commands you execute in shell mode have the
  same permissions and impact as if you ran them directly in your terminal.

- **Environment variable:** When a command is executed via `!` or in shell mode,
  the `GEMINI_CLI=1` environment variable is set in the subprocess's
  environment. This allows scripts or tools to detect if they are being run from
  within the Gemini CLI.
