/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.features.time.mindmapmode.nodelist;

import org.freeplane.core.util.HtmlUtils;
import org.freeplane.features.filter.condition.CJKNormalizer;
import org.freeplane.features.map.NodeModel;
import org.freeplane.view.swing.features.time.mindmapmode.nodelist.TextAccessor;

class TextHolder
implements Comparable<TextHolder> {
    private TextAccessor textAccessor;
    private String originalNotesText = null;
    private String untaggedNotesText = null;

    TextHolder(TextAccessor textAccessor) {
        this.textAccessor = textAccessor;
    }

    TextHolder() {
        this(null);
    }

    public void setTextAccessor(TextAccessor textAccessor) {
        this.textAccessor = textAccessor;
    }

    @Override
    public int compareTo(TextHolder compareToObject) {
        return this.toString().compareTo(compareToObject.toString());
    }

    public String getTextAsSingleLine() {
        String notesText = this.getText();
        if (notesText == null) {
            return "";
        }
        if (this.untaggedNotesText == null || this.originalNotesText != null && !this.originalNotesText.equals(notesText)) {
            this.originalNotesText = notesText;
            String plainText = HtmlUtils.htmlToPlain((String)notesText).replaceAll("\\s+\\n", " ");
            this.untaggedNotesText = CJKNormalizer.removeSpacesBetweenCJKCharacters((String)plainText);
        }
        return this.untaggedNotesText;
    }

    public String toString() {
        return this.getTextAsSingleLine();
    }

    public void setText(String newText) {
        this.textAccessor.setText(newText);
    }

    public NodeModel getNode() {
        return this.textAccessor.getNode();
    }

    public String getText() {
        return this.textAccessor.getText();
    }
}

