#include "mqtt_time.h"

#include <utility>
#include "esphome/core/log.h"

#include "mqtt_const.h"

#ifdef USE_MQTT
#ifdef USE_DATETIME_TIME

namespace esphome::mqtt {

static const char *const TAG = "mqtt.datetime.time";

using namespace esphome::datetime;

MQTTTimeComponent::MQTTTimeComponent(TimeEntity *time) : time_(time) {}

void MQTTTimeComponent::setup() {
  this->subscribe_json(this->get_command_topic_(), [this](const std::string &topic, JsonObject root) {
    auto call = this->time_->make_call();
    if (root[ESPHOME_F("hour")].is<uint8_t>()) {
      call.set_hour(root[ESPHOME_F("hour")]);
    }
    if (root[ESPHOME_F("minute")].is<uint8_t>()) {
      call.set_minute(root[ESPHOME_F("minute")]);
    }
    if (root[ESPHOME_F("second")].is<uint8_t>()) {
      call.set_second(root[ESPHOME_F("second")]);
    }
    call.perform();
  });
  this->time_->add_on_state_callback(
      [this]() { this->publish_state(this->time_->hour, this->time_->minute, this->time_->second); });
}

void MQTTTimeComponent::dump_config() {
  ESP_LOGCONFIG(TAG, "MQTT Time '%s':", this->time_->get_name().c_str());
  LOG_MQTT_COMPONENT(true, true);
}

MQTT_COMPONENT_TYPE(MQTTTimeComponent, "time")
const EntityBase *MQTTTimeComponent::get_entity() const { return this->time_; }

void MQTTTimeComponent::send_discovery(JsonObject root, mqtt::SendDiscoveryConfig &config) {
  // Nothing extra to add here
}
bool MQTTTimeComponent::send_initial_state() {
  if (this->time_->has_state()) {
    return this->publish_state(this->time_->hour, this->time_->minute, this->time_->second);
  } else {
    return true;
  }
}
bool MQTTTimeComponent::publish_state(uint8_t hour, uint8_t minute, uint8_t second) {
  char topic_buf[MQTT_DEFAULT_TOPIC_MAX_LEN];
  return this->publish_json(this->get_state_topic_to_(topic_buf), [hour, minute, second](JsonObject root) {
    // NOLINTNEXTLINE(clang-analyzer-cplusplus.NewDeleteLeaks) false positive with ArduinoJson
    root[ESPHOME_F("hour")] = hour;
    root[ESPHOME_F("minute")] = minute;
    root[ESPHOME_F("second")] = second;
  });
}

}  // namespace esphome::mqtt

#endif  // USE_DATETIME_TIME
#endif  // USE_MQTT
