// Copyright (c) Microsoft Corporation.
// Licensed under the MIT License.
import { wrapAbortSignalLike } from "../util/wrapAbortSignal.js";
export const wrapAbortSignalLikePolicyName = "wrapAbortSignalLikePolicy";
/**
 * Policy that ensure that any AbortSignalLike is wrapped in a native AbortSignal for processing by the pipeline.
 * Since the ts-http-runtime expects a native AbortSignal, this policy is used to ensure that any AbortSignalLike is wrapped in a native AbortSignal.
 *
 * @returns - created policy
 */
export function wrapAbortSignalLikePolicy() {
    return {
        name: wrapAbortSignalLikePolicyName,
        sendRequest: async (request, next) => {
            if (!request.abortSignal) {
                return next(request);
            }
            const { abortSignal, cleanup } = wrapAbortSignalLike(request.abortSignal);
            request.abortSignal = abortSignal;
            try {
                return await next(request);
            }
            finally {
                cleanup?.();
            }
        },
    };
}//# sourceMappingURL=https://main.vscode-cdn.net/sourcemaps/c3a26841a84f20dfe0850d0a5a9bd01da4f003ea/node_modules/@azure/core-rest-pipeline/dist/browser/policies/wrapAbortSignalLikePolicy.js.map