/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.binding.adapter;

import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.common.base.Preconditions;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.SpinnerModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public final class SpinnerToValueModelConnector {
    private final SpinnerModel spinnerModel;
    private final ValueModel valueModel;
    private final Object defaultValue;
    private final UpdateHandler updateHandler;

    public SpinnerToValueModelConnector(SpinnerModel spinnerModel, ValueModel valueModel, Object defaultValue) {
        this.spinnerModel = Preconditions.checkNotNull(spinnerModel, "The spinner model must not be null.");
        this.valueModel = Preconditions.checkNotNull(valueModel, "The value model must not be null.");
        this.defaultValue = Preconditions.checkNotNull(defaultValue, "The default value must not be null.");
        this.updateHandler = new UpdateHandler();
        spinnerModel.addChangeListener(this.updateHandler);
        valueModel.addValueChangeListener(this.updateHandler);
    }

    public static void connect(SpinnerModel spinnerModel, ValueModel valueModel, Object defaultValue) {
        new SpinnerToValueModelConnector(spinnerModel, valueModel, defaultValue);
    }

    public void updateSpinnerModel() {
        Object value = this.valueModel.getValue();
        Object valueWithDefault = value != null ? value : this.defaultValue;
        this.setSpinnerModelValueSilently(valueWithDefault);
    }

    public void updateValueModel() {
        this.setValueModelValueSilently(this.spinnerModel.getValue());
    }

    private void setSpinnerModelValueSilently(Object newValue) {
        this.spinnerModel.removeChangeListener(this.updateHandler);
        this.spinnerModel.setValue(newValue);
        this.spinnerModel.addChangeListener(this.updateHandler);
    }

    private void setValueModelValueSilently(Object newValue) {
        this.valueModel.removeValueChangeListener(this.updateHandler);
        this.valueModel.setValue(newValue);
        this.valueModel.addValueChangeListener(this.updateHandler);
    }

    public void release() {
        this.spinnerModel.removeChangeListener(this.updateHandler);
        this.valueModel.removeValueChangeListener(this.updateHandler);
    }

    private final class UpdateHandler
    implements PropertyChangeListener,
    ChangeListener {
        private UpdateHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            SpinnerToValueModelConnector.this.updateSpinnerModel();
        }

        @Override
        public void stateChanged(ChangeEvent evt) {
            SpinnerToValueModelConnector.this.updateValueModel();
        }
    }
}

