﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/glue/Glue_EXPORTS.h>
#include <aws/glue/model/UpsertRedshiftTargetOptions.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace Glue {
namespace Model {

/**
 * <p>Specifies a target that uses Amazon Redshift.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/RedshiftTarget">AWS
 * API Reference</a></p>
 */
class RedshiftTarget {
 public:
  AWS_GLUE_API RedshiftTarget() = default;
  AWS_GLUE_API RedshiftTarget(Aws::Utils::Json::JsonView jsonValue);
  AWS_GLUE_API RedshiftTarget& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_GLUE_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The name of the data target.</p>
   */
  inline const Aws::String& GetName() const { return m_name; }
  inline bool NameHasBeenSet() const { return m_nameHasBeenSet; }
  template <typename NameT = Aws::String>
  void SetName(NameT&& value) {
    m_nameHasBeenSet = true;
    m_name = std::forward<NameT>(value);
  }
  template <typename NameT = Aws::String>
  RedshiftTarget& WithName(NameT&& value) {
    SetName(std::forward<NameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The nodes that are inputs to the data target.</p>
   */
  inline const Aws::Vector<Aws::String>& GetInputs() const { return m_inputs; }
  inline bool InputsHasBeenSet() const { return m_inputsHasBeenSet; }
  template <typename InputsT = Aws::Vector<Aws::String>>
  void SetInputs(InputsT&& value) {
    m_inputsHasBeenSet = true;
    m_inputs = std::forward<InputsT>(value);
  }
  template <typename InputsT = Aws::Vector<Aws::String>>
  RedshiftTarget& WithInputs(InputsT&& value) {
    SetInputs(std::forward<InputsT>(value));
    return *this;
  }
  template <typename InputsT = Aws::String>
  RedshiftTarget& AddInputs(InputsT&& value) {
    m_inputsHasBeenSet = true;
    m_inputs.emplace_back(std::forward<InputsT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the database to write to.</p>
   */
  inline const Aws::String& GetDatabase() const { return m_database; }
  inline bool DatabaseHasBeenSet() const { return m_databaseHasBeenSet; }
  template <typename DatabaseT = Aws::String>
  void SetDatabase(DatabaseT&& value) {
    m_databaseHasBeenSet = true;
    m_database = std::forward<DatabaseT>(value);
  }
  template <typename DatabaseT = Aws::String>
  RedshiftTarget& WithDatabase(DatabaseT&& value) {
    SetDatabase(std::forward<DatabaseT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the table in the database to write to.</p>
   */
  inline const Aws::String& GetTable() const { return m_table; }
  inline bool TableHasBeenSet() const { return m_tableHasBeenSet; }
  template <typename TableT = Aws::String>
  void SetTable(TableT&& value) {
    m_tableHasBeenSet = true;
    m_table = std::forward<TableT>(value);
  }
  template <typename TableT = Aws::String>
  RedshiftTarget& WithTable(TableT&& value) {
    SetTable(std::forward<TableT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The Amazon S3 path where temporary data can be staged when copying out of the
   * database.</p>
   */
  inline const Aws::String& GetRedshiftTmpDir() const { return m_redshiftTmpDir; }
  inline bool RedshiftTmpDirHasBeenSet() const { return m_redshiftTmpDirHasBeenSet; }
  template <typename RedshiftTmpDirT = Aws::String>
  void SetRedshiftTmpDir(RedshiftTmpDirT&& value) {
    m_redshiftTmpDirHasBeenSet = true;
    m_redshiftTmpDir = std::forward<RedshiftTmpDirT>(value);
  }
  template <typename RedshiftTmpDirT = Aws::String>
  RedshiftTarget& WithRedshiftTmpDir(RedshiftTmpDirT&& value) {
    SetRedshiftTmpDir(std::forward<RedshiftTmpDirT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The IAM role with permissions.</p>
   */
  inline const Aws::String& GetTmpDirIAMRole() const { return m_tmpDirIAMRole; }
  inline bool TmpDirIAMRoleHasBeenSet() const { return m_tmpDirIAMRoleHasBeenSet; }
  template <typename TmpDirIAMRoleT = Aws::String>
  void SetTmpDirIAMRole(TmpDirIAMRoleT&& value) {
    m_tmpDirIAMRoleHasBeenSet = true;
    m_tmpDirIAMRole = std::forward<TmpDirIAMRoleT>(value);
  }
  template <typename TmpDirIAMRoleT = Aws::String>
  RedshiftTarget& WithTmpDirIAMRole(TmpDirIAMRoleT&& value) {
    SetTmpDirIAMRole(std::forward<TmpDirIAMRoleT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The set of options to configure an upsert operation when writing to a
   * Redshift target.</p>
   */
  inline const UpsertRedshiftTargetOptions& GetUpsertRedshiftOptions() const { return m_upsertRedshiftOptions; }
  inline bool UpsertRedshiftOptionsHasBeenSet() const { return m_upsertRedshiftOptionsHasBeenSet; }
  template <typename UpsertRedshiftOptionsT = UpsertRedshiftTargetOptions>
  void SetUpsertRedshiftOptions(UpsertRedshiftOptionsT&& value) {
    m_upsertRedshiftOptionsHasBeenSet = true;
    m_upsertRedshiftOptions = std::forward<UpsertRedshiftOptionsT>(value);
  }
  template <typename UpsertRedshiftOptionsT = UpsertRedshiftTargetOptions>
  RedshiftTarget& WithUpsertRedshiftOptions(UpsertRedshiftOptionsT&& value) {
    SetUpsertRedshiftOptions(std::forward<UpsertRedshiftOptionsT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_name;
  bool m_nameHasBeenSet = false;

  Aws::Vector<Aws::String> m_inputs;
  bool m_inputsHasBeenSet = false;

  Aws::String m_database;
  bool m_databaseHasBeenSet = false;

  Aws::String m_table;
  bool m_tableHasBeenSet = false;

  Aws::String m_redshiftTmpDir;
  bool m_redshiftTmpDirHasBeenSet = false;

  Aws::String m_tmpDirIAMRole;
  bool m_tmpDirIAMRoleHasBeenSet = false;

  UpsertRedshiftTargetOptions m_upsertRedshiftOptions;
  bool m_upsertRedshiftOptionsHasBeenSet = false;
};

}  // namespace Model
}  // namespace Glue
}  // namespace Aws
