/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.treetable;

import java.io.File;
import java.util.Arrays;
import java.util.Date;
import org.jdesktop.swingx.treetable.AbstractTreeTableModel;

public class FileSystemModel
extends AbstractTreeTableModel {
    private static final Long DIRECTORY = 0L;

    public FileSystemModel() {
        this(new File(File.separator));
    }

    public FileSystemModel(File root) {
        super(root);
    }

    private boolean isValidFileNode(Object file) {
        boolean result = false;
        if (file instanceof File) {
            for (File f = (File)file; !result && f != null; f = f.getParentFile()) {
                result = f.equals(this.root);
            }
        }
        return result;
    }

    @Override
    public File getChild(Object parent, int index) {
        if (!this.isValidFileNode(parent)) {
            throw new IllegalArgumentException("parent is not a file governed by this model");
        }
        File parentFile = (File)parent;
        String[] children = parentFile.list();
        if (children != null) {
            return new File(parentFile, children[index]);
        }
        return null;
    }

    @Override
    public int getChildCount(Object parent) {
        String[] children;
        if (parent instanceof File && (children = ((File)parent).list()) != null) {
            return children.length;
        }
        return 0;
    }

    @Override
    public Class<?> getColumnClass(int column) {
        switch (column) {
            case 0: {
                return String.class;
            }
            case 1: {
                return Long.class;
            }
            case 2: {
                return Boolean.class;
            }
            case 3: {
                return Date.class;
            }
        }
        return super.getColumnClass(column);
    }

    @Override
    public int getColumnCount() {
        return 4;
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return "Name";
            }
            case 1: {
                return "Size";
            }
            case 2: {
                return "Directory";
            }
            case 3: {
                return "Modification Date";
            }
        }
        return super.getColumnName(column);
    }

    @Override
    public Object getValueAt(Object node, int column) {
        if (node instanceof File) {
            File file = (File)node;
            switch (column) {
                case 0: {
                    return file.getName();
                }
                case 1: {
                    return this.isLeaf(node) ? file.length() : DIRECTORY.longValue();
                }
                case 2: {
                    return file.isDirectory();
                }
                case 3: {
                    return new Date(file.lastModified());
                }
            }
        }
        return null;
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        if (parent instanceof File && child instanceof File) {
            File parentFile = (File)parent;
            Object[] files = parentFile.listFiles();
            Arrays.sort(files);
            int len = files.length;
            for (int i = 0; i < len; ++i) {
                if (!((File)files[i]).equals(child)) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public File getRoot() {
        return (File)this.root;
    }

    public void setRoot(File root) {
        this.root = root;
        this.modelSupport.fireNewRoot();
    }

    @Override
    public boolean isLeaf(Object node) {
        if (node instanceof File) {
            return ((File)node).list() == null;
        }
        return true;
    }
}

