/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.runtime.internal.repository.metadata.datatransfer.export.format;

import com.ibm.db2.cmx.runtime.internal.repository.metadata.datatransfer.export.TableReader;
import com.ibm.db2.cmx.runtime.internal.repository.metadata.datatransfer.export.format.TableFormatter;
import com.ibm.db2.cmx.runtime.internal.repository.util.Base64;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;

public class CSVTableFormatter
implements TableFormatter {
    public static String fieldSeparator = ",";
    public static String crlf = "\r\n";
    public static String nullColumn = "null";

    @Override
    public void format(TableReader tableReader, OutputStream outputStream) throws IOException {
        try {
            Object[] objectArray;
            this.writeColumnNames(tableReader, outputStream);
            while ((objectArray = tableReader.next()) != null) {
                int n2 = objectArray.length;
                for (int i10 = 0; i10 < n2; ++i10) {
                    Object object = objectArray[i10];
                    String string = "";
                    if (object == null) {
                        outputStream.write(nullColumn.getBytes("UTF-8"));
                    } else {
                        if (object instanceof byte[]) {
                            byte[] byArray = (byte[])object;
                            string = this.encodeField(Base64.encode(byArray));
                        } else {
                            string = this.encodeField(object.toString());
                        }
                        outputStream.write(string.getBytes("UTF-8"));
                    }
                    if (i10 >= n2 - 1) continue;
                    outputStream.write(fieldSeparator.getBytes("UTF-8"));
                }
                outputStream.write(crlf.getBytes("UTF-8"));
            }
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage());
        }
    }

    private String encodeField(String string) {
        String string2 = "\"" + string.replaceAll("\"", "\"\"") + "\"";
        string2 = string2.replace("\n", "\"n");
        string2 = string2.replace("\r", "\"r");
        return string2;
    }

    private void writeColumnNames(TableReader tableReader, OutputStream outputStream) throws IOException, SQLException {
        String[] stringArray = tableReader.getColumnNames();
        int n2 = stringArray.length;
        int n3 = 1;
        for (String string : stringArray) {
            outputStream.write(string.getBytes("UTF-8"));
            if (n3++ >= n2) continue;
            outputStream.write(fieldSeparator.getBytes("UTF-8"));
        }
        outputStream.write(crlf.getBytes("UTF-8"));
    }
}

