/*
 * Decompiled with CFR 0.152.
 */
package xsbt.boot.internal.shaded.coursier.util.shaded.org.jsoup.nodes;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.jspecify.annotations.Nullable;
import xsbt.boot.internal.shaded.coursier.util.shaded.org.jsoup.SerializationException;
import xsbt.boot.internal.shaded.coursier.util.shaded.org.jsoup.helper.Validate;
import xsbt.boot.internal.shaded.coursier.util.shaded.org.jsoup.internal.Normalizer;
import xsbt.boot.internal.shaded.coursier.util.shaded.org.jsoup.internal.StringUtil;
import xsbt.boot.internal.shaded.coursier.util.shaded.org.jsoup.nodes.Attribute;
import xsbt.boot.internal.shaded.coursier.util.shaded.org.jsoup.nodes.Document;
import xsbt.boot.internal.shaded.coursier.util.shaded.org.jsoup.parser.ParseSettings;

public class Attributes
implements Cloneable,
Iterable<Attribute> {
    private int size = 0;
    String[] keys = new String[3];
    Object[] vals = new Object[3];

    /*
     * WARNING - void declaration
     */
    private void checkCapacity(int minNewSize) {
        void var2_2;
        int newCap;
        Validate.isTrue(minNewSize >= this.size);
        int curCap = this.keys.length;
        if (curCap >= minNewSize) {
            return;
        }
        int n = newCap = curCap >= 3 ? this.size << 1 : 3;
        if (minNewSize > newCap) {
            void var1_1;
            newCap = var1_1;
        }
        this.keys = Arrays.copyOf(this.keys, newCap);
        this.vals = Arrays.copyOf(this.vals, (int)var2_2);
    }

    int indexOfKey(String key) {
        Validate.notNull(key);
        for (int i = 0; i < this.size; ++i) {
            if (!key.equals(this.keys[i])) continue;
            return i;
        }
        return -1;
    }

    private int indexOfKeyIgnoreCase(String key) {
        Validate.notNull(key);
        for (int i = 0; i < this.size; ++i) {
            if (!key.equalsIgnoreCase(this.keys[i])) continue;
            return i;
        }
        return -1;
    }

    static String checkNotNull(@Nullable Object val) {
        Object object;
        if (val == null) {
            return "";
        }
        return (String)object;
    }

    /*
     * WARNING - void declaration
     */
    public String get(String key) {
        void var1_2;
        int i = this.indexOfKey(key);
        if (i == -1) {
            return "";
        }
        return Attributes.checkNotNull(this.vals[var1_2]);
    }

    /*
     * WARNING - void declaration
     */
    public String getIgnoreCase(String key) {
        void var1_2;
        int i = this.indexOfKeyIgnoreCase(key);
        if (i == -1) {
            return "";
        }
        return Attributes.checkNotNull(this.vals[var1_2]);
    }

    /*
     * WARNING - void declaration
     */
    public Attributes add(String key, @Nullable String value) {
        void var2_2;
        void var1_1;
        this.addObject((String)var1_1, var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    private void addObject(String key, @Nullable Object value) {
        void var2_2;
        void var1_1;
        Attributes attributes = this;
        attributes.checkCapacity(attributes.size + 1);
        this.keys[this.size] = var1_1;
        this.vals[this.size] = var2_2;
        ++this.size;
    }

    /*
     * WARNING - void declaration
     */
    public Attributes put(String key, @Nullable String value) {
        Validate.notNull(key);
        int i = this.indexOfKey(key);
        if (i != -1) {
            this.vals[var3_3] = value;
        } else {
            void var2_2;
            void var1_1;
            this.add((String)var1_1, (String)var2_2);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    Map<String, Object> userData() {
        void var1_2;
        Map userData22;
        int i = this.indexOfKey("/jsoup.userdata");
        if (i == -1) {
            userData22 = new HashMap();
            this.addObject("/jsoup.userdata", userData22);
        } else {
            void userData22;
            userData22 = (Map)this.vals[userData22];
        }
        return var1_2;
    }

    /*
     * WARNING - void declaration
     */
    public @Nullable Object userData(String key) {
        void var1_1;
        Validate.notNull(key);
        if (!this.hasKey("/jsoup.userdata")) {
            return null;
        }
        Map<String, Object> map = this.userData();
        return map.get(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public Attributes userData(String key, Object value) {
        void var2_2;
        void var1_1;
        Validate.notNull(key);
        this.userData().put((String)var1_1, var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    void putIgnoreCase(String key, @Nullable String value) {
        int i = this.indexOfKeyIgnoreCase(key);
        if (i != -1) {
            this.vals[i] = value;
            if (!this.keys[i].equals(key)) {
                this.keys[var3_3] = key;
                return;
            }
        } else {
            void var2_2;
            void var1_1;
            this.add((String)var1_1, (String)var2_2);
        }
    }

    public Attributes put(Attribute attribute) {
        Validate.notNull(attribute);
        this.put(attribute.getKey(), attribute.getValue());
        var1_1.parent = this;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    private void remove(int index) {
        Validate.isFalse(index >= this.size);
        int shifted = this.size - index - 1;
        if (shifted > 0) {
            void var2_2;
            void var1_1;
            System.arraycopy(this.keys, index + 1, this.keys, index, shifted);
            System.arraycopy(this.vals, index + 1, this.vals, (int)var1_1, (int)var2_2);
        }
        --this.size;
        this.keys[this.size] = null;
        this.vals[this.size] = null;
    }

    /*
     * WARNING - void declaration
     */
    public boolean hasKey(String key) {
        void var1_1;
        return this.indexOfKey((String)var1_1) != -1;
    }

    /*
     * WARNING - void declaration
     */
    public boolean hasKeyIgnoreCase(String key) {
        void var1_1;
        return this.indexOfKeyIgnoreCase((String)var1_1) != -1;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    /*
     * WARNING - void declaration
     */
    public void addAll(Attributes incoming) {
        Iterator<Attribute> iterator;
        if (incoming.size() == 0) {
            return;
        }
        Attributes attributes = this;
        attributes.checkCapacity(attributes.size + incoming.size);
        boolean needsPut = this.size != 0;
        iterator = ((Attributes)((Object)iterator)).iterator();
        while (iterator.hasNext()) {
            void var3_3;
            Attribute attr = iterator.next();
            if (needsPut) {
                this.put(attr);
                continue;
            }
            this.add(attr.getKey(), var3_3.getValue());
        }
    }

    @Override
    public Iterator<Attribute> iterator() {
        return new Iterator<Attribute>(this){
            int expectedSize;
            int i;
            final /* synthetic */ Attributes this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.expectedSize = this.this$0.size;
                this.i = 0;
            }

            @Override
            public boolean hasNext() {
                this.checkModified();
                while (this.i < this.this$0.size && Attributes.isInternalKey(this.this$0.keys[this.i])) {
                    ++this.i;
                }
                return this.i < this.this$0.size;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public Attribute next() {
                void var1_1;
                this.checkModified();
                if (this.i >= this.this$0.size) {
                    throw new NoSuchElementException();
                }
                Attribute attr = new Attribute(this.this$0.keys[this.i], (String)this.this$0.vals[this.i], this.this$0);
                ++this.i;
                return var1_1;
            }

            private void checkModified() {
                if (this.this$0.size != this.expectedSize) {
                    throw new ConcurrentModificationException("Use Iterator#remove() instead to remove attributes while iterating.");
                }
            }

            @Override
            public void remove() {
                Attributes.access$100(this.this$0, --this.i);
                --this.expectedSize;
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    public List<Attribute> asList() {
        void var1_1;
        ArrayList<void> list = new ArrayList<void>(this.size);
        for (int i = 0; i < this.size; ++i) {
            void var3_3;
            if (Attributes.isInternalKey(this.keys[i])) continue;
            Attribute attr = new Attribute(this.keys[i], (String)this.vals[i], this);
            list.add(var3_3);
        }
        return Collections.unmodifiableList(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public String html() {
        void var1_1;
        StringBuilder sb = StringUtil.borrowBuilder();
        try {
            this.html(sb, new Document("").outputSettings());
        }
        catch (IOException e) {
            void var1_2;
            throw new SerializationException((Throwable)var1_2);
        }
        return StringUtil.releaseBuilder((StringBuilder)var1_1);
    }

    final void html(Appendable accum2, Document.OutputSettings out) throws IOException {
        int sz = this.size;
        for (int i = 0; i < sz; ++i) {
            String key;
            if (Attributes.isInternalKey(this.keys[i]) || (key = Attribute.getValidKey(this.keys[i], out.syntax())) == null) continue;
            Attribute.htmlNoValidate(key, (String)this.vals[i], accum2.append(' '), out);
        }
    }

    public String toString() {
        return this.html();
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Attributes that = (Attributes)o;
        if (this.size != that.size) {
            return false;
        }
        for (int i = 0; i < this.size; ++i) {
            void var3_3;
            String key = this.keys[i];
            int thatI = that.indexOfKey(key);
            if (thatI == -1) {
                return false;
            }
            Object val = this.vals[i];
            Object thatVal = that.vals[thatI];
            if (!(val == null ? thatVal != null : !val.equals(var3_3))) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public int hashCode() {
        void var1_1;
        int result = this.size;
        result = result * 31 + Arrays.hashCode(this.keys);
        var1_1 = var1_1 * 31 + Arrays.hashCode(this.vals);
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Attributes clone() {
        void var1_1;
        try {
            Attributes clone = (Attributes)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        clone.size = this.size;
        clone.keys = Arrays.copyOf(this.keys, this.size);
        clone.vals = Arrays.copyOf(this.vals, this.size);
        return var1_1;
    }

    public void normalize() {
        for (int i = 0; i < this.size; ++i) {
            if (Attributes.isInternalKey(this.keys[i])) continue;
            this.keys[i] = Normalizer.lowerCase(this.keys[i]);
        }
    }

    /*
     * WARNING - void declaration
     */
    public int deduplicate(ParseSettings settings) {
        void var2_3;
        if (this.isEmpty()) {
            return 0;
        }
        boolean preserve = settings.preserveAttributeCase();
        int dupes = 0;
        for (int i = 0; i < this.keys.length; ++i) {
            for (int j = i + 1; j < this.keys.length && this.keys[j] != null; ++j) {
                if ((!preserve || !this.keys[i].equals(this.keys[j])) && (preserve || !this.keys[i].equalsIgnoreCase(this.keys[j]))) continue;
                ++dupes;
                this.remove(j);
                --j;
            }
        }
        return (int)var2_3;
    }

    static String internalKey(String key) {
        String string;
        return "/" + string;
    }

    static boolean isInternalKey(String key) {
        String string;
        return key != null && key.length() > 1 && string.charAt(0) == '/';
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$100(Attributes x0, int x1) {
        void var1_1;
        x0.remove((int)var1_1);
    }
}

