/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.startup.importSettings.jb;

import com.intellij.ide.startup.importSettings.ImportSettingsBundle;
import com.intellij.ide.startup.importSettings.data.DialogImportItem;
import com.intellij.ide.startup.importSettings.data.IconProductSize;
import com.intellij.ide.startup.importSettings.data.ImportFromProduct;
import com.intellij.ide.startup.importSettings.data.SettingsContributor;
import com.intellij.ide.startup.importSettings.jb.JbProductInfo;
import com.intellij.ide.startup.importSettings.jb.NameMappings;
import com.intellij.ide.startup.importSettings.transfer.TransferSettingsProgressIndicator;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0019\u0010\f\u001a\u00070\r\u00a2\u0006\u0002\b\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0015"}, d2={"Lcom/intellij/ide/startup/importSettings/jb/JbImportDataDialog;", "Lcom/intellij/ide/startup/importSettings/data/ImportFromProduct;", "productInfo", "Lcom/intellij/ide/startup/importSettings/jb/JbProductInfo;", "<init>", "(Lcom/intellij/ide/startup/importSettings/jb/JbProductInfo;)V", "from", "Lcom/intellij/ide/startup/importSettings/data/DialogImportItem;", "getFrom", "()Lcom/intellij/ide/startup/importSettings/data/DialogImportItem;", "to", "getTo", "message", "", "Lorg/jetbrains/annotations/Nls;", "getMessage", "()Ljava/lang/String;", "progress", "Lcom/intellij/ide/startup/importSettings/transfer/TransferSettingsProgressIndicator;", "getProgress", "()Lcom/intellij/ide/startup/importSettings/transfer/TransferSettingsProgressIndicator;", "intellij.ide.startup.importSettings"})
public final class JbImportDataDialog
implements ImportFromProduct {
    @NotNull
    private final JbProductInfo productInfo;
    @NotNull
    private final DialogImportItem from;
    @NotNull
    private final DialogImportItem to;
    @NotNull
    private final String message;
    @NotNull
    private final TransferSettingsProgressIndicator progress;

    public JbImportDataDialog(@NotNull JbProductInfo productInfo) {
        Intrinsics.checkNotNullParameter((Object)productInfo, (String)"productInfo");
        this.productInfo = productInfo;
        SettingsContributor settingsContributor = this.productInfo;
        Icon icon = NameMappings.INSTANCE.getIcon(this.productInfo.getCodeName$intellij_ide_startup_importSettings(), IconProductSize.LARGE);
        Intrinsics.checkNotNull((Object)icon);
        this.from = new DialogImportItem(settingsContributor, icon);
        this.to = DialogImportItem.Companion.self();
        Object[] objectArray = new Object[]{this.productInfo.getName()};
        this.message = ImportSettingsBundle.INSTANCE.message("transfer.settings.message", objectArray);
        this.progress = new TransferSettingsProgressIndicator();
    }

    @Override
    @NotNull
    public DialogImportItem getFrom() {
        return this.from;
    }

    @Override
    @NotNull
    public DialogImportItem getTo() {
        return this.to;
    }

    @Override
    @NotNull
    public String getMessage() {
        return this.message;
    }

    @Override
    @NotNull
    public TransferSettingsProgressIndicator getProgress() {
        return this.progress;
    }
}

